/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.local.model;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.Category;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.moduleconverter.dependencies.LocalConfigurationMetadataBuilder;
import org.gradle.api.internal.attributes.AttributeValue;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.Describables;
import org.gradle.internal.DisplayName;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.local.model.BuildableLocalConfigurationMetadata;
import org.gradle.internal.component.local.model.DefaultLocalComponentMetadata;
import org.gradle.internal.component.local.model.LocalComponentArtifactMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationGraphResolveMetadata;
import org.gradle.internal.component.local.model.LocalConfigurationMetadata;
import org.gradle.internal.component.local.model.LocalFileDependencyMetadata;
import org.gradle.internal.component.local.model.LocalVariantMetadata;
import org.gradle.internal.component.local.model.MissingLocalArtifactMetadata;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.component.model.LocalOriginDependencyMetadata;
import org.gradle.internal.component.model.VariantResolveMetadata;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.model.CalculatedValueContainer;
import org.gradle.internal.model.CalculatedValueContainerFactory;
import org.gradle.internal.model.ModelContainer;

public class DefaultLocalConfigurationMetadata
implements LocalConfigurationMetadata,
BuildableLocalConfigurationMetadata,
LocalConfigurationGraphResolveMetadata {
    private final String name;
    private final String description;
    private final boolean transitive;
    private final boolean visible;
    private final ImmutableSet<String> hierarchy;
    private final Set<String> extendsFrom;
    private final ImmutableAttributes attributes;
    private final boolean canBeConsumed;
    private final DeprecationMessageBuilder.WithDocumentation consumptionDeprecation;
    private final boolean canBeResolved;
    private final ImmutableCapabilities capabilities;
    private final ModelContainer<?> model;
    private final CalculatedValueContainerFactory factory;
    private final DefaultLocalComponentMetadata component;
    public ConfigurationInternal backingConfiguration;
    private boolean reevaluate = true;
    public LocalConfigurationMetadataBuilder configurationMetadataBuilder;
    public final List<LocalOriginDependencyMetadata> definedDependencies = Lists.newArrayList();
    public final List<ExcludeMetadata> definedExcludes = Lists.newArrayList();
    public final List<LocalFileDependencyMetadata> definedFiles = Lists.newArrayList();
    private ImmutableList<LocalOriginDependencyMetadata> configurationDependencies;
    private ImmutableSet<LocalFileDependencyMetadata> configurationFileDependencies;
    private ImmutableList<ExcludeMetadata> configurationExcludes;
    public List<PublishArtifact> sourceArtifacts = Lists.newArrayList();
    public CalculatedValueContainer<ImmutableList<LocalComponentArtifactMetadata>, ?> artifacts;
    public final Set<LocalVariantMetadata> variants = new LinkedHashSet<LocalVariantMetadata>();

    public DefaultLocalConfigurationMetadata(String name, String description, boolean visible, boolean transitive, Set<String> extendsFrom, ImmutableSet<String> hierarchy, ImmutableAttributes attributes, boolean canBeConsumed, DeprecationMessageBuilder.WithDocumentation consumptionDeprecation, boolean canBeResolved, ImmutableCapabilities capabilities, ModelContainer<?> model, CalculatedValueContainerFactory factory, DefaultLocalComponentMetadata component) {
        this.name = name;
        this.description = description;
        this.transitive = transitive;
        this.visible = visible;
        this.hierarchy = hierarchy;
        this.extendsFrom = extendsFrom;
        this.attributes = attributes;
        this.canBeConsumed = canBeConsumed;
        this.consumptionDeprecation = consumptionDeprecation;
        this.canBeResolved = canBeResolved;
        this.capabilities = capabilities;
        this.model = model;
        this.factory = factory;
        this.component = component;
        this.artifacts = factory.create(Describables.of((Object)description, (Object)"artifacts"), context -> {
            if (this.sourceArtifacts.isEmpty() && hierarchy.isEmpty()) {
                this.sourceArtifacts = null;
                return ImmutableList.of();
            }
            return (ImmutableList)model.fromMutableState(m -> {
                LinkedHashSet<LocalComponentArtifactMetadata> result = new LinkedHashSet<LocalComponentArtifactMetadata>(this.sourceArtifacts.size());
                for (PublishArtifact sourceArtifact : this.sourceArtifacts) {
                    result.add(new PublishArtifactLocalArtifactMetadata(component.getId(), sourceArtifact));
                }
                for (String config : hierarchy) {
                    if (config.equals(name)) continue;
                    DefaultLocalConfigurationMetadata parent = component.getConfiguration(config);
                    parent.prepareToResolveArtifacts();
                    result.addAll((Collection<LocalComponentArtifactMetadata>)parent.getArtifacts());
                }
                this.sourceArtifacts = null;
                return ImmutableList.copyOf(result);
            });
        });
    }

    @Override
    public ComponentIdentifier getComponentId() {
        return this.component.getId();
    }

    @Override
    public void addDependency(LocalOriginDependencyMetadata dependency) {
        this.definedDependencies.add(dependency);
    }

    @Override
    public void addExclude(ExcludeMetadata exclude) {
        this.definedExcludes.add(exclude);
    }

    @Override
    public void addFiles(LocalFileDependencyMetadata files) {
        this.definedFiles.add(files);
    }

    public String toString() {
        return this.asDescribable().getDisplayName();
    }

    @Override
    public DisplayName asDescribable() {
        return Describables.of((Object)this.component.getId(), (Object)"configuration", (Object)this.name);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Set<String> getExtendsFrom() {
        return this.extendsFrom;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ImmutableSet<String> getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public boolean isTransitive() {
        return this.transitive;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public ImmutableAttributes getAttributes() {
        return this.attributes;
    }

    public Set<LocalVariantMetadata> getVariants() {
        return this.variants;
    }

    @Override
    public boolean isCanBeConsumed() {
        return this.canBeConsumed;
    }

    @Override
    public DeprecationMessageBuilder.WithDocumentation getConsumptionDeprecation() {
        return this.consumptionDeprecation;
    }

    @Override
    public boolean isCanBeResolved() {
        return this.canBeResolved;
    }

    @Override
    public List<? extends LocalOriginDependencyMetadata> getDependencies() {
        if (this.configurationDependencies == null) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (String configurationName : this.component.getConfigurationNames()) {
                if (!this.include(configurationName)) continue;
                this.component.getConfiguration(configurationName).addDefinedDependencies((ImmutableList.Builder<LocalOriginDependencyMetadata>)result);
            }
            AttributeValue attributeValue = this.getAttributes().findEntry(Category.CATEGORY_ATTRIBUTE);
            if (attributeValue.isPresent() && ((Category)attributeValue.get()).getName().equals("enforced-platform")) {
                ImmutableList rawDependencies = result.build();
                result = ImmutableList.builder();
                for (LocalOriginDependencyMetadata rawDependency : rawDependencies) {
                    result.add((Object)rawDependency.forced());
                }
            }
            this.configurationDependencies = result.build();
        }
        return this.configurationDependencies;
    }

    void addDefinedDependencies(ImmutableList.Builder<LocalOriginDependencyMetadata> result) {
        this.realizeDependencies();
        result.addAll(this.definedDependencies);
    }

    @Override
    public Set<LocalFileDependencyMetadata> getFiles() {
        if (this.configurationFileDependencies == null) {
            ImmutableSet.Builder result = ImmutableSet.builder();
            for (String configurationName : this.component.getConfigurationNames()) {
                if (!this.include(configurationName)) continue;
                this.component.getConfiguration(configurationName).addDefinedFiles((ImmutableSet.Builder<LocalFileDependencyMetadata>)result);
            }
            this.configurationFileDependencies = result.build();
        }
        return this.configurationFileDependencies;
    }

    void addDefinedFiles(ImmutableSet.Builder<LocalFileDependencyMetadata> result) {
        this.realizeDependencies();
        result.addAll(this.definedFiles);
    }

    @Override
    public ImmutableList<ExcludeMetadata> getExcludes() {
        if (this.configurationExcludes == null) {
            ImmutableList.Builder result = ImmutableList.builder();
            for (String configurationName : this.component.getConfigurationNames()) {
                if (!this.include(configurationName)) continue;
                this.component.getConfiguration(configurationName).addDefinedExcludes((ImmutableList.Builder<ExcludeMetadata>)result);
            }
            this.configurationExcludes = result.build();
        }
        return this.configurationExcludes;
    }

    void addDefinedExcludes(ImmutableList.Builder<ExcludeMetadata> result) {
        this.realizeDependencies();
        result.addAll(this.definedExcludes);
    }

    @Override
    public void addArtifacts(Collection<? extends PublishArtifact> artifacts) {
        this.sourceArtifacts.addAll(artifacts);
    }

    @Override
    public LocalConfigurationMetadata prepareToResolveArtifacts() {
        this.artifacts.finalizeIfNotAlready();
        for (LocalVariantMetadata variant : this.variants) {
            variant.prepareToResolveArtifacts();
        }
        return this;
    }

    public ImmutableList<LocalComponentArtifactMetadata> getArtifacts() {
        return (ImmutableList)this.artifacts.get();
    }

    @Override
    public ComponentArtifactMetadata artifact(IvyArtifactName ivyArtifactName) {
        for (ComponentArtifactMetadata candidate : this.getArtifacts()) {
            if (!candidate.getName().equals(ivyArtifactName)) continue;
            return candidate;
        }
        return new MissingLocalArtifactMetadata(this.component.getId(), ivyArtifactName);
    }

    public ImmutableCapabilities getCapabilities() {
        return this.capabilities;
    }

    @Override
    public boolean isExternalVariant() {
        return false;
    }

    private boolean include(String configurationName) {
        return this.hierarchy.contains((Object)configurationName);
    }

    @Override
    public void addVariant(String name, VariantResolveMetadata.Identifier identifier, DisplayName displayName, ImmutableAttributes attributes, ImmutableCapabilities capabilities, Collection<? extends PublishArtifact> artifacts) {
        this.variants.add(new LocalVariantMetadata(name, identifier, this.component.getId(), displayName, attributes, artifacts, capabilities, this.model, this.factory));
    }

    synchronized void realizeDependencies() {
        if (this.reevaluate && this.backingConfiguration != null) {
            this.backingConfiguration.runDependencyActions();
            this.configurationMetadataBuilder.addDependenciesAndExcludes(this, this.backingConfiguration);
        }
        this.reevaluate = false;
    }

    synchronized void reevaluate() {
        this.definedDependencies.clear();
        this.definedFiles.clear();
        this.definedExcludes.clear();
        this.configurationDependencies = null;
        this.configurationExcludes = null;
        this.configurationFileDependencies = null;
        this.reevaluate = true;
    }

    @Override
    public boolean needsReevaluate() {
        return this.reevaluate;
    }
}

