/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.configurations;

import java.util.Optional;
import org.apache.commons.lang.WordUtils;
import org.gradle.api.internal.artifacts.configurations.ConfigurationRole;

public enum ConfigurationRoles implements ConfigurationRole
{
    LEGACY(true, true, true, false, false, false),
    INTENDED_CONSUMABLE(true, false, false, false, false, false),
    INTENDED_RESOLVABLE(false, true, false, false, false, false),
    INTENDED_RESOLVABLE_BUCKET(false, true, true, false, false, false),
    INTENDED_CONSUMABLE_BUCKET(true, false, true, false, false, false),
    INTENDED_BUCKET(false, false, true, false, false, false),
    DEPRECATED_CONSUMABLE(true, true, true, false, true, true),
    DEPRECATED_RESOLVABLE(true, true, true, true, false, true);

    private final boolean consumable;
    private final boolean resolvable;
    private final boolean declarableAgainst;
    private final boolean consumptionDeprecated;
    private final boolean resolutionDeprecated;
    private final boolean declarationAgainstDeprecated;

    public static Optional<ConfigurationRoles> byUsage(boolean consumable, boolean resolvable, boolean declarableAgainst, boolean consumptionDeprecated, boolean resolutionDeprecated, boolean declarationAgainstDeprecated) {
        for (ConfigurationRoles role : ConfigurationRoles.values()) {
            if (role.consumable != consumable || role.resolvable != resolvable || role.declarableAgainst != declarableAgainst || role.consumptionDeprecated != consumptionDeprecated || role.resolutionDeprecated != resolutionDeprecated || role.declarationAgainstDeprecated != declarationAgainstDeprecated) continue;
            return Optional.of(role);
        }
        return Optional.empty();
    }

    private ConfigurationRoles(boolean consumable, boolean resolvable, boolean declarableAgainst, boolean consumptionDeprecated, boolean resolutionDeprecated, boolean declarationAgainstDeprecated) {
        this.consumable = consumable;
        this.resolvable = resolvable;
        this.declarableAgainst = declarableAgainst;
        this.consumptionDeprecated = consumptionDeprecated;
        this.resolutionDeprecated = resolutionDeprecated;
        this.declarationAgainstDeprecated = declarationAgainstDeprecated;
    }

    @Override
    public String getName() {
        return this.upperSnakeToProperCase(this.name());
    }

    @Override
    public boolean isConsumable() {
        return this.consumable;
    }

    @Override
    public boolean isResolvable() {
        return this.resolvable;
    }

    @Override
    public boolean isDeclarableAgainst() {
        return this.declarableAgainst;
    }

    @Override
    public boolean isConsumptionDeprecated() {
        return this.consumptionDeprecated;
    }

    @Override
    public boolean isResolutionDeprecated() {
        return this.resolutionDeprecated;
    }

    @Override
    public boolean isDeclarationAgainstDeprecated() {
        return this.declarationAgainstDeprecated;
    }

    private String upperSnakeToProperCase(String name) {
        return WordUtils.capitalizeFully((String)name.replaceAll("_", " "));
    }
}

