/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.history.changes;

import com.google.common.collect.ImmutableSortedMap;
import java.util.SortedMap;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.execution.history.changes.DefaultInputFileChanges;
import org.gradle.internal.execution.history.changes.InputFileChanges;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprint;

public interface IncrementalInputProperties {
    public static final IncrementalInputProperties NONE = new IncrementalInputProperties(){

        @Override
        public String getPropertyNameFor(Object value) {
            throw new InvalidUserDataException("Cannot query incremental changes for property " + value + ": No incremental properties declared.");
        }

        @Override
        public InputFileChanges nonIncrementalChanges(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
            return new DefaultInputFileChanges((SortedMap<String, FileCollectionFingerprint>)previous, (SortedMap<String, CurrentFileCollectionFingerprint>)current);
        }

        @Override
        public InputFileChanges incrementalChanges(ImmutableSortedMap<String, FileCollectionFingerprint> previous, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> current) {
            return InputFileChanges.EMPTY;
        }
    };

    public String getPropertyNameFor(Object var1);

    public InputFileChanges nonIncrementalChanges(ImmutableSortedMap<String, FileCollectionFingerprint> var1, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> var2);

    public InputFileChanges incrementalChanges(ImmutableSortedMap<String, FileCollectionFingerprint> var1, ImmutableSortedMap<String, CurrentFileCollectionFingerprint> var2);
}

