/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.reporting.components.internal;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.gradle.api.reporting.components.internal.RendererUtils;
import org.gradle.api.reporting.components.internal.SourceSetRenderer;
import org.gradle.api.tasks.diagnostics.internal.text.TextReportBuilder;
import org.gradle.internal.logging.text.DiagnosticsVisitor;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.model.ModelMap;
import org.gradle.model.internal.manage.schema.ModelProperty;
import org.gradle.model.internal.manage.schema.ModelSchema;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.manage.schema.StructSchema;
import org.gradle.platform.base.BinarySpec;
import org.gradle.platform.base.internal.BinaryBuildAbility;
import org.gradle.platform.base.internal.BinarySpecInternal;
import org.gradle.platform.base.internal.VariantAspect;
import org.gradle.reporting.ReportRenderer;
import org.gradle.util.internal.GUtil;

@ServiceScope(value={Scope.Global.class})
public abstract class AbstractBinaryRenderer<T extends BinarySpec>
extends ReportRenderer<BinarySpec, TextReportBuilder> {
    private final ModelSchemaStore schemaStore;

    protected AbstractBinaryRenderer(ModelSchemaStore schemaStore) {
        this.schemaStore = schemaStore;
    }

    public void render(BinarySpec binary, TextReportBuilder builder) {
        String heading = StringUtils.capitalize((String)binary.getDisplayName());
        if (!binary.isBuildable()) {
            heading = heading + " (not buildable)";
        }
        builder.heading(heading);
        if (binary.getBuildTask() != null) {
            builder.item("build using task", binary.getBuildTask().getPath());
        }
        BinarySpec specialized = (BinarySpec)this.getTargetType().cast(binary);
        this.renderTasks(specialized, builder);
        this.renderVariants(specialized, builder);
        this.renderDetails(specialized, builder);
        this.renderOutputs(specialized, builder);
        this.renderBuildAbility(specialized, builder);
        this.renderOwnedSourceSets(specialized, builder);
    }

    public abstract Class<T> getTargetType();

    protected void renderOutputs(T binary, TextReportBuilder builder) {
    }

    protected void renderVariants(T binary, TextReportBuilder builder) {
        ModelSchema schema = this.schemaStore.getSchema(((BinarySpecInternal)binary).getPublicType());
        if (!(schema instanceof StructSchema)) {
            return;
        }
        TreeMap<String, Object> variants = new TreeMap<String, Object>();
        VariantAspect variantAspect = (VariantAspect)((StructSchema)schema).getAspect(VariantAspect.class);
        if (variantAspect != null) {
            for (ModelProperty modelProperty : variantAspect.getDimensions()) {
                variants.put(modelProperty.getName(), modelProperty.getPropertyValue(binary));
            }
        }
        for (Map.Entry entry : variants.entrySet()) {
            String variantName = GUtil.toWords((CharSequence)((CharSequence)entry.getKey()));
            builder.item(variantName, RendererUtils.displayValueOf(entry.getValue()));
        }
    }

    protected void renderDetails(T binary, TextReportBuilder builder) {
    }

    protected void renderTasks(T binary, TextReportBuilder builder) {
    }

    private void renderBuildAbility(BinarySpec binary, TextReportBuilder builder) {
        BinaryBuildAbility buildAbility = ((BinarySpecInternal)binary).getBuildAbility();
        if (!buildAbility.isBuildable()) {
            TreeFormatter formatter = new TreeFormatter();
            buildAbility.explain((DiagnosticsVisitor)formatter);
            builder.item(formatter.toString());
        }
    }

    protected void renderOwnedSourceSets(T binary, TextReportBuilder builder) {
        if (((BinarySpecInternal)binary).isLegacyBinary()) {
            return;
        }
        ModelMap sources = binary.getSources();
        if (!sources.isEmpty()) {
            SourceSetRenderer sourceSetRenderer = new SourceSetRenderer();
            builder.collection("source sets", sources.values(), sourceSetRenderer, "source sets");
        }
    }
}

