/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import groovy.lang.Closure;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import javax.annotation.Nullable;
import org.gradle.api.NonNullApi;
import org.gradle.internal.classpath.CallInterceptingMetaClass;
import org.gradle.internal.classpath.InstrumentedGroovyCallsHelper;
import org.gradle.internal.classpath.intercept.CallInterceptorResolver;
import org.gradle.internal.instrumentation.api.types.BytecodeInterceptorFilter;

@NonNullApi
public class InstrumentedGroovyMetaClassHelper {
    public static void addInvocationHooksInClosureDispatchObject(@Nullable Object object, boolean isEffectivelyInstrumented, BytecodeInterceptorFilter interceptorFilter) {
        if (object == null) {
            return;
        }
        if (isEffectivelyInstrumented) {
            CallInterceptorResolver resolver = CallInterceptorResolver.ClosureCallInterceptorResolver.of(interceptorFilter);
            InstrumentedGroovyMetaClassHelper.addInvocationHooksToMetaClass(object.getClass(), resolver);
        }
    }

    public static void addInvocationHooksToEffectivelyInstrumentClosure(Closure<?> closure, BytecodeInterceptorFilter interceptorFilter) {
        CallInterceptorResolver resolver = CallInterceptorResolver.ClosureCallInterceptorResolver.of(interceptorFilter);
        InstrumentedGroovyMetaClassHelper.addInvocationHooksToMetaClass(closure.getThisObject().getClass(), resolver);
        InstrumentedGroovyMetaClassHelper.addInvocationHooksToMetaClass(closure.getOwner().getClass(), resolver);
        if (closure.getDelegate() != null) {
            InstrumentedGroovyMetaClassHelper.addInvocationHooksToMetaClass(closure.getDelegate().getClass(), resolver);
        }
    }

    public static void addInvocationHooksToMetaClassIfInstrumented(Class<?> javaClass, String callableName) {
        CallInterceptorResolver resolver = CallInterceptorResolver.ClosureCallInterceptorResolver.of(BytecodeInterceptorFilter.ALL);
        if (resolver.isAwareOfCallSiteName(callableName)) {
            InstrumentedGroovyMetaClassHelper.addInvocationHooksToMetaClass(javaClass, resolver);
        }
    }

    private static void addInvocationHooksToMetaClass(Class<?> javaClass, CallInterceptorResolver resolver) {
        MetaClassRegistry metaClassRegistry = GroovySystem.getMetaClassRegistry();
        MetaClass originalMetaClass = metaClassRegistry.getMetaClass(javaClass);
        if (!(originalMetaClass instanceof CallInterceptingMetaClass)) {
            metaClassRegistry.setMetaClass(javaClass, (MetaClass)InstrumentedGroovyMetaClassHelper.interceptedMetaClass(javaClass, metaClassRegistry, originalMetaClass, resolver));
        }
    }

    private static CallInterceptingMetaClass interceptedMetaClass(Class<?> javaClass, MetaClassRegistry metaClassRegistry, MetaClass originalMetaClass, CallInterceptorResolver resolver) {
        return new CallInterceptingMetaClass(metaClassRegistry, javaClass, originalMetaClass, InstrumentedGroovyCallsHelper.INSTANCE, resolver);
    }
}

