/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize.codecs.dm;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.transform.ArtifactVariantSelector;
import org.gradle.api.internal.artifacts.transform.TransformUpstreamDependenciesResolver;
import org.gradle.api.internal.artifacts.transform.TransformedVariantFactory;
import org.gradle.api.internal.artifacts.transform.VariantDefinition;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.serialize.codecs.dm.EmptyDependenciesResolverFactory;
import org.gradle.internal.serialize.codecs.dm.IdentityMapping;
import org.gradle.internal.serialize.codecs.dm.MappingSpec;
import org.gradle.internal.serialize.codecs.dm.TransformMapping;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/gradle/internal/serialize/codecs/dm/FixedArtifactVariantSelector;", "Lorg/gradle/api/internal/artifacts/transform/ArtifactVariantSelector;", "matchingOnArtifactFormat", "", "transforms", "", "Lorg/gradle/api/internal/attributes/ImmutableAttributes;", "Lorg/gradle/internal/serialize/codecs/dm/MappingSpec;", "transformedVariantFactory", "Lorg/gradle/api/internal/artifacts/transform/TransformedVariantFactory;", "(ZLjava/util/Map;Lorg/gradle/api/internal/artifacts/transform/TransformedVariantFactory;)V", "select", "Lorg/gradle/api/internal/artifacts/ivyservice/resolveengine/artifact/ResolvedArtifactSet;", "candidates", "Lorg/gradle/api/internal/artifacts/ivyservice/resolveengine/artifact/ResolvedVariantSet;", "requestAttributes", "allowNoMatchingVariants", "resolvedArtifactTransformer", "Lorg/gradle/api/internal/artifacts/transform/ArtifactVariantSelector$ResolvedArtifactTransformer;", "dependency-management-serialization-codecs"})
final class FixedArtifactVariantSelector
implements ArtifactVariantSelector {
    private final boolean matchingOnArtifactFormat;
    @NotNull
    private final Map<ImmutableAttributes, MappingSpec> transforms;
    @NotNull
    private final TransformedVariantFactory transformedVariantFactory;

    public FixedArtifactVariantSelector(boolean matchingOnArtifactFormat, @NotNull Map<ImmutableAttributes, ? extends MappingSpec> transforms, @NotNull TransformedVariantFactory transformedVariantFactory) {
        Intrinsics.checkNotNullParameter(transforms, (String)"transforms");
        Intrinsics.checkNotNullParameter((Object)transformedVariantFactory, (String)"transformedVariantFactory");
        this.matchingOnArtifactFormat = matchingOnArtifactFormat;
        this.transforms = transforms;
        this.transformedVariantFactory = transformedVariantFactory;
    }

    @NotNull
    public ResolvedArtifactSet select(@NotNull ResolvedVariantSet candidates, @NotNull ImmutableAttributes requestAttributes, boolean allowNoMatchingVariants, @NotNull ArtifactVariantSelector.ResolvedArtifactTransformer resolvedArtifactTransformer) {
        ResolvedArtifactSet resolvedArtifactSet;
        Intrinsics.checkNotNullParameter((Object)candidates, (String)"candidates");
        Intrinsics.checkNotNullParameter((Object)requestAttributes, (String)"requestAttributes");
        Intrinsics.checkNotNullParameter((Object)resolvedArtifactTransformer, (String)"resolvedArtifactTransformer");
        if (!(candidates.getVariants().size() == 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        List list = candidates.getVariants();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"candidates.variants");
        ResolvedVariant variant = (ResolvedVariant)CollectionsKt.first((List)list);
        MappingSpec spec = this.transforms.get(variant.getAttributes().asImmutable());
        if (spec == null) {
            ResolvedArtifactSet resolvedArtifactSet2 = this.matchingOnArtifactFormat ? ResolvedArtifactSet.EMPTY : variant.getArtifacts();
            resolvedArtifactSet = resolvedArtifactSet2;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifactSet2, (String)"{\n                // no \u2026          }\n            }");
        } else if (spec instanceof IdentityMapping) {
            ResolvedArtifactSet resolvedArtifactSet3 = variant.getArtifacts();
            resolvedArtifactSet = resolvedArtifactSet3;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifactSet3, (String)"variant.artifacts");
        } else if (spec instanceof TransformMapping) {
            ResolvedArtifactSet resolvedArtifactSet4 = resolvedArtifactTransformer.asTransformed(variant, (VariantDefinition)spec, (TransformUpstreamDependenciesResolver)new EmptyDependenciesResolverFactory(), this.transformedVariantFactory);
            resolvedArtifactSet = resolvedArtifactSet4;
            Intrinsics.checkNotNullExpressionValue((Object)resolvedArtifactSet4, (String)"resolvedArtifactTransfor\u2026ransformedVariantFactory)");
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return resolvedArtifactSet;
    }
}

