/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.File;
import java.io.InputStream;
import org.gradle.internal.logging.console.GlobalUserInputReceiver;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.service.Provides;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistrationProvider;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.Scope;
import org.gradle.internal.service.scopes.ServiceScope;
import org.gradle.launcher.daemon.client.DaemonClientMessageServices;
import org.gradle.launcher.daemon.client.DaemonClientServices;
import org.gradle.launcher.daemon.client.SingleUseDaemonClientServices;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.launcher.daemon.context.DaemonRequestContext;
import org.gradle.launcher.daemon.registry.DaemonRegistryServices;
import org.gradle.launcher.daemon.toolchain.DaemonClientToolchainServices;

@ServiceScope(value={Scope.Global.class})
public class DaemonClientFactory {
    private final ServiceRegistry sharedServices;

    public DaemonClientFactory(ServiceRegistry sharedServices) {
        this.sharedServices = sharedServices;
    }

    public ServiceRegistry createBuildClientServices(ServiceLookup clientLoggingServices, DaemonParameters daemonParameters, DaemonRequestContext requestContext, InputStream stdin) {
        return this.clientServicesBuilder(clientLoggingServices, daemonParameters, requestContext).provider((ServiceRegistrationProvider)new DaemonClientServices(stdin)).build();
    }

    public ServiceRegistry createSingleUseDaemonClientServices(ServiceLookup clientLoggingServices, DaemonParameters daemonParameters, DaemonRequestContext requestContext, InputStream stdin) {
        return this.clientServicesBuilder(clientLoggingServices, daemonParameters, requestContext).provider((ServiceRegistrationProvider)new SingleUseDaemonClientServices(stdin)).build();
    }

    private ServiceRegistryBuilder clientServicesBuilder(ServiceLookup clientLoggingServices, final DaemonParameters daemonParameters, final DaemonRequestContext requestContext) {
        ServiceRegistry loggingServices = this.createLoggingServices(clientLoggingServices);
        return ServiceRegistryBuilder.builder().displayName("daemon client services").parent(loggingServices).provider(new ServiceRegistrationProvider(){

            @Provides
            DaemonParameters createDaemonParameters() {
                return daemonParameters;
            }

            @Provides
            DaemonRequestContext createDaemonRequestContext() {
                return requestContext;
            }
        }).provider((ServiceRegistrationProvider)new DaemonRegistryServices(daemonParameters.getBaseDir())).provider((ServiceRegistrationProvider)new DaemonClientToolchainServices(daemonParameters.getToolchainConfiguration()));
    }

    private ServiceRegistry createLoggingServices(ServiceLookup clientLoggingServices) {
        final OutputEventListener clientOutputEventListener = (OutputEventListener)clientLoggingServices.get(OutputEventListener.class);
        final GlobalUserInputReceiver clientGlobalUserInputReceiver = (GlobalUserInputReceiver)clientLoggingServices.get(GlobalUserInputReceiver.class);
        return ServiceRegistryBuilder.builder().displayName("logging services").parent(this.sharedServices).provider(new ServiceRegistrationProvider(){

            void configure(ServiceRegistration registration) {
                registration.add(OutputEventListener.class, (Object)clientOutputEventListener);
                registration.add(GlobalUserInputReceiver.class, (Object)clientGlobalUserInputReceiver);
            }
        }).build();
    }

    public ServiceRegistry createMessageDaemonServices(ServiceLookup clientLoggingServices, File daemonBaseDir) {
        ServiceRegistry loggingServices = this.createLoggingServices(clientLoggingServices);
        return ServiceRegistryBuilder.builder().displayName("daemon client services").parent(loggingServices).provider((ServiceRegistrationProvider)new DaemonRegistryServices(daemonBaseDir)).provider((ServiceRegistrationProvider)new DaemonClientMessageServices()).build();
    }
}

