/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.compile;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.SetProperty;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.compile.AbstractOptions;
import org.gradle.api.tasks.compile.GroovyForkOptions;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;

public abstract class GroovyCompileOptions
extends AbstractOptions {
    private static final long serialVersionUID = 0L;
    private boolean failOnError = true;
    private boolean verbose;
    private boolean listFiles;
    private String encoding = "UTF-8";
    private boolean fork = true;
    private boolean keepStubs;
    private List<String> fileExtensions = ImmutableList.of((Object)"java", (Object)"groovy");
    private GroovyForkOptions forkOptions = (GroovyForkOptions)((Object)this.getObjectFactory().newInstance(GroovyForkOptions.class, new Object[0]));
    private Map<String, Boolean> optimizationOptions = new HashMap<String, Boolean>();
    private File stubDir;
    private File configurationScript;
    private boolean javaAnnotationProcessing;
    private boolean parameters;
    private final SetProperty<String> disabledGlobalASTTransformations = this.getObjectFactory().setProperty(String.class);

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    @Console
    @ToBeReplacedByLazyProperty
    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Console
    @ToBeReplacedByLazyProperty
    public boolean isListFiles() {
        return this.listFiles;
    }

    public void setListFiles(boolean listFiles) {
        this.listFiles = listFiles;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }

    @Nullable
    @Optional
    @PathSensitive(value=PathSensitivity.NONE)
    @InputFile
    @ToBeReplacedByLazyProperty
    public File getConfigurationScript() {
        return this.configurationScript;
    }

    public void setConfigurationScript(@Nullable File configurationFile) {
        this.configurationScript = configurationFile;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isJavaAnnotationProcessing() {
        return this.javaAnnotationProcessing;
    }

    public void setJavaAnnotationProcessing(boolean javaAnnotationProcessing) {
        this.javaAnnotationProcessing = javaAnnotationProcessing;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isParameters() {
        return this.parameters;
    }

    public void setParameters(boolean parameters) {
        this.parameters = parameters;
    }

    @Nested
    public GroovyForkOptions getForkOptions() {
        return this.forkOptions;
    }

    @Deprecated
    public void setForkOptions(GroovyForkOptions forkOptions) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(GroovyCompileOptions.class, (String)"setForkOptions(GroovyForkOptions)").replaceWith((Object)"forkOptions(Action)")).withContext("Setting a new instance of forkOptions is unnecessary.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_nested_properties_setters")).nagUser();
        this.forkOptions = forkOptions;
    }

    public void forkOptions(Action<? super GroovyForkOptions> action) {
        action.execute((Object)this.forkOptions);
    }

    @Nullable
    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public Map<String, Boolean> getOptimizationOptions() {
        return this.optimizationOptions;
    }

    public void setOptimizationOptions(@Nullable Map<String, Boolean> optimizationOptions) {
        this.optimizationOptions = optimizationOptions;
    }

    @Input
    public SetProperty<String> getDisabledGlobalASTTransformations() {
        return this.disabledGlobalASTTransformations;
    }

    @Internal
    @ToBeReplacedByLazyProperty
    public File getStubDir() {
        return this.stubDir;
    }

    public void setStubDir(File stubDir) {
        this.stubDir = stubDir;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public List<String> getFileExtensions() {
        return this.fileExtensions;
    }

    public void setFileExtensions(List<String> fileExtensions) {
        this.fileExtensions = fileExtensions;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isKeepStubs() {
        return this.keepStubs;
    }

    public void setKeepStubs(boolean keepStubs) {
        this.keepStubs = keepStubs;
    }

    @Deprecated
    public GroovyCompileOptions fork(Map<String, Object> forkArgs) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(GroovyCompileOptions.class, (String)"fork(Map)").withAdvice("Set properties directly on the 'forkOptions' property instead.")).willBeRemovedInGradle9().withUpgradeGuideSection(8, "deprecated_abstract_options")).nagUser();
        this.fork = true;
        DeprecationLogger.whileDisabled(() -> this.forkOptions.define(forkArgs));
        return this;
    }
}

