/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.DependencyArtifactSelector;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.ArtifactSelectionDetailsInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencyArtifactSelector;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitution;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionReasons;
import org.gradle.internal.component.model.IvyArtifactName;

public class DefaultArtifactSelectionDetails
implements ArtifactSelectionDetailsInternal {
    private final DefaultDependencySubstitution owner;
    private final List<DependencyArtifactSelector> requestedSelectors;
    private List<DependencyArtifactSelector> targetSelectors;

    public DefaultArtifactSelectionDetails(DefaultDependencySubstitution defaultDependencySubstitution, List<IvyArtifactName> requested) {
        this.owner = defaultDependencySubstitution;
        this.requestedSelectors = requested.isEmpty() ? ImmutableList.of() : ImmutableList.copyOf((Collection)requested.stream().map(e -> new DefaultDependencyArtifactSelector(e.getType(), e.getExtension(), e.getClassifier())).collect(Collectors.toList()));
    }

    public boolean hasSelectors() {
        return !this.requestedSelectors.isEmpty();
    }

    public List<DependencyArtifactSelector> getRequestedSelectors() {
        return this.requestedSelectors;
    }

    public void withoutArtifactSelectors() {
        this.targetSelectors = new ArrayList<DependencyArtifactSelector>();
        this.markUpdated();
    }

    private void markUpdated() {
        this.owner.addRuleDescriptor(ComponentSelectionReasons.SELECTED_BY_RULE);
    }

    public void selectArtifact(String type, @Nullable String extension, @Nullable String classifier) {
        this.selectArtifact(new DefaultDependencyArtifactSelector(type, extension, classifier));
    }

    public void selectArtifact(DependencyArtifactSelector selector) {
        if (this.targetSelectors == null) {
            this.targetSelectors = new ArrayList<DependencyArtifactSelector>();
            this.markUpdated();
        }
        this.targetSelectors.add(selector);
    }

    @Override
    public boolean isUpdated() {
        return this.targetSelectors != null;
    }

    @Override
    public List<DependencyArtifactSelector> getTargetSelectors() {
        return this.targetSelectors == null ? Collections.emptyList() : ImmutableList.copyOf(this.targetSelectors);
    }
}

