/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.checkers.TrailingCommaChecker;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/TrailingCommaDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend"})
public final class TrailingCommaDeclarationChecker
implements DeclarationChecker {
    @NotNull
    public static final TrailingCommaDeclarationChecker INSTANCE = new TrailingCommaDeclarationChecker();

    private TrailingCommaDeclarationChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        KtDeclaration ktDeclaration = declaration;
        if (ktDeclaration instanceof KtClass) {
            KtTypeParameterList ktTypeParameterList = ((KtClass)declaration).getTypeParameterList();
            TrailingCommaChecker.INSTANCE.check(ktTypeParameterList != null ? ktTypeParameterList.getTrailingComma() : null, context.getTrace(), context.getLanguageVersionSettings());
        } else if (ktDeclaration instanceof KtCallableDeclaration) {
            KtParameterList ktParameterList = ((KtCallableDeclaration)declaration).getValueParameterList();
            TrailingCommaChecker.INSTANCE.check(ktParameterList != null ? ktParameterList.getTrailingComma() : null, context.getTrace(), context.getLanguageVersionSettings());
            KtTypeParameterList ktTypeParameterList = ((KtCallableDeclaration)declaration).getTypeParameterList();
            TrailingCommaChecker.INSTANCE.check(ktTypeParameterList != null ? ktTypeParameterList.getTrailingComma() : null, context.getTrace(), context.getLanguageVersionSettings());
            if (declaration instanceof KtProperty && ((KtProperty)declaration).getSetter() != null) {
                KtElementImplStub ktElementImplStub = ((KtProperty)declaration).getSetter();
                TrailingCommaChecker.INSTANCE.check(ktElementImplStub != null && (ktElementImplStub = ((KtPropertyAccessor)ktElementImplStub).getParameterList()) != null ? ((KtParameterList)ktElementImplStub).getTrailingComma() : null, context.getTrace(), context.getLanguageVersionSettings());
            }
        } else if (ktDeclaration instanceof KtDestructuringDeclaration) {
            TrailingCommaChecker.INSTANCE.check(((KtDestructuringDeclaration)declaration).getTrailingComma(), context.getTrace(), context.getLanguageVersionSettings());
        } else if (ktDeclaration instanceof KtTypeAlias) {
            KtTypeParameterList ktTypeParameterList = ((KtTypeAlias)declaration).getTypeParameterList();
            TrailingCommaChecker.INSTANCE.check(ktTypeParameterList != null ? ktTypeParameterList.getTrailingComma() : null, context.getTrace(), context.getLanguageVersionSettings());
        }
    }
}

