/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution.steps;

import com.google.common.collect.ImmutableList;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nullable;
import org.gradle.caching.internal.origin.OriginMetadata;
import org.gradle.internal.Try;
import org.gradle.internal.execution.ExecutionEngine;
import org.gradle.internal.execution.history.AfterExecutionState;
import org.gradle.internal.execution.steps.AfterExecutionResult;

public class UpToDateResult
extends AfterExecutionResult {
    private final ImmutableList<String> executionReasons;
    private final OriginMetadata reusedOutputOriginMetadata;

    public UpToDateResult(AfterExecutionResult parent, ImmutableList<String> executionReasons, @Nullable OriginMetadata reusedOutputOriginMetadata) {
        super(parent);
        this.executionReasons = executionReasons;
        this.reusedOutputOriginMetadata = reusedOutputOriginMetadata;
    }

    public UpToDateResult(Duration duration, Try<ExecutionEngine.Execution> execution, @Nullable AfterExecutionState afterExecutionState, ImmutableList<String> executionReasons, @Nullable OriginMetadata reusedOutputOriginMetadata) {
        super(duration, execution, afterExecutionState);
        this.executionReasons = executionReasons;
        this.reusedOutputOriginMetadata = reusedOutputOriginMetadata;
    }

    protected UpToDateResult(UpToDateResult parent) {
        this(parent, parent.getExecutionReasons(), parent.getReusedOutputOriginMetadata().orElse(null));
    }

    public ImmutableList<String> getExecutionReasons() {
        return this.executionReasons;
    }

    public Optional<OriginMetadata> getReusedOutputOriginMetadata() {
        return Optional.ofNullable(this.reusedOutputOriginMetadata);
    }
}

