/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.build;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.gradle.api.NonNullApi;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.execution.plan.ExecutionPlan;
import org.gradle.execution.plan.FinalizedExecutionPlan;
import org.gradle.execution.plan.QueryableExecutionPlan;
import org.gradle.execution.plan.ToPlannedNodeConverterRegistry;
import org.gradle.internal.build.BuildWorkPreparer;
import org.gradle.internal.build.PlannedNodeGraph;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.operations.trace.CustomOperationTraceSerialization;
import org.gradle.internal.taskgraph.CalculateTaskGraphBuildOperationType;
import org.gradle.internal.taskgraph.NodeIdentity;

@NonNullApi
public class BuildOperationFiringBuildWorkPreparer
implements BuildWorkPreparer {
    private final BuildOperationExecutor buildOperationExecutor;
    private final BuildWorkPreparer delegate;
    private final ToPlannedNodeConverterRegistry converterRegistry;

    public BuildOperationFiringBuildWorkPreparer(BuildOperationExecutor buildOperationExecutor, BuildWorkPreparer delegate, ToPlannedNodeConverterRegistry converterRegistry) {
        this.buildOperationExecutor = buildOperationExecutor;
        this.delegate = delegate;
        this.converterRegistry = converterRegistry;
    }

    @Override
    public ExecutionPlan newExecutionPlan() {
        return this.delegate.newExecutionPlan();
    }

    @Override
    public void populateWorkGraph(GradleInternal gradle, ExecutionPlan plan, Consumer<? super ExecutionPlan> action) {
        this.buildOperationExecutor.run((RunnableBuildOperation)new PopulateWorkGraph(this.delegate, gradle, plan, action, this.converterRegistry));
    }

    @Override
    public FinalizedExecutionPlan finalizeWorkGraph(GradleInternal gradle, ExecutionPlan plan) {
        return this.delegate.finalizeWorkGraph(gradle, plan);
    }

    private static class PopulateWorkGraph
    implements RunnableBuildOperation {
        private final BuildWorkPreparer delegate;
        private final GradleInternal gradle;
        private final ExecutionPlan plan;
        private final Consumer<? super ExecutionPlan> action;
        private final ToPlannedNodeConverterRegistry converterRegistry;

        public PopulateWorkGraph(BuildWorkPreparer delegate, GradleInternal gradle, ExecutionPlan plan, Consumer<? super ExecutionPlan> action, ToPlannedNodeConverterRegistry converterRegistry) {
            this.delegate = delegate;
            this.gradle = gradle;
            this.plan = plan;
            this.action = action;
            this.converterRegistry = converterRegistry;
        }

        public void run(BuildOperationContext buildOperationContext) {
            this.populateTaskGraph();
            QueryableExecutionPlan contents = this.plan.getContents();
            Set<Task> requestedTasks = contents.getRequestedTasks();
            Set<Task> filteredTasks = contents.getFilteredTasks();
            QueryableExecutionPlan.ScheduledNodes scheduledWork = contents.getScheduledNodes();
            PlannedNodeGraph plannedNodeGraph = this.computePlannedNodeGraph(scheduledWork);
            buildOperationContext.setResult((Object)new CalculateTaskGraphResult(requestedTasks, filteredTasks, plannedNodeGraph));
        }

        void populateTaskGraph() {
            this.delegate.populateWorkGraph(this.gradle, this.plan, this.action);
        }

        @Nonnull
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName((String)this.gradle.contextualize("Calculate task graph")).details((Object)new CalculateTaskGraphBuildOperationType.Details(){

                public String getBuildPath() {
                    return gradle.getIdentityPath().getPath();
                }
            });
        }

        private PlannedNodeGraph computePlannedNodeGraph(QueryableExecutionPlan.ScheduledNodes scheduledWork) {
            PlannedNodeGraph.Collector collector = new PlannedNodeGraph.Collector(this.converterRegistry);
            scheduledWork.visitNodes(collector::collectNodes);
            return collector.getGraph();
        }

        private static class CalculateTaskGraphResult
        implements CalculateTaskGraphBuildOperationType.Result,
        CustomOperationTraceSerialization {
            private final Set<Task> requestedTasks;
            private final Set<Task> filteredTasks;
            private final PlannedNodeGraph plannedNodeGraph;

            public CalculateTaskGraphResult(Set<Task> requestedTasks, Set<Task> filteredTasks, PlannedNodeGraph plannedNodeGraph) {
                this.requestedTasks = requestedTasks;
                this.filteredTasks = filteredTasks;
                this.plannedNodeGraph = plannedNodeGraph;
            }

            public List<String> getRequestedTaskPaths() {
                return CalculateTaskGraphResult.toUniqueSortedTaskPaths(this.requestedTasks);
            }

            public List<String> getExcludedTaskPaths() {
                return CalculateTaskGraphResult.toUniqueSortedTaskPaths(this.filteredTasks);
            }

            public List<CalculateTaskGraphBuildOperationType.PlannedTask> getTaskPlan() {
                List<? extends CalculateTaskGraphBuildOperationType.PlannedNode> taskPlan = this.plannedNodeGraph.getNodes(PlannedNodeGraph.DetailLevel.LEVEL1_TASKS);
                return ImmutableList.copyOf(taskPlan);
            }

            public List<CalculateTaskGraphBuildOperationType.PlannedNode> getExecutionPlan(Set<NodeIdentity.NodeType> types) {
                if (types.isEmpty()) {
                    return Collections.emptyList();
                }
                List<CalculateTaskGraphBuildOperationType.PlannedNode> plan = this.plannedNodeGraph.getNodes(PlannedNodeGraph.DetailLevel.from(types));
                return plan;
            }

            @Override
            public Object getCustomOperationTraceSerializableModel() {
                ImmutableMap.Builder builder = new ImmutableMap.Builder();
                builder.put((Object)"requestedTaskPaths", this.getRequestedTaskPaths());
                builder.put((Object)"excludedTaskPaths", this.getExcludedTaskPaths());
                builder.put((Object)"taskPlan", this.getTaskPlan());
                builder.put((Object)"executionPlan", this.getExecutionPlan(EnumSet.allOf(NodeIdentity.NodeType.class)));
                return builder.build();
            }

            private static List<String> toUniqueSortedTaskPaths(Set<Task> tasks) {
                return tasks.stream().map(Task::getPath).distinct().sorted().collect(Collectors.toList());
            }
        }
    }
}

