/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrModuleHeader;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsIrProgramFragment;
import org.jetbrains.kotlin.js.backend.ast.JsName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModule;", "", "moduleName", "", "externalModuleName", "fragments", "", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrProgramFragment;", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getExternalModuleName", "()Ljava/lang/String;", "getFragments", "()Ljava/util/List;", "getModuleName", "makeModuleHeader", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/JsIrModuleHeader;", "backend.js"})
public final class JsIrModule {
    @NotNull
    private final String moduleName;
    @NotNull
    private final String externalModuleName;
    @NotNull
    private final List<JsIrProgramFragment> fragments;

    public JsIrModule(@NotNull String moduleName, @NotNull String externalModuleName, @NotNull List<JsIrProgramFragment> fragments2) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)externalModuleName, (String)"externalModuleName");
        Intrinsics.checkNotNullParameter(fragments2, (String)"fragments");
        this.moduleName = moduleName;
        this.externalModuleName = externalModuleName;
        this.fragments = fragments2;
    }

    @NotNull
    public final String getModuleName() {
        return this.moduleName;
    }

    @NotNull
    public final String getExternalModuleName() {
        return this.externalModuleName;
    }

    @NotNull
    public final List<JsIrProgramFragment> getFragments() {
        return this.fragments;
    }

    @NotNull
    public final JsIrModuleHeader makeModuleHeader() {
        Map nameBindings = new LinkedHashMap();
        Set definitions = new LinkedHashSet();
        HashSet optionalCrossModuleImports = new HashSet();
        boolean hasJsExports = false;
        for (JsIrProgramFragment fragment : this.fragments) {
            hasJsExports = hasJsExports || !fragment.getExports().isEmpty();
            for (Map.Entry<String, JsName> entry : fragment.getNameBindings().entrySet()) {
                String string2;
                String tag = entry.getKey();
                JsName name2 = entry.getValue();
                Map map = nameBindings;
                Intrinsics.checkNotNullExpressionValue((Object)name2.toString(), (String)"name.toString()");
                map.put(tag, string2);
            }
            CollectionsKt.addAll((Collection)definitions, (Iterable)fragment.getDefinitions());
            CollectionsKt.addAll((Collection)optionalCrossModuleImports, (Iterable)fragment.getOptionalCrossModuleImports());
        }
        return new JsIrModuleHeader(this.moduleName, this.externalModuleName, definitions, nameBindings, optionalCrossModuleImports, hasJsExports, this);
    }
}

