/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.Task;
import org.gradle.api.internal.provider.AbstractMinimalProvider;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueSupplier;

public class FilteringProvider<T>
extends AbstractMinimalProvider<T> {
    protected final ProviderInternal<T> provider;
    protected final Predicate<? super T> predicate;

    public FilteringProvider(ProviderInternal<T> provider, Predicate<? super T> predicate) {
        this.predicate = predicate;
        this.provider = provider;
    }

    @Override
    @Nullable
    public Class<T> getType() {
        return this.provider.getType();
    }

    @Override
    public ValueSupplier.ValueProducer getProducer() {
        return this.provider.getProducer();
    }

    @Override
    public ValueSupplier.ExecutionTimeValue<? extends T> calculateExecutionTimeValue() {
        ValueSupplier.ExecutionTimeValue<T> value = this.provider.calculateExecutionTimeValue();
        if (value.isMissing()) {
            return value;
        }
        if (value.hasChangingContent()) {
            return ValueSupplier.ExecutionTimeValue.changingValue(new FilteringProvider<T>(value.toProvider(), this.predicate));
        }
        return ValueSupplier.ExecutionTimeValue.value(this.filterValue(value.toValue()));
    }

    @Override
    protected ValueSupplier.Value<? extends T> calculateOwnValue(ValueSupplier.ValueConsumer consumer) {
        this.beforeRead();
        ValueSupplier.Value<T> value = this.provider.calculateValue(consumer);
        return this.filterValue(value);
    }

    @Nonnull
    protected ValueSupplier.Value<? extends T> filterValue(ValueSupplier.Value<? extends T> value) {
        if (value.isMissing()) {
            return value.asType();
        }
        T unpackedValue = value.getWithoutSideEffect();
        if (this.predicate.test(unpackedValue)) {
            return value;
        }
        return ValueSupplier.Value.missing();
    }

    protected void beforeRead() {
        this.provider.getProducer().visitContentProducerTasks((Action<? super Task>)((Action)producer -> {
            if (!producer.getState().getExecuted()) {
                throw new InvalidUserCodeException(String.format("Querying the filtered value of %s before %s has completed is not supported", this.provider, producer));
            }
        }));
    }

    @Override
    public String toString() {
        return "filter(" + (this.getType() == null ? "" : this.getType().getName() + " ") + this.provider + ")";
    }
}

