/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Describable;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.FileCollectionDependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DependencyGraphNodeResult;
import org.gradle.api.internal.artifacts.ResolveArtifactsBuildOperationType;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.verification.DependencyVerificationOverride;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactSelectionSpec;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.LocalDependencyFiles;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ParallelResolveArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactsResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedFileDependencyResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.results.VisitedGraphResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResults;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.oldresult.TransientConfigurationResultsLoader;
import org.gradle.api.internal.artifacts.transform.ArtifactVariantSelector;
import org.gradle.api.internal.artifacts.verification.exceptions.DependencyVerificationException;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.api.internal.file.FileCollectionStructureVisitor;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.internal.DisplayName;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraphWithEdgeValues;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.RunnableBuildOperation;
import org.gradle.internal.work.WorkerLeaseService;

public class DefaultLenientConfiguration
implements LenientConfiguration,
VisitedArtifactSet {
    private static final ResolveArtifactsBuildOperationType.Result RESULT = new ResolveArtifactsBuildOperationType.Result(){};
    private final ResolveContext resolveContext;
    private final VisitedGraphResults graphResults;
    private final VisitedArtifactsResults artifactResults;
    private final VisitedFileDependencyResults fileDependencyResults;
    private final TransientConfigurationResultsLoader transientConfigurationResultsFactory;
    private final AttributeContainerInternal implicitAttributes;
    private final BuildOperationExecutor buildOperationExecutor;
    private final DependencyVerificationOverride dependencyVerificationOverride;
    private final WorkerLeaseService workerLeaseService;
    private final ArtifactVariantSelector artifactVariantSelector;
    private SelectedArtifactResults artifactsForThisConfiguration;
    private DependencyVerificationException dependencyVerificationException;

    public DefaultLenientConfiguration(ResolveContext resolveContext, VisitedGraphResults graphResults, VisitedArtifactsResults artifactResults, VisitedFileDependencyResults fileDependencyResults, TransientConfigurationResultsLoader transientConfigurationResultsLoader, BuildOperationExecutor buildOperationExecutor, DependencyVerificationOverride dependencyVerificationOverride, WorkerLeaseService workerLeaseService, ArtifactVariantSelector artifactVariantSelector) {
        this.resolveContext = resolveContext;
        this.implicitAttributes = resolveContext.getAttributes().asImmutable();
        this.graphResults = graphResults;
        this.artifactResults = artifactResults;
        this.fileDependencyResults = fileDependencyResults;
        this.transientConfigurationResultsFactory = transientConfigurationResultsLoader;
        this.buildOperationExecutor = buildOperationExecutor;
        this.dependencyVerificationOverride = dependencyVerificationOverride;
        this.workerLeaseService = workerLeaseService;
        this.artifactVariantSelector = artifactVariantSelector;
    }

    private SelectedArtifactResults getSelectedArtifacts() {
        if (this.artifactsForThisConfiguration == null) {
            this.artifactsForThisConfiguration = this.artifactResults.selectLenient(this.artifactVariantSelector, this.getImplicitSelectionSpec());
        }
        return this.artifactsForThisConfiguration;
    }

    public SelectedArtifactSet select() {
        return this.select((Spec<? super Dependency>)Specs.satisfyAll(), this.getImplicitSelectionSpec());
    }

    public SelectedArtifactSet select(Spec<? super Dependency> dependencySpec) {
        return this.select(dependencySpec, this.getImplicitSelectionSpec());
    }

    private ArtifactSelectionSpec getImplicitSelectionSpec() {
        return new ArtifactSelectionSpec(this.implicitAttributes.asImmutable(), (Spec<? super ComponentIdentifier>)Specs.satisfyAll(), false, false);
    }

    @Override
    public SelectedArtifactSet select(final Spec<? super Dependency> dependencySpec, ArtifactSelectionSpec spec) {
        final SelectedArtifactResults artifactResults = this.artifactResults.select(this.artifactVariantSelector, spec);
        return new SelectedArtifactSet(){

            public void visitDependencies(TaskDependencyResolveContext context) {
                DefaultLenientConfiguration.this.graphResults.visitFailures(arg_0 -> ((TaskDependencyResolveContext)context).visitFailure(arg_0));
                context.add((Object)artifactResults.getArtifacts());
            }

            @Override
            public void visitArtifacts(ArtifactVisitor visitor, boolean continueOnSelectionFailure) {
                if (DefaultLenientConfiguration.this.graphResults.hasAnyFailure()) {
                    DefaultLenientConfiguration.this.graphResults.visitFailures(visitor::visitFailure);
                    if (!continueOnSelectionFailure) {
                        return;
                    }
                }
                DefaultLenientConfiguration.this.workerLeaseService.runAsUnmanagedWorkerThread(() -> DefaultLenientConfiguration.this.visitArtifactsWithBuildOperation((Spec<? super Dependency>)dependencySpec, artifactResults, DefaultLenientConfiguration.this.fileDependencyResults, visitor));
            }
        };
    }

    public VisitedGraphResults getGraphResults() {
        return this.graphResults;
    }

    public Set<UnresolvedDependency> getUnresolvedModuleDependencies() {
        return this.graphResults.getUnresolvedDependencies();
    }

    private TransientConfigurationResults loadTransientGraphResults(SelectedArtifactResults artifactResults) {
        return this.transientConfigurationResultsFactory.create(artifactResults);
    }

    public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) {
        LinkedHashSet<ResolvedDependency> matches = new LinkedHashSet<ResolvedDependency>();
        for (DependencyGraphNodeResult node : this.getFirstLevelNodes(dependencySpec)) {
            matches.add(node.getPublicView());
        }
        return matches;
    }

    private Set<DependencyGraphNodeResult> getFirstLevelNodes(Spec<? super Dependency> dependencySpec) {
        LinkedHashSet<DependencyGraphNodeResult> matches = new LinkedHashSet<DependencyGraphNodeResult>();
        TransientConfigurationResults graphResults = this.loadTransientGraphResults(this.getSelectedArtifacts());
        for (Map.Entry<Dependency, DependencyGraphNodeResult> entry : graphResults.getFirstLevelDependencies().entrySet()) {
            if (!dependencySpec.isSatisfiedBy((Object)entry.getKey())) continue;
            matches.add(entry.getValue());
        }
        return matches;
    }

    public Set<ResolvedDependency> getAllModuleDependencies() {
        LinkedHashSet<ResolvedDependency> resolvedElements = new LinkedHashSet<ResolvedDependency>();
        LinkedList workQueue = new LinkedList(this.loadTransientGraphResults(this.getSelectedArtifacts()).getRootNode().getPublicView().getChildren());
        while (!workQueue.isEmpty()) {
            ResolvedDependency item = (ResolvedDependency)workQueue.removeFirst();
            if (!resolvedElements.add(item)) continue;
            Set children = item.getChildren();
            workQueue.addAll(children);
        }
        return resolvedElements;
    }

    public Set<File> getFiles() {
        return this.getFiles((Spec<? super Dependency>)Specs.satisfyAll());
    }

    public Set<File> getFiles(Spec<? super Dependency> dependencySpec) {
        LenientFilesAndArtifactResolveVisitor visitor = new LenientFilesAndArtifactResolveVisitor();
        this.visitArtifactsWithBuildOperation(dependencySpec, this.getSelectedArtifacts(), this.fileDependencyResults, visitor);
        return visitor.files;
    }

    public Set<ResolvedArtifact> getArtifacts() {
        return this.getArtifacts((Spec<? super Dependency>)Specs.satisfyAll());
    }

    public Set<ResolvedArtifact> getArtifacts(Spec<? super Dependency> dependencySpec) {
        LenientArtifactCollectingVisitor visitor = new LenientArtifactCollectingVisitor();
        this.visitArtifactsWithBuildOperation(dependencySpec, this.getSelectedArtifacts(), this.fileDependencyResults, visitor);
        return visitor.artifacts;
    }

    private void visitArtifactsWithBuildOperation(final Spec<? super Dependency> dependencySpec, final SelectedArtifactResults artifactResults, final VisitedFileDependencyResults fileDependencyResults, final ArtifactVisitor visitor) {
        this.buildOperationExecutor.run(new RunnableBuildOperation(){

            public void run(BuildOperationContext context) {
                DefaultLenientConfiguration.this.visitArtifacts((Spec<? super Dependency>)dependencySpec, artifactResults, fileDependencyResults, visitor);
                if (DefaultLenientConfiguration.this.dependencyVerificationException != null) {
                    throw DefaultLenientConfiguration.this.dependencyVerificationException;
                }
                try {
                    DefaultLenientConfiguration.this.dependencyVerificationOverride.artifactsAccessed(DefaultLenientConfiguration.this.getDisplayName().toString());
                }
                catch (DependencyVerificationException e) {
                    DefaultLenientConfiguration.this.dependencyVerificationException = e;
                    throw e;
                }
                context.setResult((Object)RESULT);
            }

            public BuildOperationDescriptor.Builder description() {
                String displayName = "Resolve files of " + DefaultLenientConfiguration.this.resolveContext.getIdentityPath();
                return BuildOperationDescriptor.displayName((String)displayName).progressDisplayName(displayName).details((Object)new ResolveArtifactsDetails(DefaultLenientConfiguration.this.resolveContext.getProjectPath().toString()));
            }
        });
    }

    private void visitArtifacts(Spec<? super Dependency> dependencySpec, SelectedArtifactResults artifactResults, VisitedFileDependencyResults fileDependencyResults, ArtifactVisitor visitor) {
        if (dependencySpec == Specs.SATISFIES_ALL) {
            ParallelResolveArtifactSet.wrap(artifactResults.getArtifacts(), this.buildOperationExecutor).visit(visitor);
            return;
        }
        ArrayList<ResolvedArtifactSet> artifactSets = new ArrayList<ResolvedArtifactSet>();
        for (Map.Entry<FileCollectionDependency, Integer> entry : fileDependencyResults.getFirstLevelFiles().entrySet()) {
            if (!dependencySpec.isSatisfiedBy((Object)entry.getKey())) continue;
            artifactSets.add(artifactResults.getArtifactsWithId(entry.getValue()));
        }
        CachingDirectedGraphWalker walker = new CachingDirectedGraphWalker((DirectedGraphWithEdgeValues)new ResolvedDependencyArtifactsGraph(artifactSets));
        for (DependencyGraphNodeResult node : this.getFirstLevelNodes(dependencySpec)) {
            walker.add((Object[])new DependencyGraphNodeResult[]{node});
        }
        walker.findValues();
        ParallelResolveArtifactSet.wrap(CompositeResolvedArtifactSet.of(artifactSets), this.buildOperationExecutor).visit(visitor);
    }

    public Describable getDisplayName() {
        return this.resolveContext.asDescribable();
    }

    public Set<ResolvedDependency> getFirstLevelModuleDependencies() {
        return this.getFirstLevelModuleDependencies((Spec<? super Dependency>)Specs.SATISFIES_ALL);
    }

    private static class ResolvedDependencyArtifactsGraph
    implements DirectedGraphWithEdgeValues<DependencyGraphNodeResult, ResolvedArtifact> {
        private final List<ResolvedArtifactSet> dest;

        ResolvedDependencyArtifactsGraph(List<ResolvedArtifactSet> dest) {
            this.dest = dest;
        }

        public void getNodeValues(DependencyGraphNodeResult node, Collection<? super ResolvedArtifact> values, Collection<? super DependencyGraphNodeResult> connectedNodes) {
            connectedNodes.addAll(node.getOutgoingEdges());
            this.dest.add(node.getArtifactsForNode());
        }

        public void getEdgeValues(DependencyGraphNodeResult from, DependencyGraphNodeResult to, Collection<ResolvedArtifact> values) {
        }
    }

    public static class ArtifactResolveException
    extends ResolveException {
        private final String type;
        private final String displayName;

        public ArtifactResolveException(String type, String displayName, Iterable<? extends Throwable> failures) {
            super(displayName, failures);
            this.type = type;
            this.displayName = displayName;
        }

        public String getMessage() {
            return String.format("Could not resolve all %s for %s.", this.type, this.displayName);
        }
    }

    private static class LenientFilesAndArtifactResolveVisitor
    extends LenientArtifactCollectingVisitor {
        private LenientFilesAndArtifactResolveVisitor() {
        }

        @Override
        public FileCollectionStructureVisitor.VisitType prepareForVisit(FileCollectionInternal.Source source) {
            return FileCollectionStructureVisitor.VisitType.Visit;
        }
    }

    private static class LenientArtifactCollectingVisitor
    implements ArtifactVisitor {
        final Set<ResolvedArtifact> artifacts = new LinkedHashSet<ResolvedArtifact>();
        final Set<File> files = new LinkedHashSet<File>();

        private LenientArtifactCollectingVisitor() {
        }

        @Override
        public void visitArtifact(DisplayName variantName, AttributeContainer variantAttributes, ImmutableCapabilities capabilities, ResolvableArtifact artifact) {
            try {
                ResolvedArtifact resolvedArtifact = artifact.toPublicView();
                this.files.add(resolvedArtifact.getFile());
                this.artifacts.add(resolvedArtifact);
            }
            catch (org.gradle.internal.resolve.ArtifactResolveException artifactResolveException) {
                // empty catch block
            }
        }

        @Override
        public FileCollectionStructureVisitor.VisitType prepareForVisit(FileCollectionInternal.Source source) {
            if (source instanceof LocalDependencyFiles) {
                return FileCollectionStructureVisitor.VisitType.NoContents;
            }
            return FileCollectionStructureVisitor.VisitType.Visit;
        }

        @Override
        public boolean requireArtifactFiles() {
            return false;
        }

        @Override
        public void visitFailure(Throwable failure) {
            throw UncheckedException.throwAsUncheckedException((Throwable)failure);
        }
    }

    private static class ResolveArtifactsDetails
    implements ResolveArtifactsBuildOperationType.Details {
        private final String configuration;

        public ResolveArtifactsDetails(String configuration) {
            this.configuration = configuration;
        }

        public String getConfigurationPath() {
            return this.configuration;
        }
    }
}

