/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.DependencyGraphVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.RootGraphNode;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.DefaultResolvedProjectConfiguration;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedLocalComponentsResult;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.projectresult.ResolvedProjectConfiguration;

public class ResolvedLocalComponentsResultGraphVisitor
implements DependencyGraphVisitor,
ResolvedLocalComponentsResult {
    private final List<ResolvedProjectConfiguration> resolvedProjectConfigurations = new ArrayList<ResolvedProjectConfiguration>();
    private final BuildIdentifier thisBuild;
    private ComponentIdentifier rootId;

    public ResolvedLocalComponentsResultGraphVisitor(BuildIdentifier thisBuild) {
        this.thisBuild = thisBuild;
    }

    @Override
    public void start(RootGraphNode root) {
        this.rootId = root.getOwner().getComponentId();
    }

    @Override
    public void visitNode(DependencyGraphNode node) {
        ProjectComponentIdentifier projectComponentId;
        ComponentIdentifier componentId = node.getOwner().getComponentId();
        if (!this.rootId.equals(componentId) && componentId instanceof ProjectComponentIdentifier && (projectComponentId = (ProjectComponentIdentifier)componentId).getBuild().equals(this.thisBuild)) {
            this.resolvedProjectConfigurations.add(new DefaultResolvedProjectConfiguration(projectComponentId, node.getResolvedConfigurationId().getConfiguration()));
        }
    }

    @Override
    public Iterable<ResolvedProjectConfiguration> getResolvedProjectConfigurations() {
        return this.resolvedProjectConfigurations;
    }

    public ResolvedLocalComponentsResult complete() {
        return this;
    }
}

