/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.util.EnumSet;
import java.util.Set;
import org.gradle.api.JavaVersion;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Bundling;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.attributes.Usage;
import org.gradle.api.attributes.java.TargetJvmVersion;
import org.gradle.api.attributes.plugin.GradlePluginApiVersion;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.artifacts.dsl.DependencyHandlerInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactoryInternal;
import org.gradle.api.internal.initialization.ScriptClassPathResolver;
import org.gradle.api.internal.initialization.transform.BaseInstrumentingArtifactTransform;
import org.gradle.api.internal.initialization.transform.ExternalDependencyInstrumentingArtifactTransform;
import org.gradle.api.internal.initialization.transform.ProjectDependencyInstrumentingArtifactTransform;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.agents.AgentStatus;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.classpath.DefaultClassPath;
import org.gradle.internal.classpath.TransformedClassPath;
import org.gradle.internal.component.local.model.OpaqueComponentIdentifier;
import org.gradle.util.GradleVersion;

public class DefaultScriptClassPathResolver
implements ScriptClassPathResolver {
    private static final Set<DependencyFactoryInternal.ClassPathNotation> GRADLE_API_NOTATIONS = EnumSet.of(DependencyFactoryInternal.ClassPathNotation.GRADLE_API, DependencyFactoryInternal.ClassPathNotation.LOCAL_GROOVY);
    private static final Attribute<Boolean> HIERARCHY_COLLECTED_ATTRIBUTE = Attribute.of((String)"org.gradle.internal.hierarchy-collected", Boolean.class);
    private static final Attribute<String> INSTRUMENTED_ATTRIBUTE = Attribute.of((String)"org.gradle.internal.instrumented", String.class);
    private static final String NOT_INSTRUMENTED_ATTRIBUTE = "not-instrumented";
    private static final String INSTRUMENTED_EXTERNAL_DEPENDENCY_ATTRIBUTE = "instrumented-external-dependency";
    private static final String INSTRUMENTED_PROJECT_DEPENDENCY_ATTRIBUTE = "instrumented-project-dependency";
    private final NamedObjectInstantiator instantiator;
    private final AgentStatus agentStatus;

    public DefaultScriptClassPathResolver(NamedObjectInstantiator instantiator, AgentStatus agentStatus) {
        this.instantiator = instantiator;
        this.agentStatus = agentStatus;
    }

    @Override
    public void prepareDependencyHandler(DependencyHandler dependencyHandler) {
        ((DependencyHandlerInternal)dependencyHandler).getDefaultArtifactAttributes().attribute(INSTRUMENTED_ATTRIBUTE, (Object)NOT_INSTRUMENTED_ATTRIBUTE).attribute(HIERARCHY_COLLECTED_ATTRIBUTE, (Object)false);
        this.registerTransform(dependencyHandler, ExternalDependencyInstrumentingArtifactTransform.class, INSTRUMENTED_EXTERNAL_DEPENDENCY_ATTRIBUTE);
        this.registerTransform(dependencyHandler, ProjectDependencyInstrumentingArtifactTransform.class, INSTRUMENTED_PROJECT_DEPENDENCY_ATTRIBUTE);
    }

    private void registerTransform(DependencyHandler dependencyHandler, Class<? extends BaseInstrumentingArtifactTransform> transform, String instrumentedAttribute) {
        dependencyHandler.registerTransform(transform, spec -> {
            spec.getFrom().attribute(INSTRUMENTED_ATTRIBUTE, (Object)NOT_INSTRUMENTED_ATTRIBUTE);
            spec.getTo().attribute(INSTRUMENTED_ATTRIBUTE, (Object)instrumentedAttribute);
            spec.parameters(parameters -> parameters.getAgentSupported().set((Object)this.agentStatus.isAgentInstrumentationEnabled()));
        });
    }

    @Override
    public void prepareClassPath(Configuration configuration, DependencyHandler dependencyHandler) {
        AttributeContainer attributes = configuration.getAttributes();
        attributes.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.instantiator.named(Usage.class, "java-runtime")));
        attributes.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.instantiator.named(Category.class, "library")));
        attributes.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, (Object)((LibraryElements)this.instantiator.named(LibraryElements.class, "jar")));
        attributes.attribute(Bundling.BUNDLING_ATTRIBUTE, (Object)((Bundling)this.instantiator.named(Bundling.class, "external")));
        attributes.attribute(TargetJvmVersion.TARGET_JVM_VERSION_ATTRIBUTE, (Object)Integer.parseInt(JavaVersion.current().getMajorVersion()));
        attributes.attribute(GradlePluginApiVersion.GRADLE_PLUGIN_API_VERSION_ATTRIBUTE, (Object)((GradlePluginApiVersion)this.instantiator.named(GradlePluginApiVersion.class, GradleVersion.current().getVersion())));
        configuration.getDependencyConstraints().add((Object)dependencyHandler.getConstraints().create((Object)"org.apache.logging.log4j:log4j-core", constraint -> constraint.version(version -> {
            version.require("2.17.1");
            version.reject(new String[]{"[2.0, 2.17.1)"});
        })));
    }

    @Override
    public ClassPath resolveClassPath(Configuration classpathConfiguration, DependencyHandler dependencyHandler, ConfigurationContainer configContainer) {
        FileCollection instrumentedExternalDependencies = DefaultScriptClassPathResolver.getInstrumentedExternalDependencies(classpathConfiguration);
        FileCollection instrumentedProjectDependencies = DefaultScriptClassPathResolver.getInstrumentedProjectDependencies(classpathConfiguration);
        return TransformedClassPath.handleInstrumentingArtifactTransform((ClassPath)DefaultClassPath.of((Iterable)instrumentedExternalDependencies.plus(instrumentedProjectDependencies)));
    }

    private static FileCollection getInstrumentedExternalDependencies(Configuration classpathConfiguration) {
        return classpathConfiguration.getIncoming().artifactView(config -> {
            config.attributes(it -> it.attribute(INSTRUMENTED_ATTRIBUTE, (Object)INSTRUMENTED_EXTERNAL_DEPENDENCY_ATTRIBUTE));
            config.componentFilter(componentId -> !DefaultScriptClassPathResolver.isGradleApi(componentId) && !DefaultScriptClassPathResolver.isProject(componentId));
        }).getFiles();
    }

    private static boolean isGradleApi(ComponentIdentifier componentId) {
        if (componentId instanceof OpaqueComponentIdentifier) {
            DependencyFactoryInternal.ClassPathNotation classPathNotation = ((OpaqueComponentIdentifier)componentId).getClassPathNotation();
            return GRADLE_API_NOTATIONS.contains((Object)classPathNotation);
        }
        return false;
    }

    private static boolean isProject(ComponentIdentifier componentId) {
        return componentId instanceof ProjectComponentIdentifier;
    }

    private static FileCollection getInstrumentedProjectDependencies(Configuration classpathConfiguration) {
        return classpathConfiguration.getIncoming().artifactView(config -> {
            config.attributes(it -> it.attribute(INSTRUMENTED_ATTRIBUTE, (Object)INSTRUMENTED_PROJECT_DEPENDENCY_ATTRIBUTE));
            config.componentFilter(DefaultScriptClassPathResolver::isProject);
        }).getFiles();
    }
}

