/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javax.inject.Inject;
import org.gradle.api.GradleException;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.internal.classpath.ClasspathBuilder;
import org.gradle.internal.classpath.InPlaceClasspathBuilder;
import org.gradle.internal.service.scopes.Scopes;
import org.gradle.internal.service.scopes.ServiceScope;

@NonNullApi
@ServiceScope(value=Scopes.UserHome.class)
public class DefaultClasspathBuilder
implements ClasspathBuilder {
    private final TemporaryFileProvider temporaryFileProvider;
    private final ClasspathBuilder inPlaceBuilder;

    @Inject
    public DefaultClasspathBuilder(TemporaryFileProvider temporaryFileProvider) {
        this.temporaryFileProvider = temporaryFileProvider;
        this.inPlaceBuilder = new InPlaceClasspathBuilder();
    }

    @Override
    public void jar(File jarFile, ClasspathBuilder.Action action) {
        try {
            this.buildJar(jarFile, action);
        }
        catch (Exception e) {
            throw new GradleException(String.format("Failed to create Jar file %s.", jarFile), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildJar(File jarFile, ClasspathBuilder.Action action) throws IOException {
        File parentDir = jarFile.getParentFile();
        File tmpFile = this.temporaryFileProvider.createTemporaryFile(jarFile.getName(), ".tmp", new String[0]);
        try {
            Files.createDirectories(parentDir.toPath(), new FileAttribute[0]);
            this.inPlaceBuilder.jar(tmpFile, action);
            Files.move(tmpFile.toPath(), jarFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        finally {
            Files.deleteIfExists(tmpFile.toPath());
        }
    }
}

