/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts;

import java.io.File;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.internal.artifacts.DefaultResolvedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.internal.Describables;
import org.gradle.internal.component.local.model.TransformedComponentFileArtifactIdentifier;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.model.CalculatedValue;
import org.gradle.internal.model.CalculatedValueContainerFactory;

public class PreResolvedResolvableArtifact
implements ResolvableArtifact {
    private final ModuleVersionIdentifier owner;
    private final IvyArtifactName artifact;
    private final ComponentArtifactIdentifier artifactId;
    private final File file;
    private final CalculatedValue<File> fileSource;
    private final TaskDependencyContainer builtBy;
    private final CalculatedValueContainerFactory calculatedValueContainerFactory;
    private final DefaultResolvedArtifact publicView;

    public PreResolvedResolvableArtifact(@Nullable ModuleVersionIdentifier owner, IvyArtifactName artifact, ComponentArtifactIdentifier artifactId, File file, TaskDependencyContainer builtBy, CalculatedValueContainerFactory calculatedValueContainerFactory) {
        this.owner = owner;
        this.artifact = artifact;
        this.artifactId = artifactId;
        this.file = file;
        this.fileSource = calculatedValueContainerFactory.create(Describables.of((Object)artifactId), (Object)file);
        this.builtBy = builtBy;
        this.calculatedValueContainerFactory = calculatedValueContainerFactory;
        this.publicView = new DefaultResolvedArtifact(artifactId, this.fileSource, owner, artifact);
    }

    public int hashCode() {
        return this.artifactId.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PreResolvedResolvableArtifact other = (PreResolvedResolvableArtifact)obj;
        return other.artifactId.equals(this.artifactId);
    }

    @Override
    public ComponentArtifactIdentifier getId() {
        return this.artifactId;
    }

    @Override
    public CalculatedValue<File> getFileSource() {
        return this.fileSource;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public ResolvedArtifact toPublicView() {
        return this.publicView;
    }

    public void visitDependencies(TaskDependencyResolveContext context) {
        this.builtBy.visitDependencies(context);
    }

    @Override
    public boolean isResolveSynchronously() {
        return true;
    }

    @Override
    public ResolvableArtifact transformedTo(File file) {
        DefaultIvyArtifactName artifactName = DefaultIvyArtifactName.forFile(file, this.artifact.getClassifier());
        String originalFileName = this.artifactId instanceof TransformedComponentFileArtifactIdentifier ? ((TransformedComponentFileArtifactIdentifier)this.artifactId).getOriginalFileName() : this.file.getName();
        TransformedComponentFileArtifactIdentifier newId = new TransformedComponentFileArtifactIdentifier(this.artifactId.getComponentIdentifier(), file.getName(), originalFileName);
        return new PreResolvedResolvableArtifact(this.owner, artifactName, (ComponentArtifactIdentifier)newId, file, this.builtBy, this.calculatedValueContainerFactory);
    }

    @Override
    public IvyArtifactName getArtifactName() {
        return this.artifact;
    }
}

