/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.deprecation;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.api.logging.configuration.WarningMode;
import org.gradle.api.problems.Problems;
import org.gradle.internal.Factory;
import org.gradle.internal.deprecation.DeprecatedFeatureUsage;
import org.gradle.internal.deprecation.DeprecationMessage;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.operations.BuildOperationProgressEventEmitter;
import org.gradle.problems.buildtree.ProblemStream;

@ThreadSafe
public class DeprecationLogger {
    private static final ThreadLocal<Integer> DISABLE_COUNT = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private static final LoggingDeprecatedFeatureHandler DEPRECATED_FEATURE_HANDLER = new LoggingDeprecatedFeatureHandler();

    public static synchronized void init(WarningMode warningMode, BuildOperationProgressEventEmitter buildOperationProgressEventEmitter, Problems problemsService, ProblemStream problemStream) {
        DEPRECATED_FEATURE_HANDLER.init(warningMode, buildOperationProgressEventEmitter, problemsService, problemStream);
    }

    public static synchronized void reset() {
        DEPRECATED_FEATURE_HANDLER.reset();
    }

    public static synchronized void reportSuppressedDeprecations() {
        DEPRECATED_FEATURE_HANDLER.reportSuppressedDeprecations();
    }

    @Nullable
    public static Throwable getDeprecationFailure() {
        return DEPRECATED_FEATURE_HANDLER.getDeprecationFailure();
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder<?> deprecate(final String feature) {
        return new DeprecationMessageBuilder(){

            @Override
            DeprecationMessage build() {
                this.setSummary(feature + " has been deprecated.");
                return super.build();
            }
        };
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder<?> deprecateIndirectUsage(String feature) {
        DeprecationMessageBuilder<?> builder = DeprecationLogger.deprecate(feature);
        builder.setIndirectUsage();
        return builder;
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder<?> deprecateBuildInvocationFeature(String feature) {
        DeprecationMessageBuilder<?> builder = DeprecationLogger.deprecate(feature);
        builder.setBuildInvocationUsage();
        return builder;
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder.DeprecateBehaviour deprecateBehaviour(String behaviour) {
        return new DeprecationMessageBuilder.DeprecateBehaviour(behaviour);
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder.WithDeprecationTimeline warnOfChangedBehaviour(final String behaviour, final String advice) {
        return new DeprecationMessageBuilder.WithDeprecationTimeline(new DeprecationMessageBuilder(){

            @Override
            DeprecationMessage build() {
                return new DeprecationMessage(behaviour + ". This behavior is deprecated.", "", advice, null, Documentation.NO_DOCUMENTATION, DeprecatedFeatureUsage.Type.USER_CODE_INDIRECT);
            }
        });
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder.DeprecateAction deprecateAction(String action) {
        return new DeprecationMessageBuilder.DeprecateAction(action);
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder.DeprecateProperty deprecateProperty(Class<?> propertyClass, String property) {
        return new DeprecationMessageBuilder.DeprecateProperty(propertyClass, property);
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder.DeprecateSystemProperty deprecateSystemProperty(String systemProperty) {
        return new DeprecationMessageBuilder.DeprecateSystemProperty(systemProperty);
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder.DeprecateNamedParameter deprecateNamedParameter(String parameter) {
        return new DeprecationMessageBuilder.DeprecateNamedParameter(parameter);
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder.DeprecateMethod deprecateMethod(Class<?> methodClass, String methodWithParams) {
        return new DeprecationMessageBuilder.DeprecateMethod(methodClass, methodWithParams);
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder.DeprecateInvocation deprecateInvocation(String methodWithParams) {
        return new DeprecationMessageBuilder.DeprecateInvocation(methodWithParams);
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder.DeprecateType deprecateType(Class<?> type) {
        return new DeprecationMessageBuilder.DeprecateType(type.getCanonicalName());
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder.DeprecateTask deprecateTask(String task) {
        return new DeprecationMessageBuilder.DeprecateTask(task);
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder.DeprecateTaskType deprecateTaskType(Class<?> task, String path) {
        return new DeprecationMessageBuilder.DeprecateTaskType(task.getCanonicalName(), path);
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder.DeprecatePlugin deprecatePlugin(String plugin) {
        return new DeprecationMessageBuilder.DeprecatePlugin(plugin);
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder.DeprecateInternalApi deprecateInternalApi(String api) {
        return new DeprecationMessageBuilder.DeprecateInternalApi(api);
    }

    @CheckReturnValue
    public static DeprecationMessageBuilder.ConfigurationDeprecationTypeSelector deprecateConfiguration(String configurationType) {
        return new DeprecationMessageBuilder.ConfigurationDeprecationTypeSelector(configurationType);
    }

    static void nagUserWith(DeprecationMessageBuilder<?> deprecationMessageBuilder, Class<?> calledFrom) {
        if (DeprecationLogger.isEnabled()) {
            DeprecationMessage deprecationMessage = deprecationMessageBuilder.build();
            DeprecatedFeatureUsage featureUsage = deprecationMessage.toDeprecatedFeatureUsage(calledFrom);
            DeprecationLogger.nagUserWith(featureUsage);
            if (!featureUsage.formattedMessage().contains("deprecated")) {
                throw new RuntimeException("Deprecation message does not contain the word 'deprecated'. Message: \n" + featureUsage.formattedMessage());
            }
        }
    }

    @Nullable
    public static <T> T whileDisabled(Factory<T> factory) {
        DeprecationLogger.disable();
        try {
            Object object = factory.create();
            return (T)object;
        }
        finally {
            DeprecationLogger.maybeEnable();
        }
    }

    public static void whileDisabled(Runnable action) {
        DeprecationLogger.disable();
        try {
            action.run();
        }
        finally {
            DeprecationLogger.maybeEnable();
        }
    }

    public static <T, E extends Exception> T whileDisabledThrowing(ThrowingFactory<T, E> factory) {
        DeprecationLogger.disable();
        try {
            Object object = DeprecationLogger.toUncheckedThrowingFactory(factory).create();
            return (T)object;
        }
        finally {
            DeprecationLogger.maybeEnable();
        }
    }

    public static <E extends Exception> void whileDisabledThrowing(ThrowingRunnable<E> runnable) {
        DeprecationLogger.disable();
        try {
            DeprecationLogger.toUncheckedThrowingRunnable(runnable).run();
        }
        finally {
            DeprecationLogger.maybeEnable();
        }
    }

    private static void disable() {
        DISABLE_COUNT.set(DISABLE_COUNT.get() + 1);
    }

    private static void maybeEnable() {
        DISABLE_COUNT.set(DISABLE_COUNT.get() - 1);
    }

    private static boolean isEnabled() {
        return DISABLE_COUNT.get() == 0;
    }

    private static <T, E extends Exception> Factory<T> toUncheckedThrowingFactory(final ThrowingFactory<T, E> throwingFactory) {
        return new Factory<T>(){

            @Nullable
            public T create() {
                ThrowingFactory factory = throwingFactory;
                return factory.create();
            }
        };
    }

    private static <E extends Exception> Runnable toUncheckedThrowingRunnable(final ThrowingRunnable<E> throwingRunnable) {
        return new Runnable(){

            @Override
            @Nullable
            public void run() {
                ThrowingRunnable runnable = throwingRunnable;
                runnable.run();
            }
        };
    }

    private static synchronized void nagUserWith(DeprecatedFeatureUsage usage) {
        DEPRECATED_FEATURE_HANDLER.featureUsed(usage);
    }

    public static interface ThrowingRunnable<E extends Exception> {
        public void run() throws E;
    }

    public static interface ThrowingFactory<T, E extends Exception> {
        public T create() throws E;
    }
}

