/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization.transform;

import java.io.File;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.inject.Inject;
import org.gradle.api.artifacts.transform.InputArtifact;
import org.gradle.api.artifacts.transform.TransformAction;
import org.gradle.api.artifacts.transform.TransformOutputs;
import org.gradle.api.artifacts.transform.TransformParameters;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileSystemLocation;
import org.gradle.api.internal.initialization.transform.InstrumentationDependencyAnalysis;
import org.gradle.api.internal.initialization.transform.services.CacheInstrumentationDataBuildService;
import org.gradle.api.internal.initialization.transform.services.InjectedInstrumentationServices;
import org.gradle.api.internal.initialization.transform.utils.InstrumentationAnalysisSerializer;
import org.gradle.api.internal.initialization.transform.utils.InstrumentationTransformUtils;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.internal.classpath.types.InstrumentationTypeRegistry;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not worth caching.")
public abstract class MergeInstrumentationAnalysisTransform
implements TransformAction<Parameters> {
    @Inject
    public abstract ObjectFactory getObjects();

    @PathSensitive(value=PathSensitivity.NAME_ONLY)
    @InputArtifact
    public abstract Provider<FileSystemLocation> getInput();

    public void transform(TransformOutputs outputs) {
        File input = ((FileSystemLocation)this.getInput().get()).getAsFile();
        InstrumentationTransformUtils.InstrumentationInputType inputType = InstrumentationTransformUtils.getInputType(input);
        switch (inputType) {
            case DEPENDENCY_ANALYSIS_DATA: {
                this.doMergeAndOutputAnalysis(input, outputs);
                return;
            }
            case ORIGINAL_ARTIFACT: {
                InstrumentationTransformUtils.outputOriginalArtifact(outputs, input);
                return;
            }
            case INSTRUMENTATION_MARKER: 
            case TYPE_HIERARCHY_ANALYSIS_DATA: {
                return;
            }
        }
        throw new IllegalStateException("Unexpected input type: " + (Object)((Object)inputType));
    }

    private void doMergeAndOutputAnalysis(File input, TransformOutputs outputs) {
        InjectedInstrumentationServices services = (InjectedInstrumentationServices)this.getObjects().newInstance(InjectedInstrumentationServices.class, new Object[0]);
        InstrumentationAnalysisSerializer serializer = new InstrumentationAnalysisSerializer(services.getStringInterner());
        InstrumentationTypeRegistry registry = this.getInstrumentationTypeRegistry();
        InstrumentationDependencyAnalysis data = serializer.readDependencyAnalysis(input);
        TreeMap<String, Set<String>> dependenciesSuperTypes = new TreeMap<String, Set<String>>();
        for (String className : data.getDependencies().keySet()) {
            Set<String> superTypes = registry.getSuperTypes(className);
            if (superTypes.isEmpty()) continue;
            dependenciesSuperTypes.put(className, new TreeSet<String>(superTypes));
        }
        InstrumentationTransformUtils.createInstrumentationClasspathMarker(outputs);
        File output = outputs.file((Object)"merge/instrumentation-dependencies.bin");
        serializer.writeDependencyAnalysis(output, data.getMetadata(), dependenciesSuperTypes);
    }

    private InstrumentationTypeRegistry getInstrumentationTypeRegistry() {
        long contextId = (Long)((Parameters)this.getParameters()).getContextId().get();
        CacheInstrumentationDataBuildService buildService = (CacheInstrumentationDataBuildService)((Parameters)this.getParameters()).getBuildService().get();
        return buildService.getInstrumentationTypeRegistry(contextId);
    }

    public static interface Parameters
    extends TransformParameters {
        @Internal
        public Property<CacheInstrumentationDataBuildService> getBuildService();

        @Internal
        public Property<Long> getContextId();

        @InputFiles
        @PathSensitive(value=PathSensitivity.NAME_ONLY)
        public ConfigurableFileCollection getTypeHierarchyAnalysis();
    }
}

