/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.intercept;

import com.google.common.collect.Sets;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.internal.classpath.intercept.AbstractCallInterceptor;
import org.gradle.internal.classpath.intercept.CallInterceptor;
import org.gradle.internal.classpath.intercept.InterceptScope;
import org.gradle.internal.classpath.intercept.Invocation;
import org.gradle.internal.classpath.intercept.PropertyAwareCallInterceptor;
import org.gradle.internal.classpath.intercept.SignatureAwareCallInterceptor;

public class CompositeCallInterceptor
extends AbstractCallInterceptor
implements SignatureAwareCallInterceptor,
PropertyAwareCallInterceptor {
    private final CallInterceptor first;
    private final CallInterceptor second;

    public CompositeCallInterceptor(CallInterceptor first, CallInterceptor second) {
        super(new InterceptScope[0]);
        this.first = first;
        this.second = second;
    }

    @Override
    public Object intercept(final Invocation invocation, final String consumer) throws Throwable {
        return this.first.intercept(new Invocation(){

            @Override
            public Object getReceiver() {
                return invocation.getReceiver();
            }

            @Override
            public int getArgsCount() {
                return invocation.getArgsCount();
            }

            @Override
            public Object getArgument(int pos) {
                return invocation.getArgument(pos);
            }

            @Override
            public Object callOriginal() throws Throwable {
                return CompositeCallInterceptor.this.second.intercept(invocation, consumer);
            }
        }, consumer);
    }

    @Override
    public Set<InterceptScope> getInterceptScopes() {
        return Sets.union(this.first.getInterceptScopes(), this.second.getInterceptScopes());
    }

    @Override
    @Nullable
    public Class<?> matchesProperty(Class<?> receiverClass) {
        Class<?> typeOfProperty = null;
        if (this.first instanceof PropertyAwareCallInterceptor) {
            typeOfProperty = ((PropertyAwareCallInterceptor)((Object)this.first)).matchesProperty(receiverClass);
        }
        if (typeOfProperty == null && this.second instanceof PropertyAwareCallInterceptor) {
            typeOfProperty = ((PropertyAwareCallInterceptor)((Object)this.second)).matchesProperty(receiverClass);
        }
        return typeOfProperty;
    }

    @Override
    @Nullable
    public SignatureAwareCallInterceptor.SignatureMatch matchesMethodSignature(Class<?> receiverClass, Class<?>[] argumentClasses, boolean isStatic) {
        SignatureAwareCallInterceptor.SignatureMatch signatureMatch = null;
        if (this.first instanceof SignatureAwareCallInterceptor) {
            signatureMatch = ((SignatureAwareCallInterceptor)((Object)this.first)).matchesMethodSignature(receiverClass, argumentClasses, isStatic);
        }
        if (signatureMatch == null && this.second instanceof SignatureAwareCallInterceptor) {
            signatureMatch = ((SignatureAwareCallInterceptor)((Object)this.second)).matchesMethodSignature(receiverClass, argumentClasses, isStatic);
        }
        return signatureMatch;
    }
}

