/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsModuleCheckUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.JsStandardClassIds;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsModuleChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkSuperClass", "isEitherModuleOrNonModule", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "checkers.js"})
@SourceDebugExtension(value={"SMAP\nFirJsModuleChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJsModuleChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsModuleChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,61:1\n295#2,2:62\n*S KotlinDebug\n*F\n+ 1 FirJsModuleChecker.kt\norg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsModuleChecker\n*L\n52#1:62,2\n*E\n"})
public final class FirJsModuleChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsModuleChecker INSTANCE = new FirJsModuleChecker();

    private FirJsModuleChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.checkSuperClass(declaration, context2, reporter);
        if (declaration instanceof FirFile || !this.isEitherModuleOrNonModule(declaration, context2.getSession())) {
            return;
        }
        if (declaration instanceof FirProperty && ((FirProperty)declaration).isVar()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirProperty)declaration).getSource(), FirJsErrors.INSTANCE.getJS_MODULE_PROHIBITED_ON_VAR(), null, 8, null);
        }
        if ((object = FirHelpersKt.closestNonLocalWith(context2, declaration)) == null || (object = ((FirDeclaration)object).getSymbol()) == null) {
            return;
        }
        Object closestNonLocal = object;
        if (!FirJsHelpersKt.isNativeObject(closestNonLocal, context2)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getJS_MODULE_PROHIBITED_ON_NON_NATIVE(), null, 8, null);
        }
        if (FirHelpersKt.isTopLevel(context2)) {
            FirFile firFile = context2.getContainingFile();
            boolean bl = firFile != null ? this.isEitherModuleOrNonModule(firFile, context2.getSession()) : false;
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirJsErrors.INSTANCE.getNESTED_JS_MODULE_PROHIBITED(), null, 8, null);
            }
        }
    }

    private final void checkSuperClass(FirDeclaration declaration, CheckerContext context2, DiagnosticReporter reporter) {
        Object v3;
        Object superClassSymbol;
        block4: {
            FirClass firClass = declaration instanceof FirClass ? (FirClass)declaration : null;
            if (firClass == null) {
                return;
            }
            FirClass classDeclaration = firClass;
            Object object = FirJsHelpersKt.superClassNotAny(classDeclaration, context2.getSession());
            if (object == null || (object = ToSymbolUtilsKt.toSymbol((ConeClassLikeType)object, context2.getSession())) == null) {
                return;
            }
            superClassSymbol = object;
            Iterable $this$firstOrNull$iv = classDeclaration.getSuperTypeRefs();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirTypeRef it = (FirTypeRef)element$iv;
                boolean bl = false;
                ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeTypeOrNull(it);
                if (!Intrinsics.areEqual(coneKotlinType != null ? ToSymbolUtilsKt.toSymbol(coneKotlinType, context2.getSession()) : null, (Object)superClassSymbol)) continue;
                v3 = element$iv;
                break block4;
            }
            v3 = null;
        }
        FirTypeRef superClassRef = v3;
        FirBasedSymbol firBasedSymbol = (FirBasedSymbol)superClassSymbol;
        Object object = superClassRef;
        if (object == null || (object = ((FirTypeRef)object).getSource()) == null) {
            object = ((FirClass)declaration).getSource();
        }
        FirJsModuleCheckUtilsKt.checkJsModuleUsage(firBasedSymbol, context2, reporter, (AbstractKtSourceElement)object);
    }

    private final boolean isEitherModuleOrNonModule(FirDeclaration $this$isEitherModuleOrNonModule, FirSession session2) {
        return FirAnnotationUtilsKt.hasAnnotation($this$isEitherModuleOrNonModule, JsStandardClassIds.Annotations.JsModule, session2) || FirAnnotationUtilsKt.hasAnnotation($this$isEitherModuleOrNonModule, JsStandardClassIds.Annotations.JsNonModule, session2);
    }
}

