/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.attributes;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.attributes.AbstractAttributeContainer;
import org.gradle.api.internal.attributes.AttributeEntry;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesEntry;
import org.gradle.api.internal.provider.Providers;
import org.gradle.api.provider.Provider;
import org.gradle.internal.Cast;
import org.gradle.internal.isolation.Isolatable;
import org.jspecify.annotations.Nullable;

public final class DefaultImmutableAttributesContainer
extends AbstractAttributeContainer
implements ImmutableAttributes {
    private final ImmutableAttributesEntry<?> head;
    private final ImmutableMap<Attribute<?>, ImmutableAttributesEntry<?>> hierarchy;
    private final ImmutableMap<String, ImmutableAttributesEntry<?>> hierarchyByName;
    private final int hashCode;
    private final @Nullable String singleEntryName;
    private final @Nullable ImmutableAttributesEntry<?> singleEntry;

    <T> DefaultImmutableAttributesContainer(ImmutableAttributes parent, ImmutableAttributesEntry<T> head) {
        this.head = head;
        ImmutableMap.Builder hierarchyBuilder = ImmutableMap.builderWithExpectedSize((int)(parent.getEntries().size() + 1));
        ImmutableMap.Builder hierarchyByNameBuilder = ImmutableMap.builderWithExpectedSize((int)(parent.getEntries().size() + 1));
        for (ImmutableAttributesEntry entry : parent.getEntries()) {
            hierarchyBuilder.put(entry.getKey(), (Object)entry);
            hierarchyByNameBuilder.put((Object)entry.getKey().getName(), (Object)entry);
        }
        hierarchyBuilder.put(head.getKey(), head);
        hierarchyByNameBuilder.put((Object)head.getKey().getName(), head);
        this.hierarchy = hierarchyBuilder.buildKeepingLast();
        this.hierarchyByName = hierarchyByNameBuilder.buildKeepingLast();
        this.hashCode = DefaultImmutableAttributesContainer.computeHashCode(parent, head);
        if (this.hierarchyByName.size() == 1) {
            this.singleEntry = (ImmutableAttributesEntry)this.hierarchyByName.values().iterator().next();
            this.singleEntryName = this.singleEntry.getKey().getName();
        } else {
            this.singleEntryName = null;
            this.singleEntry = null;
        }
    }

    private static <T> int computeHashCode(ImmutableAttributes parent, ImmutableAttributesEntry<T> first) {
        int hashCode = parent.hashCode();
        hashCode = 31 * hashCode + first.hashCode();
        return hashCode;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultImmutableAttributesContainer that = (DefaultImmutableAttributesContainer)o;
        if (this.hierarchy.size() != that.hierarchy.size()) {
            return false;
        }
        for (ImmutableAttributesEntry entry : this.getEntries()) {
            ImmutableAttributesEntry otherEntry = that.findEntry((Attribute<K>)entry.getKey());
            if (otherEntry != null && entry.getIsolatedValue().equals(otherEntry.getIsolatedValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public ImmutableAttributesEntry<?> getHead() {
        return this.head;
    }

    @Override
    public ImmutableCollection<ImmutableAttributesEntry<?>> getEntries() {
        return this.hierarchy.values();
    }

    @Override
    public ImmutableSet<Attribute<?>> keySet() {
        return this.hierarchy.keySet();
    }

    public <E> AttributeContainer attribute(Attribute<E> key, E value) {
        throw new UnsupportedOperationException("This container is immutable and cannot be mutated.");
    }

    public <E> AttributeContainer attributeProvider(Attribute<E> key, Provider<? extends E> provider) {
        throw new UnsupportedOperationException("This container is immutable and cannot be mutated.");
    }

    public AttributeContainer addAllLater(AttributeContainer other) {
        throw new UnsupportedOperationException("This container is immutable and cannot be mutated.");
    }

    public <K> @Nullable K getAttribute(Attribute<K> key) {
        if (!this.isValidAttributeRequest(key)) {
            return null;
        }
        ImmutableAttributesEntry<?> entry = this.findEntry(key.getName());
        if (entry == null) {
            return null;
        }
        Isolatable<?> isolatable = entry.getValue();
        Object value = isolatable.isolate();
        if (!DefaultImmutableAttributesContainer.isAppropriateType(value, key)) {
            value = isolatable.coerce(key.getType());
        }
        return (K)Cast.uncheckedCast((Object)value);
    }

    private static boolean isAppropriateType(@Nullable Object value, Attribute<?> key) {
        return value != null && key.getType().isAssignableFrom(value.getClass());
    }

    public <K> @Nullable ImmutableAttributesEntry<K> findEntry(Attribute<K> key) {
        ImmutableAttributesEntry entry = (ImmutableAttributesEntry)this.hierarchy.get(key);
        if (entry == null) {
            return null;
        }
        ImmutableAttributesEntry typedEntry = entry;
        return typedEntry;
    }

    @Override
    public @Nullable ImmutableAttributesEntry<?> findEntry(String name) {
        if (this.singleEntryName == name) {
            return this.singleEntry;
        }
        return (ImmutableAttributesEntry)this.hierarchyByName.get((Object)name);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean contains(Attribute<?> key) {
        return this.getAttribute(key) != null;
    }

    @Override
    public ImmutableAttributes asImmutable() {
        return this;
    }

    @Override
    public Map<Attribute<?>, ?> asMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ImmutableAttributesEntry entry : this.getEntries()) {
            builder.put(entry.getKey(), entry.getIsolatedValue());
        }
        return builder.build();
    }

    @Override
    public Provider<Map<Attribute<?>, AttributeEntry<?>>> getEntriesProvider() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ImmutableAttributesEntry entry : this.getEntries()) {
            builder.put(entry.getKey(), DefaultImmutableAttributesContainer.asEntry(entry));
        }
        return Providers.of((Object)builder.build());
    }

    private static <E> AttributeEntry<E> asEntry(ImmutableAttributesEntry<E> entry) {
        return new AttributeEntry<E>(entry.getKey(), entry.getValue());
    }

    public String toString() {
        TreeMap sorted = new TreeMap(Comparator.comparing(Attribute::getName));
        for (ImmutableAttributesEntry entry : this.getEntries()) {
            sorted.put(entry.getKey(), entry.getIsolatedValue());
        }
        return ((Object)sorted).toString();
    }
}

