/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.core;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import com.googlecode.concurrentlinkedhashmap.EvictionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.persistence.FlushModeType;
import org.grails.datastore.mapping.cache.TPCacheAdapterRepository;
import org.grails.datastore.mapping.collection.PersistentCollection;
import org.grails.datastore.mapping.core.AbstractAttributeStoringSession;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.core.SessionImplementor;
import org.grails.datastore.mapping.core.impl.PendingInsert;
import org.grails.datastore.mapping.core.impl.PendingOperation;
import org.grails.datastore.mapping.core.impl.PendingOperationExecution;
import org.grails.datastore.mapping.core.impl.PendingUpdate;
import org.grails.datastore.mapping.engine.EntityPersister;
import org.grails.datastore.mapping.engine.NativeEntryEntityPersister;
import org.grails.datastore.mapping.engine.NonPersistentTypeException;
import org.grails.datastore.mapping.engine.Persister;
import org.grails.datastore.mapping.model.MappingContext;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.grails.datastore.mapping.query.Query;
import org.grails.datastore.mapping.query.api.QueryableCriteria;
import org.grails.datastore.mapping.transactions.Transaction;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSession<N>
extends AbstractAttributeStoringSession
implements SessionImplementor {
    private static final EvictionListener<PersistentEntity, Collection<PendingInsert>> EXCEPTION_THROWING_INSERT_LISTENER = new EvictionListener<PersistentEntity, Collection<PendingInsert>>(){

        public void onEviction(PersistentEntity key, Collection<PendingInsert> value) {
            throw new DataAccessResourceFailureException("Maximum number (5000) of insert operations to flush() exceeded. Flush the session periodically to avoid this error for batch operations.");
        }
    };
    private static final EvictionListener<PersistentEntity, Collection<PendingUpdate>> EXCEPTION_THROWING_UPDATE_LISTENER = new EvictionListener<PersistentEntity, Collection<PendingUpdate>>(){

        public void onEviction(PersistentEntity key, Collection<PendingUpdate> value) {
            throw new DataAccessResourceFailureException("Maximum number (5000) of update operations to flush() exceeded. Flush the session periodically to avoid this error for batch operations.");
        }
    };
    protected Map<Class, Persister> persisters = new ConcurrentHashMap<Class, Persister>();
    private MappingContext mappingContext;
    protected ConcurrentLinkedQueue lockedObjects = new ConcurrentLinkedQueue();
    private Transaction transaction;
    private Datastore datastore;
    private FlushModeType flushMode = FlushModeType.AUTO;
    protected Map<Class, Map<Serializable, Object>> firstLevelCache = new ConcurrentHashMap<Class, Map<Serializable, Object>>();
    protected Map<Class, Map<Serializable, Object>> firstLevelEntryCache = new ConcurrentHashMap<Class, Map<Serializable, Object>>();
    protected Map<Class, Map<Serializable, Object>> firstLevelEntryCacheDirtyCheck = new ConcurrentHashMap<Class, Map<Serializable, Object>>();
    protected Map<CollectionKey, Collection> firstLevelCollectionCache = new ConcurrentHashMap<CollectionKey, Collection>();
    protected TPCacheAdapterRepository cacheAdapterRepository;
    protected Map<Object, Serializable> objectToKey = new ConcurrentHashMap<Object, Serializable>();
    private Map<PersistentEntity, Collection<PendingInsert>> pendingInserts = new ConcurrentLinkedHashMap.Builder().listener(EXCEPTION_THROWING_INSERT_LISTENER).maximumWeightedCapacity(5000).build();
    private Map<PersistentEntity, Collection<PendingUpdate>> pendingUpdates = new ConcurrentLinkedHashMap.Builder().listener(EXCEPTION_THROWING_UPDATE_LISTENER).maximumWeightedCapacity(5000).build();
    protected Collection<Runnable> pendingDeletes = new ConcurrentLinkedQueue<Runnable>();
    protected Collection<Runnable> postFlushOperations = new ConcurrentLinkedQueue<Runnable>();
    private boolean exceptionOccurred;
    protected ApplicationEventPublisher publisher;

    public AbstractSession(Datastore datastore, MappingContext mappingContext, ApplicationEventPublisher publisher) {
        this.mappingContext = mappingContext;
        this.datastore = datastore;
        this.publisher = publisher;
    }

    public AbstractSession(Datastore datastore, MappingContext mappingContext, ApplicationEventPublisher publisher, TPCacheAdapterRepository cacheAdapterRepository) {
        this.mappingContext = mappingContext;
        this.datastore = datastore;
        this.publisher = publisher;
        this.cacheAdapterRepository = cacheAdapterRepository;
    }

    @Override
    public void addPostFlushOperation(Runnable runnable) {
        if (runnable != null && !this.postFlushOperations.contains(runnable)) {
            this.postFlushOperations.add(runnable);
        }
    }

    @Override
    public void addPendingInsert(PendingInsert insert) {
        Collection<PendingInsert> inserts = this.pendingInserts.get(insert.getEntity());
        if (inserts == null) {
            inserts = new ConcurrentLinkedQueue<PendingInsert>();
            this.pendingInserts.put(insert.getEntity(), inserts);
        }
        inserts.add(insert);
    }

    @Override
    public void addPendingUpdate(PendingUpdate update) {
        Collection<PendingUpdate> inserts = this.pendingUpdates.get(update.getEntity());
        if (inserts == null) {
            inserts = new ConcurrentLinkedQueue<PendingUpdate>();
            this.pendingUpdates.put(update.getEntity(), inserts);
        }
        inserts.add(update);
    }

    public Object getCachedEntry(PersistentEntity entity, Serializable key) {
        return this.getCachedEntry(entity, key, false);
    }

    public Object getCachedEntry(PersistentEntity entity, Serializable key, boolean forDirtyCheck) {
        if (key == null) {
            return null;
        }
        return this.getEntryCache(entity.getJavaClass(), forDirtyCheck).get(key);
    }

    public void cacheEntry(PersistentEntity entity, Serializable key, Object entry) {
        if (key == null || entry == null) {
            return;
        }
        this.cacheEntry(key, entry, this.getEntryCache(entity.getJavaClass(), true), true);
        this.cacheEntry(key, entry, this.getEntryCache(entity.getJavaClass(), false), false);
    }

    protected void cacheEntry(Serializable key, Object entry, Map<Serializable, Object> entryCache, boolean forDirtyCheck) {
        entryCache.put(key, entry);
    }

    @Override
    public Collection getCachedCollection(PersistentEntity entity, Serializable key, String name) {
        if (key == null || name == null) {
            return null;
        }
        return this.firstLevelCollectionCache.get(new CollectionKey(entity.getJavaClass(), key, name));
    }

    @Override
    public void cacheCollection(PersistentEntity entity, Serializable key, Collection collection, String name) {
        if (key == null || collection == null || name == null) {
            return;
        }
        this.firstLevelCollectionCache.put(new CollectionKey(entity.getJavaClass(), key, name), collection);
    }

    @Override
    public Map<PersistentEntity, Collection<PendingInsert>> getPendingInserts() {
        return this.pendingInserts;
    }

    @Override
    public Map<PersistentEntity, Collection<PendingUpdate>> getPendingUpdates() {
        return this.pendingUpdates;
    }

    @Override
    public Collection<Runnable> getPendingDeletes() {
        return this.pendingDeletes;
    }

    @Override
    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    @Override
    public void setFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
    }

    @Override
    public Datastore getDatastore() {
        return this.datastore;
    }

    @Override
    public MappingContext getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public void flush() {
        if (this.exceptionOccurred) {
            throw new InvalidDataAccessResourceUsageException("Do not flush() the Session after an exception occurs");
        }
        boolean hasInserts = this.hasUpdates();
        if (!hasInserts) {
            return;
        }
        this.flushPendingInserts(this.pendingInserts);
        this.pendingInserts.clear();
        this.flushPendingUpdates(this.pendingUpdates);
        this.pendingUpdates.clear();
        this.executePendings(this.pendingDeletes);
        this.handleDirtyCollections();
        this.firstLevelCollectionCache.clear();
        this.executePendings(this.postFlushOperations);
        this.postFlush(hasInserts);
    }

    @Override
    public boolean isDirty(Object instance) {
        if (instance == null) {
            return false;
        }
        EntityPersister persister = (EntityPersister)this.getPersister(instance);
        if (!(persister instanceof NativeEntryEntityPersister)) {
            return false;
        }
        Serializable id = persister.getObjectIdentifier(instance);
        if (id == null) {
            return false;
        }
        Object entry = this.getCachedEntry(persister.getPersistentEntity(), id, false);
        Object instance2 = this.getCachedInstance(instance.getClass(), id);
        return instance != instance2 || ((NativeEntryEntityPersister)persister).isDirty(instance, entry);
    }

    private void handleDirtyCollections() {
        for (Map.Entry<CollectionKey, Collection> entry : this.firstLevelCollectionCache.entrySet()) {
            PersistentCollection persistentCollection;
            Collection collection = entry.getValue();
            if (!(collection instanceof PersistentCollection) || !(persistentCollection = (PersistentCollection)collection).isDirty()) continue;
            CollectionKey key = entry.getKey();
            Object owner = this.getInstanceCache(key.clazz).get(key.key);
            boolean d = this.isDirty(owner);
        }
    }

    protected void flushPendingUpdates(Map<PersistentEntity, Collection<PendingUpdate>> updates) {
        for (Collection<PendingUpdate> pending : updates.values()) {
            this.flushPendingOperations(pending);
        }
    }

    protected void flushPendingInserts(Map<PersistentEntity, Collection<PendingInsert>> inserts) {
        for (Collection<PendingInsert> pending : inserts.values()) {
            this.flushPendingOperations(pending);
        }
    }

    private void flushPendingOperations(Collection operations) {
        for (Object o : operations) {
            PendingOperation pendingOperation = (PendingOperation)o;
            try {
                PendingOperationExecution.executePendingOperation(pendingOperation);
            }
            catch (RuntimeException e) {
                this.exceptionOccurred = true;
                throw e;
            }
        }
    }

    private boolean hasUpdates() {
        return !this.pendingInserts.isEmpty() || !this.pendingUpdates.isEmpty() || !this.pendingDeletes.isEmpty();
    }

    protected void postFlush(boolean hasUpdates) {
    }

    private void executePendings(Collection<Runnable> pendings) {
        try {
            for (Runnable pending : pendings) {
                pending.run();
            }
        }
        catch (RuntimeException e) {
            this.exceptionOccurred = true;
            throw e;
        }
        pendings.clear();
    }

    @Override
    public void clear() {
        this.clearMaps(this.firstLevelCache);
        this.clearMaps(this.firstLevelEntryCache);
        this.clearMaps(this.firstLevelEntryCacheDirtyCheck);
        this.firstLevelCollectionCache.clear();
        this.pendingInserts.clear();
        this.pendingUpdates.clear();
        this.pendingDeletes.clear();
        this.attributes.clear();
        this.exceptionOccurred = false;
    }

    private void clearMaps(Map<Class, Map<Serializable, Object>> mapOfMaps) {
        for (Map<Serializable, Object> cache : mapOfMaps.values()) {
            cache.clear();
        }
    }

    @Override
    public final Persister getPersister(Object o) {
        if (o == null) {
            return null;
        }
        Class cls = o instanceof Class ? (Class)o : (o instanceof PersistentEntity ? ((PersistentEntity)o).getJavaClass() : o.getClass());
        Persister p = this.persisters.get(cls);
        if (p == null) {
            p = this.createPersister(cls, this.getMappingContext());
            this.firstLevelCache.put(cls, new ConcurrentHashMap());
            if (p != null) {
                this.persisters.put(cls, p);
            }
        }
        return p;
    }

    protected abstract Persister createPersister(Class var1, MappingContext var2);

    @Override
    public boolean contains(Object o) {
        if (o == null) {
            return false;
        }
        return this.getInstanceCache(o.getClass()).containsValue(o);
    }

    @Override
    public boolean isCached(Class type, Serializable key) {
        if (type == null || key == null) {
            return false;
        }
        return this.getInstanceCache(type).containsKey(key);
    }

    @Override
    public void cacheInstance(Class type, Serializable key, Object instance) {
        if (type == null || key == null || instance == null) {
            return;
        }
        this.getInstanceCache(type).put(key, instance);
    }

    @Override
    public Object getCachedInstance(Class type, Serializable key) {
        if (type == null || key == null) {
            return false;
        }
        return this.getInstanceCache(type).get(key);
    }

    @Override
    public void clear(Object o) {
        Serializable key;
        if (o == null) {
            return;
        }
        Map<Serializable, Object> cache = this.firstLevelCache.get(o.getClass());
        if (cache != null && (key = this.objectToKey.get(o)) != null) {
            cache.remove(key);
            this.objectToKey.remove(o);
        }
        this.attributes.remove(o);
    }

    @Override
    public void attach(Object o) {
        if (o == null) {
            return;
        }
        EntityPersister p = (EntityPersister)this.getPersister(o);
        if (p == null) {
            return;
        }
        Serializable identifier = p.getObjectIdentifier(o);
        if (identifier != null) {
            this.cacheObject(identifier, o);
        }
    }

    protected void cacheObject(Serializable identifier, Object o) {
        if (identifier == null || o == null) {
            return;
        }
        this.objectToKey.put(o, identifier);
        this.getInstanceCache(o.getClass()).put(identifier, o);
    }

    @Override
    public Serializable persist(Object o) {
        Assert.notNull((Object)o, (String)"Cannot persist null object");
        Persister persister = this.getPersister(o);
        if (persister == null) {
            throw new NonPersistentTypeException("Object [" + o + "] cannot be persisted. It is not a known persistent type.");
        }
        Serializable key = persister.persist(o);
        this.cacheObject(key, o);
        return key;
    }

    @Override
    public void refresh(Object o) {
        Assert.notNull((Object)o, (String)"Cannot persist null object");
        Persister persister = this.getPersister(o);
        if (persister == null) {
            throw new NonPersistentTypeException("Object [" + o + "] cannot be refreshed. It is not a known persistent type.");
        }
        Serializable key = persister.refresh(o);
        this.cacheObject(key, o);
    }

    public Object retrieve(Class type, Serializable key) {
        Object o;
        if (key == null || type == null) {
            return null;
        }
        Persister persister = this.getPersister(type);
        if (persister == null) {
            throw new NonPersistentTypeException("Cannot retrieve object with key [" + key + "]. The class [" + type.getName() + "] is not a known persistent type.");
        }
        PersistentEntity entity = this.getMappingContext().getPersistentEntity(type.getName());
        if (entity != null) {
            key = (Serializable)this.getMappingContext().getConversionService().convert((Object)key, entity.getIdentity().getType());
        }
        if ((o = this.getInstanceCache(type).get(key)) == null && (o = persister.retrieve(key)) != null) {
            this.cacheObject(key, o);
        }
        return o;
    }

    public Object proxy(Class type, Serializable key) {
        if (key == null || type == null) {
            return null;
        }
        Persister persister = this.getPersister(type);
        if (persister == null) {
            throw new NonPersistentTypeException("Cannot retrieve object with key [" + key + "]. The class [" + type.getName() + "] is not a known persistent type.");
        }
        return persister.proxy(key);
    }

    @Override
    public void lock(Object o) {
        throw new UnsupportedOperationException("Datastore [" + this.getClass().getName() + "] does not support locking.");
    }

    public Object lock(Class type, Serializable key) {
        throw new UnsupportedOperationException("Datastore [" + this.getClass().getName() + "] does not support locking.");
    }

    @Override
    public void unlock(Object o) {
        if (o != null) {
            this.lockedObjects.remove(o);
        }
    }

    @Override
    public int deleteAll(QueryableCriteria criteria) {
        List list = criteria.list();
        this.delete(list);
        return list.size();
    }

    @Override
    public int updateAll(QueryableCriteria criteria, Map<String, Object> properties) {
        List list = criteria.list();
        for (Object o : list) {
            BeanWrapperImpl bean = new BeanWrapperImpl(o);
            for (String property : properties.keySet()) {
                bean.setPropertyValue(property, properties.get(property));
            }
        }
        this.persist(list);
        return list.size();
    }

    @Override
    public void delete(final Object obj) {
        if (obj == null) {
            return;
        }
        this.getPendingDeletes().add(new Runnable(){

            public void run() {
                Persister p = AbstractSession.this.getPersister(obj);
                if (p == null) {
                    return;
                }
                p.delete(obj);
                AbstractSession.this.clear(obj);
            }
        });
    }

    @Override
    public void delete(Iterable objects) {
        Persister p;
        if (objects == null) {
            return;
        }
        HashMap toDelete = new HashMap();
        for (Object t : objects) {
            if (t == null || (p = this.getPersister(t)) == null) continue;
            ArrayList listForPersister = (ArrayList)toDelete.get(p);
            if (listForPersister == null) {
                listForPersister = new ArrayList();
                toDelete.put(p, listForPersister);
            }
            listForPersister.add(t);
        }
        for (Map.Entry entry : toDelete.entrySet()) {
            p = (Persister)entry.getKey();
            final List objectsForP = (List)entry.getValue();
            this.pendingDeletes.add(new Runnable(){

                public void run() {
                    p.delete(objectsForP);
                    for (Object o : objectsForP) {
                        AbstractSession.this.clear(o);
                    }
                }
            });
        }
    }

    @Override
    public List<Serializable> persist(Iterable objects) {
        if (objects == null) {
            return Collections.emptyList();
        }
        Iterator i = objects.iterator();
        if (!i.hasNext()) {
            return Collections.emptyList();
        }
        Object obj = i.next();
        Persister p = this.getPersister(obj);
        if (p == null) {
            throw new NonPersistentTypeException("Cannot persist objects. The class [" + obj.getClass().getName() + "] is not a known persistent type.");
        }
        return p.persist(objects);
    }

    @Override
    public List retrieveAll(Class type, Iterable keys) {
        Persister p = this.getPersister(type);
        if (p == null) {
            throw new NonPersistentTypeException("Cannot retrieve objects with keys [" + keys + "]. The class [" + type.getName() + "] is not a known persistent type.");
        }
        return p.retrieveAll(keys);
    }

    @Override
    public List retrieveAll(Class type, Serializable ... keys) {
        Persister p = this.getPersister(type);
        if (p == null) {
            throw new NonPersistentTypeException("Cannot retrieve objects with keys [" + keys + "]. The class [" + type.getName() + "] is not a known persistent type.");
        }
        ArrayList<Object> retrieved = new ArrayList<Object>(keys.length);
        Map<Serializable, Object> cache = this.getInstanceCache(type);
        for (int i = 0; i < keys.length; ++i) {
            Serializable key = keys[i];
            Object cached = cache.get(key);
            if (cached != null) {
                retrieved.add(i, cached);
                continue;
            }
            Object loaded = this.retrieve(type, key);
            retrieved.add(i, loaded);
            cache.put(key, loaded);
        }
        return retrieved;
    }

    @Override
    public Query createQuery(Class type) {
        Persister p = this.getPersister(type);
        if (p == null) {
            throw new NonPersistentTypeException("Cannot create query. The class [" + type + "] is not a known persistent type.");
        }
        return p.createQuery();
    }

    @Override
    public final Transaction beginTransaction() {
        this.transaction = this.beginTransactionInternal();
        return this.transaction;
    }

    protected abstract Transaction beginTransactionInternal();

    @Override
    public Transaction getTransaction() {
        if (this.transaction == null) {
            throw new NoTransactionException("Transaction not started. Call beginTransaction() first");
        }
        return this.transaction;
    }

    private Map<Serializable, Object> getInstanceCache(Class c) {
        Map<Serializable, Object> cache = this.firstLevelCache.get(c);
        if (cache == null) {
            cache = new ConcurrentHashMap<Serializable, Object>();
            this.firstLevelCache.put(c, cache);
        }
        return cache;
    }

    private Map<Serializable, Object> getEntryCache(Class c, boolean forDirtyCheck) {
        Map<Class, Map<Serializable, Object>> caches = forDirtyCheck ? this.firstLevelEntryCacheDirtyCheck : this.firstLevelEntryCache;
        Map<Serializable, Object> cache = caches.get(c);
        if (cache == null) {
            cache = new ConcurrentHashMap<Serializable, Object>();
            caches.put(c, cache);
        }
        return cache;
    }

    private static class CollectionKey {
        final Class clazz;
        final Serializable key;
        final String collectionName;

        private CollectionKey(Class clazz, Serializable key, String collectionName) {
            this.clazz = clazz;
            this.key = key;
            this.collectionName = collectionName;
        }

        public int hashCode() {
            int value = 17;
            value = value * 37 + this.clazz.getName().hashCode();
            value = value * 37 + this.key.hashCode();
            value = value * 37 + this.collectionName.hashCode();
            return value;
        }

        public boolean equals(Object obj) {
            CollectionKey other = (CollectionKey)obj;
            return other.clazz.getName() == this.clazz.getName() && other.key.equals(this.key) && other.collectionName.equals(this.collectionName);
        }

        public String toString() {
            return this.clazz.getName() + ':' + this.key + ':' + this.collectionName;
        }
    }
}

