/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.catalina.Container;
import org.apache.catalina.Globals;
import org.apache.juli.logging.Log;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.res.StringManager;

public class Introspection {
    private static StringManager sm = StringManager.getManager("org.apache.catalina.util");

    public static String getPropertyName(Method setter) {
        return Introspector.decapitalize(setter.getName().substring(3));
    }

    public static boolean isValidSetter(Method method) {
        return method.getName().startsWith("set") && method.getName().length() > 3 && method.getParameterTypes().length == 1 && method.getReturnType().getName().equals("void");
    }

    public static Field[] getDeclaredFields(final Class<?> clazz) {
        Field[] fields = null;
        fields = Globals.IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return clazz.getDeclaredFields();
            }
        }) : clazz.getDeclaredFields();
        return fields;
    }

    public static Method[] getDeclaredMethods(final Class<?> clazz) {
        Method[] methods = null;
        methods = Globals.IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<Method[]>(){

            @Override
            public Method[] run() {
                return clazz.getDeclaredMethods();
            }
        }) : clazz.getDeclaredMethods();
        return methods;
    }

    public static Class<?> loadClass(Container container, String className) {
        ClassLoader cl = container.getLoader().getClassLoader();
        Log log = container.getLogger();
        Class<?> clazz = null;
        try {
            clazz = cl.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            log.debug((Object)sm.getString("introspection.classLoadFailed"), (Throwable)e);
        }
        catch (NoClassDefFoundError e) {
            log.debug((Object)sm.getString("introspection.classLoadFailed"), (Throwable)e);
        }
        catch (ClassFormatError e) {
            log.debug((Object)sm.getString("introspection.classLoadFailed"), (Throwable)e);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.debug((Object)sm.getString("introspection.classLoadFailed"), t);
        }
        return clazz;
    }
}

