/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.springframework.core.style.StylerUtils;
import org.springframework.webflow.core.collection.CollectionUtils;
import org.springframework.webflow.engine.FlowExecutionExceptionHandler;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.execution.FlowExecutionException;

public class FlowExecutionExceptionHandlerSet {
    private List exceptionHandlers = new LinkedList();

    public boolean add(FlowExecutionExceptionHandler exceptionHandler) {
        if (this.contains(exceptionHandler)) {
            return false;
        }
        return this.exceptionHandlers.add(exceptionHandler);
    }

    public boolean addAll(FlowExecutionExceptionHandler[] exceptionHandlers) {
        return CollectionUtils.addAllNoDuplicates(this.exceptionHandlers, exceptionHandlers);
    }

    public boolean contains(FlowExecutionExceptionHandler exceptionHandler) {
        return this.exceptionHandlers.contains(exceptionHandler);
    }

    public boolean remove(FlowExecutionExceptionHandler exceptionHandler) {
        return this.exceptionHandlers.remove(exceptionHandler);
    }

    public int size() {
        return this.exceptionHandlers.size();
    }

    public FlowExecutionExceptionHandler[] toArray() {
        return this.exceptionHandlers.toArray(new FlowExecutionExceptionHandler[this.exceptionHandlers.size()]);
    }

    public boolean handleException(FlowExecutionException exception, RequestControlContext context) {
        Iterator it = this.exceptionHandlers.iterator();
        while (it.hasNext()) {
            FlowExecutionExceptionHandler handler = (FlowExecutionExceptionHandler)it.next();
            if (!handler.canHandle(exception)) continue;
            handler.handle(exception, context);
            return true;
        }
        return false;
    }

    public String toString() {
        return StylerUtils.style((Object)this.exceptionHandlers);
    }
}

