/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.scaffolding.view;

import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.scaffolding.GrailsTemplateGenerator;
import org.codehaus.groovy.grails.scaffolding.view.ScaffoldedGroovyPageView;
import org.codehaus.groovy.grails.web.servlet.mvc.GrailsWebRequest;
import org.codehaus.groovy.grails.web.servlet.view.GrailsViewResolver;
import org.codehaus.groovy.grails.web.servlet.view.GroovyPageView;
import org.codehaus.groovy.grails.web.util.WebUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.View;

public class ScaffoldingViewResolver
extends GrailsViewResolver {
    GrailsTemplateGenerator templateGenerator;
    Map<String, List<String>> scaffoldedActionMap = Collections.emptyMap();
    Map<String, GrailsDomainClass> scaffoldedDomains = Collections.emptyMap();
    static final Map<ViewKey, View> scaffoldedViews = new ConcurrentHashMap<ViewKey, View>();
    static final Log LOG = LogFactory.getLog(ScaffoldingViewResolver.class);

    public static void clearViewCache() {
        scaffoldedViews.clear();
    }

    protected View loadView(String viewName, Locale locale) throws Exception {
        GrailsDomainClass domainClass;
        View resolvedView = super.loadView(viewName, locale);
        if (this.templateGenerator == null || resolvedView instanceof GroovyPageView) {
            return resolvedView;
        }
        GrailsWebRequest webRequest = WebUtils.retrieveGrailsWebRequest();
        List<String> controllerActions = this.scaffoldedActionMap.get(webRequest.getControllerName());
        if (controllerActions != null && controllerActions.contains(webRequest.getActionName()) && (domainClass = this.scaffoldedDomains.get(webRequest.getControllerName())) != null) {
            int i = viewName.lastIndexOf(47);
            String viewFileName = i > -1 ? viewName.substring(i, viewName.length()) : viewName;
            ViewKey viewKey = new ViewKey(webRequest.getControllerName(), viewFileName);
            View v = scaffoldedViews.get(viewKey);
            if (v == null) {
                String viewCode = null;
                try {
                    viewCode = this.generateViewSource(viewFileName, domainClass);
                }
                catch (Exception e) {
                    LOG.error((Object)("Error generating scaffolded view [" + viewName + "]: " + e.getMessage()), (Throwable)e);
                    return resolvedView;
                }
                if (StringUtils.hasLength((String)viewCode)) {
                    v = this.createScaffoldedView(viewName, viewCode);
                    scaffoldedViews.put(viewKey, v);
                }
            }
            if (v != null) {
                return v;
            }
        }
        return resolvedView;
    }

    protected View createScaffoldedView(String viewName, String viewCode) throws Exception {
        ScaffoldedGroovyPageView view = new ScaffoldedGroovyPageView(viewName, viewCode);
        view.setApplicationContext(this.getApplicationContext());
        view.setServletContext(this.getServletContext());
        view.setTemplateEngine(this.templateEngine);
        view.afterPropertiesSet();
        return view;
    }

    protected String generateViewSource(String viewName, GrailsDomainClass domainClass) {
        StringWriter sw = new StringWriter();
        this.templateGenerator.generateView(domainClass, viewName, sw);
        return sw.toString();
    }

    public void setTemplateGenerator(GrailsTemplateGenerator templateGenerator) {
        this.templateGenerator = templateGenerator;
    }

    public void setScaffoldedActionMap(Map scaffoldedActionMap) {
        this.scaffoldedActionMap = scaffoldedActionMap;
    }

    public void setScaffoldedDomains(Map scaffoldedDomains) {
        this.scaffoldedDomains = scaffoldedDomains;
    }

    private class ViewKey {
        private String controller;
        private String action;

        ViewKey(String controller, String action) {
            this.controller = controller;
            this.action = action;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ViewKey viewKey = (ViewKey)o;
            if (this.action != null ? !this.action.equals(viewKey.action) : viewKey.action != null) {
                return false;
            }
            return this.controller.equals(viewKey.controller);
        }

        public int hashCode() {
            int result = this.controller.hashCode();
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            return result;
        }
    }
}

