/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.resolve;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.url.URLRepository;

public class GrailsRepository
extends URLRepository {
    private static final String RELEASE_TOKEN = "/RELEASE_";
    private static final String END_TOKEN = "/";

    public Resource getResource(String source) throws IOException {
        return super.getResource(this.convertSource(source, '.', '_'));
    }

    public void get(String source, File destination) throws IOException {
        super.get(this.convertSource(source, '.', '_'), destination);
    }

    public void put(File source, String destination, boolean overwrite) throws IOException {
        super.put(source, this.convertSource(destination, '.', '_'), overwrite);
    }

    public List list(String parent) throws IOException {
        List lst = super.list(this.convertSource(parent, '.', '_'));
        if (lst == null) {
            return null;
        }
        ArrayList<String> newLst = new ArrayList<String>(lst.size());
        for (Object i : lst) {
            newLst.add(this.convertSource((String)i, '_', '.'));
        }
        return newLst;
    }

    private String convertSource(String source, char from, char to) {
        StringBuilder path = new StringBuilder(source);
        int startIndex = path.indexOf(RELEASE_TOKEN);
        if (startIndex == -1) {
            return source;
        }
        int endIndex = path.indexOf(END_TOKEN, startIndex += RELEASE_TOKEN.length());
        String versionString = path.substring(startIndex, endIndex).replace(from, to);
        path.replace(startIndex, endIndex, versionString);
        return path.toString();
    }
}

