/*
 * Decompiled with CFR 0.152.
 */
package org.radeox.macro;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.radeox.macro.BaseLocaleMacro;
import org.radeox.macro.Macro;
import org.radeox.macro.MacroRepository;
import org.radeox.macro.parameter.MacroParameter;
import org.radeox.util.i18n.ResourceManager;

public class MacroListMacro
extends BaseLocaleMacro {
    public String getLocaleKey() {
        return "macro.macrolist";
    }

    public void execute(Writer writer, MacroParameter params) throws IllegalArgumentException, IOException {
        if (params.getLength() != 0) {
            throw new IllegalArgumentException("MacroListMacro: number of arguments does not match");
        }
        this.appendTo(writer, (String)this.initialContext.get("RenderContext.language_bundle_name"));
    }

    public Writer appendTo(Writer writer, String bundleName) throws IOException {
        List macroList = MacroRepository.getInstance().getPlugins();
        Collections.sort(macroList);
        Iterator iterator = macroList.iterator();
        writer.write("<table class=\"wiki-table\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n");
        writer.write("<tr><th>");
        writer.write(ResourceManager.getString(bundleName, this.getLocaleKey() + ".title.macro"));
        writer.write("</th>");
        writer.write("<th>");
        writer.write(ResourceManager.getString(bundleName, this.getLocaleKey() + ".title.parameters"));
        writer.write("</th>");
        writer.write("<th>");
        writer.write(ResourceManager.getString(bundleName, this.getLocaleKey() + ".title.description"));
        writer.write("</th></tr>\n");
        while (iterator.hasNext()) {
            writer.write("<tr>");
            Macro macro = (Macro)iterator.next();
            writer.write("<td>");
            writer.write(macro.getName());
            writer.write("</td><td>");
            String[] params = macro.getParamDescription();
            if (params.length == 0) {
                writer.write("<i>");
                writer.write(ResourceManager.getString(bundleName, this.getLocaleKey() + ".noparams"));
                writer.write("</i>");
            } else {
                for (int i = 0; i < params.length; ++i) {
                    String parameter = params[i].trim();
                    if (parameter.startsWith("???") && parameter.endsWith("???")) {
                        writer.write("<div class=\"error\">");
                        writer.write(parameter);
                        writer.write("</div>");
                    } else if (parameter.startsWith("?")) {
                        writer.write(parameter.substring(1));
                        writer.write(" <i>");
                        writer.write(ResourceManager.getString(bundleName, this.getLocaleKey() + ".optional"));
                        writer.write("</i>");
                    } else {
                        writer.write(params[i]);
                    }
                    writer.write("<br/>");
                }
            }
            writer.write("</td><td>");
            writer.write(macro.getDescription());
            writer.write("</td>\n");
        }
        writer.write("</table>");
        return writer;
    }
}

