/*
 * Decompiled with CFR 0.152.
 */
package org.grails.datastore.mapping.engine.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.grails.datastore.mapping.core.Datastore;
import org.grails.datastore.mapping.engine.EntityAccess;
import org.grails.datastore.mapping.engine.event.EventType;
import org.grails.datastore.mapping.model.PersistentEntity;
import org.springframework.context.ApplicationEvent;

public abstract class AbstractPersistenceEvent
extends ApplicationEvent {
    private final PersistentEntity entity;
    private final Object entityObject;
    private final EntityAccess entityAccess;
    private boolean cancelled;
    private List<String> excludedListenerNames = new ArrayList<String>();
    private Serializable nativeEvent;

    protected AbstractPersistenceEvent(Datastore source, PersistentEntity entity, EntityAccess entityAccess) {
        super((Object)source);
        this.entity = entity;
        this.entityAccess = entityAccess;
        this.entityObject = null;
    }

    protected AbstractPersistenceEvent(Datastore source, Object entity) {
        super((Object)source);
        this.entityObject = entity;
        this.entity = null;
        this.entityAccess = null;
    }

    public Object getEntityObject() {
        return this.entityObject;
    }

    public PersistentEntity getEntity() {
        return this.entity;
    }

    public EntityAccess getEntityAccess() {
        return this.entityAccess;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void addExcludedListenerName(String name) {
        this.excludedListenerNames.add(name);
    }

    public boolean isListenerExcluded(String name) {
        return this.excludedListenerNames.contains(name);
    }

    public void setNativeEvent(Serializable nativeEvent) {
        this.nativeEvent = nativeEvent;
    }

    public Serializable getNativeEvent() {
        return this.nativeEvent;
    }

    public abstract EventType getEventType();
}

