/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.orm.hibernate.validation;

import org.codehaus.groovy.grails.exceptions.GrailsDomainException;
import org.codehaus.groovy.grails.orm.hibernate.validation.PersistentConstraint;
import org.codehaus.groovy.grails.validation.Constraint;
import org.codehaus.groovy.grails.validation.ConstraintFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentConstraintFactory
implements ConstraintFactory {
    private Class<?> constraintClass;
    private ApplicationContext applicationContext;

    public PersistentConstraintFactory(ApplicationContext applicationContext, Class<?> persistentConstraint) {
        Assert.notNull((Object)applicationContext, (String)"Argument [applicationContext] cannot be null");
        if (persistentConstraint == null || !PersistentConstraint.class.isAssignableFrom(persistentConstraint)) {
            throw new IllegalArgumentException("Argument [persistentConstraint] must be an instance of " + PersistentConstraint.class.getName());
        }
        this.applicationContext = applicationContext;
        this.constraintClass = persistentConstraint;
    }

    public Constraint newInstance() {
        try {
            PersistentConstraint instance = (PersistentConstraint)this.constraintClass.newInstance();
            instance.setApplicationContext(this.applicationContext);
            return instance;
        }
        catch (InstantiationException e) {
            throw new GrailsDomainException("Error instantiating constraint [" + this.constraintClass + "] during validation: " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new GrailsDomainException("Error instantiating constraint [" + this.constraintClass + "] during validation: " + e.getMessage(), (Throwable)e);
        }
    }
}

