/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.commons;

import grails.util.GrailsNameUtils;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.codehaus.groovy.grails.commons.AbstractGrailsClass;
import org.codehaus.groovy.grails.commons.ClassPropertyFetcher;
import org.codehaus.groovy.grails.commons.ComponentCapableDomainClass;
import org.codehaus.groovy.grails.commons.DefaultGrailsDomainClass;
import org.codehaus.groovy.grails.commons.DomainClassArtefactHandler;
import org.codehaus.groovy.grails.commons.GrailsClassUtils;
import org.codehaus.groovy.grails.commons.GrailsDomainClass;
import org.codehaus.groovy.grails.commons.GrailsDomainClassProperty;
import org.codehaus.groovy.grails.commons.GrailsDomainConfigurationUtil;
import org.codehaus.groovy.grails.validation.ConstrainedProperty;
import org.codehaus.groovy.grails.validation.ConstraintsEvaluator;
import org.codehaus.groovy.grails.validation.DefaultConstraintEvaluator;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultGrailsDomainClassProperty
implements GrailsDomainClassProperty {
    private GrailsDomainClass domainClass;
    private boolean persistent = true;
    private boolean identity;
    private boolean oneToMany;
    private String name;
    private Class<?> type;
    private boolean manyToMany;
    private boolean manyToOne;
    private boolean oneToOne;
    private boolean hasOne = false;
    private boolean bidirectional;
    private boolean derived = false;
    private Class<?> referencedPropertyType;
    private GrailsDomainClass referencedDomainClass;
    private GrailsDomainClassProperty otherSide;
    private String naturalName;
    private boolean inherited;
    private int fetchMode = 0;
    private boolean owningSide;
    private String referencePropertyName;
    private boolean embedded;
    private GrailsDomainClass component;
    private boolean basicCollectionType;
    private Map<String, Object> defaultConstraints;

    public DefaultGrailsDomainClassProperty(GrailsDomainClass domainClass, PropertyDescriptor descriptor) {
        this(domainClass, descriptor, null);
    }

    public DefaultGrailsDomainClassProperty(GrailsDomainClass domainClass, PropertyDescriptor descriptor, Map<String, Object> defaultConstraints) {
        this.domainClass = domainClass;
        this.name = descriptor.getName();
        this.naturalName = GrailsNameUtils.getNaturalName((String)descriptor.getName());
        this.type = descriptor.getPropertyType();
        this.identity = descriptor.getName().equals("id");
        if (domainClass != null) {
            if (!domainClass.isRoot()) {
                this.inherited = GrailsClassUtils.isPropertyInherited(domainClass.getClazz(), this.name);
            }
            List transientProps = this.getTransients();
            this.checkIfTransient(transientProps);
            this.establishFetchMode();
        }
        if (descriptor.getReadMethod() == null || descriptor.getWriteMethod() == null) {
            this.persistent = false;
        }
        if (Errors.class.isAssignableFrom(this.type)) {
            this.persistent = false;
        }
        this.defaultConstraints = defaultConstraints;
    }

    private void establishFetchMode() {
        Map fetchMap = this.domainClass.getPropertyValue("fetchMode", Map.class);
        if (fetchMap != null && fetchMap.containsKey(this.name) && "eager".equals(fetchMap.get(this.name))) {
            this.fetchMode = 1;
        }
    }

    private void checkIfTransient(List transientProps) {
        if (transientProps == null) {
            return;
        }
        for (Object currentObj : transientProps) {
            String propertyName;
            if (!(currentObj instanceof String) || !(propertyName = (String)currentObj).equals(this.name)) continue;
            this.persistent = false;
            break;
        }
    }

    private List getTransients() {
        ArrayList allTransientProps = new ArrayList();
        List<Class<?>> allClasses = this.getAllDomainClassesInHierarchy();
        for (Class<?> currentClass : allClasses) {
            ClassPropertyFetcher propertyFetcher = ClassPropertyFetcher.forClass(currentClass);
            Object transientProperty = propertyFetcher.getPropertyValue("transients", false);
            if (!(transientProperty instanceof List)) continue;
            List transientList = (List)transientProperty;
            allTransientProps.addAll(transientList);
        }
        return allTransientProps;
    }

    private List<Class<?>> getAllDomainClassesInHierarchy() {
        ArrayList classesInHierarchy = new ArrayList();
        Class currentClass = this.domainClass.getClazz();
        while (currentClass != null) {
            classesInHierarchy.add(currentClass);
            Class superClass = currentClass.getSuperclass();
            currentClass = DomainClassArtefactHandler.isDomainClass(superClass) ? superClass : null;
        }
        return classesInHierarchy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    @Override
    public boolean isPersistent() {
        return this.persistent;
    }

    @Override
    public boolean isOptional() {
        ConstrainedProperty constrainedProperty = (ConstrainedProperty)this.domainClass.getConstrainedProperties().get(this.name);
        return constrainedProperty != null && constrainedProperty.isNullable();
    }

    @Override
    public boolean isIdentity() {
        return this.identity;
    }

    public void setIdentity(boolean b) {
        this.identity = b;
    }

    @Override
    public boolean isOneToMany() {
        return this.oneToMany;
    }

    @Override
    public boolean isManyToOne() {
        return this.manyToOne;
    }

    @Override
    public String getFieldName() {
        return this.getName().toUpperCase();
    }

    @Override
    public boolean isOneToOne() {
        return this.oneToOne;
    }

    @Override
    public GrailsDomainClass getDomainClass() {
        return this.domainClass;
    }

    @Override
    public boolean isManyToMany() {
        return this.manyToMany;
    }

    protected void setManyToMany(boolean manyToMany) {
        this.manyToMany = manyToMany;
    }

    protected void setOneToMany(boolean oneToMany) {
        this.oneToMany = oneToMany;
    }

    protected void setManyToOne(boolean manyToOne) {
        this.manyToOne = manyToOne;
    }

    protected void setOneToOne(boolean oneToOne) {
        this.oneToOne = oneToOne;
    }

    protected void setHasOne(boolean isHasOne) {
        this.hasOne = isHasOne;
    }

    @Override
    public boolean isHasOne() {
        return this.hasOne;
    }

    protected void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    protected void setBidirectional(boolean bidirectional) {
        this.bidirectional = bidirectional;
    }

    @Override
    public String getTypePropertyName() {
        String shortTypeName = ClassUtils.getShortClassName(this.type);
        return shortTypeName.substring(0, 1).toLowerCase(Locale.ENGLISH) + shortTypeName.substring(1);
    }

    @Override
    public Class getReferencedPropertyType() {
        if (this.isDomainAssociation()) {
            return this.referencedPropertyType;
        }
        return this.getType();
    }

    private boolean isDomainAssociation() {
        return (Collection.class.isAssignableFrom(this.type) || Map.class.isAssignableFrom(this.type)) && this.referencedPropertyType != null;
    }

    @Override
    public boolean isBidirectional() {
        return this.bidirectional;
    }

    protected void setReferencedPropertyType(Class<?> referencedPropertyType) {
        this.referencedPropertyType = referencedPropertyType;
    }

    @Override
    public GrailsDomainClass getReferencedDomainClass() {
        return this.referencedDomainClass;
    }

    @Override
    public void setReferencedDomainClass(GrailsDomainClass referencedDomainClass) {
        if (referencedDomainClass != null) {
            this.referencedDomainClass = referencedDomainClass;
            this.referencedPropertyType = referencedDomainClass.getClazz();
        }
    }

    @Override
    public boolean isAssociation() {
        return this.isOneToMany() || this.isOneToOne() || this.isManyToOne() || this.isManyToMany() || this.isEmbedded();
    }

    @Override
    public boolean isEnum() {
        return GrailsClassUtils.isJdk5Enum(this.getType());
    }

    @Override
    public String getNaturalName() {
        return this.naturalName;
    }

    public String toString() {
        String assType = null;
        if (this.isManyToMany()) {
            assType = "many-to-many";
        } else if (this.isOneToMany()) {
            assType = "one-to-many";
        } else if (this.isOneToOne()) {
            assType = "one-to-one";
        } else if (this.isManyToOne()) {
            assType = "many-to-one";
        } else if (this.isEmbedded()) {
            assType = "embedded";
        }
        return new ToStringBuilder((Object)this).append("name", (Object)this.name).append("type", this.type).append("persistent", this.isPersistent()).append("optional", this.isOptional()).append("association", this.isAssociation()).append("bidirectional", this.isBidirectional()).append("association-type", (Object)assType).toString();
    }

    @Override
    public GrailsDomainClassProperty getOtherSide() {
        return this.otherSide;
    }

    @Override
    public void setOtherSide(GrailsDomainClassProperty property) {
        if (!this.equals(property)) {
            this.setBidirectional(true);
            if (this.isOneToOne() && property.isOneToMany()) {
                this.setOneToOne(false);
                this.setManyToOne(true);
            }
        }
        this.otherSide = property;
    }

    @Override
    public boolean isInherited() {
        return this.inherited;
    }

    @Override
    public int getFetchMode() {
        return this.fetchMode;
    }

    @Override
    public boolean isOwningSide() {
        return this.isHasOne() || this.owningSide;
    }

    @Override
    public void setOwningSide(boolean b) {
        this.owningSide = b;
    }

    @Override
    public boolean isCircular() {
        return this.otherSide != null ? this.otherSide.getDomainClass().getClazz().isAssignableFrom(this.domainClass.getClazz()) : this.getReferencedPropertyType().isAssignableFrom(this.domainClass.getClazz());
    }

    public void setReferencePropertyName(String name) {
        this.referencePropertyName = name;
    }

    @Override
    public String getReferencedPropertyName() {
        return this.referencePropertyName;
    }

    @Override
    public boolean isEmbedded() {
        return this.embedded;
    }

    @Override
    public GrailsDomainClass getComponent() {
        return this.component;
    }

    public void setEmbedded(boolean isEmbedded) {
        this.embedded = isEmbedded;
        if (isEmbedded) {
            this.component = new ComponentDomainClass(this.getType());
            GrailsDomainClass dc = this.getDomainClass();
            if (dc instanceof ComponentCapableDomainClass) {
                ((ComponentCapableDomainClass)((Object)dc)).addComponent(this.component);
            }
        }
    }

    @Override
    public boolean isDerived() {
        return this.derived;
    }

    @Override
    public void setDerived(boolean derived) {
        this.derived = derived;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof GrailsDomainClassProperty) {
            if (!super.equals(o)) {
                GrailsDomainClassProperty otherProp = (GrailsDomainClassProperty)o;
                boolean namesMatch = otherProp.getName().equals(this.getName());
                boolean typesMatch = otherProp.getReferencedPropertyType().equals(this.getReferencedPropertyType());
                Class myActualClass = this.getDomainClass().getClazz();
                Class otherActualClass = otherProp.getDomainClass().getClazz();
                boolean classMatch = otherActualClass.isAssignableFrom(myActualClass) || myActualClass.isAssignableFrom(otherActualClass);
                return namesMatch && typesMatch && classMatch;
            }
            return true;
        }
        return false;
    }

    public void setBasicCollectionType(boolean b) {
        this.basicCollectionType = b;
    }

    @Override
    public boolean isBasicCollectionType() {
        return this.basicCollectionType;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ComponentDomainClass
    extends AbstractGrailsClass
    implements GrailsDomainClass {
        private GrailsDomainClassProperty[] properties;
        private Map constraints;
        private List transients;

        public ComponentDomainClass(Class<?> type) {
            super(type, "");
            this.constraints = Collections.emptyMap();
            this.transients = Collections.emptyList();
            PropertyDescriptor[] descriptors = this.getPropertyDescriptors();
            List tmp = this.getPropertyValue("transients", List.class);
            if (tmp != null) {
                this.transients = tmp;
            }
            this.properties = this.createDomainClassProperties(descriptors);
            ConstraintsEvaluator constraintsEvaluator = this.getConstraintsEvaluator();
            this.constraints = constraintsEvaluator.evaluate(type, this.properties);
        }

        private ConstraintsEvaluator getConstraintsEvaluator() {
            if (DefaultGrailsDomainClassProperty.this.domainClass instanceof DefaultGrailsDomainClass) {
                return ((DefaultGrailsDomainClass)DefaultGrailsDomainClassProperty.this.domainClass).getConstraintsEvaluator();
            }
            return new DefaultConstraintEvaluator();
        }

        private GrailsDomainClassProperty[] createDomainClassProperties(PropertyDescriptor[] descriptors) {
            ArrayList<DefaultGrailsDomainClassProperty> props = new ArrayList<DefaultGrailsDomainClassProperty>();
            Collection<String> embeddedNames = this.getEmbeddedList();
            for (PropertyDescriptor descriptor : descriptors) {
                if (!this.isPersistentProperty(descriptor)) continue;
                DefaultGrailsDomainClassProperty property = new DefaultGrailsDomainClassProperty(this, descriptor, DefaultGrailsDomainClassProperty.this.defaultConstraints);
                props.add(property);
                if (!embeddedNames.contains(property.getName())) continue;
                property.setEmbedded(true);
            }
            return props.toArray(new GrailsDomainClassProperty[props.size()]);
        }

        private Collection<String> getEmbeddedList() {
            Object potentialList = GrailsClassUtils.getStaticPropertyValue(this.getClazz(), "embedded");
            if (potentialList instanceof Collection) {
                return (Collection)potentialList;
            }
            return Collections.emptyList();
        }

        private boolean isPersistentProperty(PropertyDescriptor descriptor) {
            String propertyName = descriptor.getName();
            return GrailsDomainConfigurationUtil.isNotConfigurational(descriptor) && !this.transients.contains(propertyName);
        }

        @Override
        public boolean isOwningClass(Class dc) {
            return dc != null && dc.equals(DefaultGrailsDomainClassProperty.this.getDomainClass().getClazz());
        }

        @Override
        public GrailsDomainClassProperty[] getProperties() {
            return this.properties;
        }

        @Override
        public GrailsDomainClassProperty[] getPersistantProperties() {
            return this.properties;
        }

        @Override
        public GrailsDomainClassProperty[] getPersistentProperties() {
            return this.properties;
        }

        @Override
        public GrailsDomainClassProperty getIdentifier() {
            return null;
        }

        @Override
        public GrailsDomainClassProperty getVersion() {
            return null;
        }

        @Override
        public Map getAssociationMap() {
            return Collections.emptyMap();
        }

        @Override
        public GrailsDomainClassProperty getPropertyByName(String name) {
            for (GrailsDomainClassProperty property : this.properties) {
                if (!property.getName().equals(name)) continue;
                return property;
            }
            return null;
        }

        @Override
        public GrailsDomainClassProperty getPersistentProperty(String name) {
            return this.getPropertyByName(name);
        }

        @Override
        public String getFieldName(String propertyName) {
            return null;
        }

        @Override
        public boolean isOneToMany(String propertyName) {
            return false;
        }

        @Override
        public boolean isManyToOne(String propertyName) {
            return false;
        }

        @Override
        public boolean isBidirectional(String propertyName) {
            return false;
        }

        @Override
        public Class<?> getRelatedClassType(String propertyName) {
            return this.getPropertyByName(propertyName).getReferencedPropertyType();
        }

        @Override
        public Map getConstrainedProperties() {
            return this.constraints;
        }

        @Override
        public Validator getValidator() {
            return null;
        }

        @Override
        public void setValidator(Validator validator) {
        }

        @Override
        public String getMappingStrategy() {
            return "GORM";
        }

        @Override
        public boolean isRoot() {
            return true;
        }

        public Set getSubClasses() {
            return Collections.emptySet();
        }

        @Override
        public void refreshConstraints() {
            this.constraints = this.getConstraintsEvaluator().evaluate(this.getClazz(), this.getPersistentProperties());
        }

        @Override
        public boolean hasSubClasses() {
            return false;
        }

        @Override
        public Map getMappedBy() {
            return Collections.emptyMap();
        }

        @Override
        public boolean hasPersistentProperty(String propertyName) {
            for (int i = 0; i < this.properties.length; ++i) {
                GrailsDomainClassProperty persistantProperty = this.properties[i];
                if (!persistantProperty.getName().equals(propertyName)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void setMappingStrategy(String strategy) {
        }
    }
}

