/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.grails.compiler.injection;

import grails.validation.ValidationErrors;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.grails.compiler.injection.ASTErrorsHelper;
import org.codehaus.groovy.grails.compiler.injection.GrailsArtefactClassInjector;
import org.codehaus.groovy.syntax.Token;
import org.springframework.validation.Errors;

public class ASTValidationErrorsHelper
implements ASTErrorsHelper {
    private static final ConstantExpression NULL_EXPRESSION = new ConstantExpression(null);
    private static final String SET_ERRORS_METHOD_NAME = "setErrors";
    private static final String GET_ERRORS_METHOD_NAME = "getErrors";
    private static final String HAS_ERRORS_METHOD_NAME = "hasErrors";
    private static final String CLEAR_ERRORS_METHOD_NAME = "clearErrors";
    private static final String INIT_ERRORS_METHOD_NAME = "initErrors";
    private static final String ERRORS_PROPERTY_NAME = "errors";
    private static final Token EQUALS_SYMBOL = Token.newSymbol((int)100, (int)0, (int)0);
    private static final ClassNode ERRORS_CLASS_NODE = new ClassNode(Errors.class);
    private static final VariableExpression ERRORS_EXPRESSION = new VariableExpression("errors");
    private static final VariableExpression THIS_EXPRESSION = new VariableExpression("this");
    private static final TupleExpression EMPTY_TUPLE = new TupleExpression();
    private static final MethodCallExpression INIT_ERRORS_METHOD_CALL_EXPRESSION = new MethodCallExpression((Expression)THIS_EXPRESSION, "initErrors", (Expression)EMPTY_TUPLE);

    public void injectErrorsCode(ClassNode classNode) {
        this.addErrorsField(classNode);
        this.addInitErrorsMethod(classNode);
        this.addGetErrorsMethod(classNode);
        this.addHasErrorsMethod(classNode);
        this.addSetErrorsMethod(classNode);
        this.addClearErrorsMethod(classNode);
    }

    protected void addErrorsField(ClassNode paramTypeClassNode) {
        FieldNode errorsField = paramTypeClassNode.getField(ERRORS_PROPERTY_NAME);
        if (errorsField == null) {
            paramTypeClassNode.addField(new FieldNode(ERRORS_PROPERTY_NAME, 1, ERRORS_CLASS_NODE, paramTypeClassNode, (Expression)NULL_EXPRESSION));
        }
    }

    protected void addInitErrorsMethod(ClassNode paramTypeClassNode) {
        MethodNode initErrorsMethod = paramTypeClassNode.getMethod(INIT_ERRORS_METHOD_NAME, GrailsArtefactClassInjector.ZERO_PARAMETERS);
        if (initErrorsMethod == null) {
            BlockStatement initErrorsMethodCode = new BlockStatement();
            BinaryExpression errorsIsNullExpression = new BinaryExpression((Expression)ERRORS_EXPRESSION, Token.newSymbol((int)123, (int)0, (int)0), (Expression)NULL_EXPRESSION);
            ArgumentListExpression beanPropertyBindingResultConstructorArgs = new ArgumentListExpression((Expression)THIS_EXPRESSION, (Expression)new ConstantExpression((Object)paramTypeClassNode.getName()));
            ExpressionStatement newEvaluatorExpression = new ExpressionStatement((Expression)new BinaryExpression((Expression)ERRORS_EXPRESSION, EQUALS_SYMBOL, (Expression)new ConstructorCallExpression(new ClassNode(ValidationErrors.class), (Expression)beanPropertyBindingResultConstructorArgs)));
            IfStatement initErrorsIfNullStatement = new IfStatement(new BooleanExpression((Expression)errorsIsNullExpression), (Statement)newEvaluatorExpression, (Statement)new ExpressionStatement((Expression)new EmptyExpression()));
            initErrorsMethodCode.addStatement((Statement)initErrorsIfNullStatement);
            paramTypeClassNode.addMethod(new MethodNode(INIT_ERRORS_METHOD_NAME, 2, ClassHelper.VOID_TYPE, GrailsArtefactClassInjector.ZERO_PARAMETERS, GrailsArtefactClassInjector.EMPTY_CLASS_ARRAY, (Statement)initErrorsMethodCode));
        }
    }

    protected void addClearErrorsMethod(ClassNode paramTypeClassNode) {
        MethodNode clearErrorsMethod = paramTypeClassNode.getMethod(CLEAR_ERRORS_METHOD_NAME, GrailsArtefactClassInjector.ZERO_PARAMETERS);
        if (clearErrorsMethod == null) {
            BlockStatement clearErrorsMethodCode = new BlockStatement();
            BinaryExpression nullOutErrorsFieldExpression = new BinaryExpression((Expression)ERRORS_EXPRESSION, EQUALS_SYMBOL, (Expression)NULL_EXPRESSION);
            clearErrorsMethodCode.addStatement((Statement)new ExpressionStatement((Expression)nullOutErrorsFieldExpression));
            paramTypeClassNode.addMethod(new MethodNode(CLEAR_ERRORS_METHOD_NAME, 1, ClassHelper.VOID_TYPE, GrailsArtefactClassInjector.ZERO_PARAMETERS, GrailsArtefactClassInjector.EMPTY_CLASS_ARRAY, (Statement)clearErrorsMethodCode));
        }
    }

    protected void addHasErrorsMethod(ClassNode paramTypeClassNode) {
        MethodNode getErrorsMethod = paramTypeClassNode.getMethod(HAS_ERRORS_METHOD_NAME, GrailsArtefactClassInjector.ZERO_PARAMETERS);
        if (getErrorsMethod == null) {
            BlockStatement hasErrorsMethodCode = new BlockStatement();
            hasErrorsMethodCode.addStatement((Statement)new ExpressionStatement((Expression)INIT_ERRORS_METHOD_CALL_EXPRESSION));
            ReturnStatement returnStatement = new ReturnStatement((Expression)new BooleanExpression((Expression)new MethodCallExpression((Expression)ERRORS_EXPRESSION, HAS_ERRORS_METHOD_NAME, (Expression)EMPTY_TUPLE)));
            hasErrorsMethodCode.addStatement((Statement)returnStatement);
            paramTypeClassNode.addMethod(new MethodNode(HAS_ERRORS_METHOD_NAME, 1, new ClassNode(Boolean.class), GrailsArtefactClassInjector.ZERO_PARAMETERS, GrailsArtefactClassInjector.EMPTY_CLASS_ARRAY, (Statement)hasErrorsMethodCode));
        }
    }

    protected void addGetErrorsMethod(ClassNode paramTypeClassNode) {
        MethodNode getErrorsMethod = paramTypeClassNode.getMethod(GET_ERRORS_METHOD_NAME, GrailsArtefactClassInjector.ZERO_PARAMETERS);
        if (getErrorsMethod == null) {
            BlockStatement getErrorsMethodCode = new BlockStatement();
            getErrorsMethodCode.addStatement((Statement)new ExpressionStatement((Expression)INIT_ERRORS_METHOD_CALL_EXPRESSION));
            ReturnStatement returnStatement = new ReturnStatement((Expression)ERRORS_EXPRESSION);
            getErrorsMethodCode.addStatement((Statement)returnStatement);
            paramTypeClassNode.addMethod(new MethodNode(GET_ERRORS_METHOD_NAME, 1, ERRORS_CLASS_NODE, GrailsArtefactClassInjector.ZERO_PARAMETERS, GrailsArtefactClassInjector.EMPTY_CLASS_ARRAY, (Statement)getErrorsMethodCode));
        }
    }

    protected void addSetErrorsMethod(ClassNode paramTypeClassNode) {
        String errorsArgumentName = "$errorsArg";
        MethodNode setErrorsMethod = paramTypeClassNode.getMethod(SET_ERRORS_METHOD_NAME, new Parameter[]{new Parameter(ERRORS_CLASS_NODE, "$errorsArg")});
        if (setErrorsMethod == null) {
            BinaryExpression assignErrorsExpression = new BinaryExpression((Expression)ERRORS_EXPRESSION, EQUALS_SYMBOL, (Expression)new VariableExpression("$errorsArg"));
            setErrorsMethod = new MethodNode(SET_ERRORS_METHOD_NAME, 1, ClassHelper.VOID_TYPE, new Parameter[]{new Parameter(ERRORS_CLASS_NODE, "$errorsArg")}, GrailsArtefactClassInjector.EMPTY_CLASS_ARRAY, (Statement)new ExpressionStatement((Expression)assignErrorsExpression));
            paramTypeClassNode.addMethod(setErrorsMethod);
        }
    }
}

