package org.springframework.uaa.client.util;

import java.io.InputStream;

import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;

/**
 * Utility to parse an {@link InputStream} into a {@link Document}.
 * 
 * @author Christian Dupuis
 * @since 1.0.1
 */
public abstract class XmlUtils {

	private static DocumentBuilderFactory documentBuilderFactory = null;

	/**
	 * Parse given {@link InputStream} into {@link Document}.
	 * 
	 * <p>
	 * If the execution environment has restrictions on creating {@link DocumentBuilderFactory} instances pass a
	 * suitable builder factory into {@link #setDocumentBuilderFactory(DocumentBuilderFactory)} before invoking this
	 * method.
	 */
	public static Document parse(InputStream is) {
		try {
			return getDocumentBuilderFactory().newDocumentBuilder().parse(is);
		}
		catch (Exception e) {
			throw new IllegalStateException("Could not parse steam into Document", e);
		}
	}

	/**
	 * Sets the internally used {@link DocumentBuilderFactory}. Useful when running UAA in a restricted environment like
	 * some OSGi runtimes.
	 */
	public static void setDocumentBuilderFactory(DocumentBuilderFactory newDocumentBuilderFactory) {
		documentBuilderFactory = newDocumentBuilderFactory;
	}

	/**
	 * Returns or creates the {@link DocumentBuilderFactory} to be used for all XML parsing.
	 */
	private static DocumentBuilderFactory getDocumentBuilderFactory() {
		if (documentBuilderFactory == null) {
			documentBuilderFactory = DocumentBuilderFactory.newInstance();
		}
		return documentBuilderFactory;
	}
}
