/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.ApplicationContext;
import io.micronaut.context.ApplicationContextConfiguration;
import io.micronaut.context.BeanContext;
import io.micronaut.context.BeanDefinitionDelegate;
import io.micronaut.context.BeanRegistration;
import io.micronaut.context.BeanResolutionContext;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.BootstrapContextCompatible;
import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.EachBean;
import io.micronaut.context.annotation.EachProperty;
import io.micronaut.context.env.BootstrapPropertySourceLocator;
import io.micronaut.context.env.DefaultEnvironment;
import io.micronaut.context.env.Environment;
import io.micronaut.context.env.PropertySource;
import io.micronaut.context.exceptions.ConfigurationException;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.ArgumentConversionContext;
import io.micronaut.core.convert.ConversionService;
import io.micronaut.core.convert.TypeConverter;
import io.micronaut.core.convert.TypeConverterRegistrar;
import io.micronaut.core.io.scan.ClassPathResourceLoader;
import io.micronaut.core.naming.Named;
import io.micronaut.core.naming.conventions.StringConvention;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.inject.BeanConfiguration;
import io.micronaut.inject.BeanDefinition;
import io.micronaut.inject.BeanDefinitionReference;
import io.micronaut.inject.qualifiers.Qualifiers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DefaultApplicationContext
extends DefaultBeanContext
implements ApplicationContext {
    private final ConversionService conversionService;
    private final ClassPathResourceLoader resourceLoader;
    private Environment environment;
    private Iterable<BeanConfiguration> resolvedConfigurations;
    private List<BeanDefinitionReference> resolvedBeanReferences;

    public DefaultApplicationContext(String ... environmentNames) {
        this(ClassPathResourceLoader.defaultLoader((ClassLoader)DefaultApplicationContext.class.getClassLoader()), environmentNames);
    }

    public DefaultApplicationContext(final @NonNull ClassPathResourceLoader resourceLoader, final String ... environmentNames) {
        this(new ApplicationContextConfiguration(){

            @Override
            @NonNull
            public ClassLoader getClassLoader() {
                return this.getResourceLoader().getClassLoader();
            }

            @Override
            @NonNull
            public ClassPathResourceLoader getResourceLoader() {
                ArgumentUtils.requireNonNull((String)"resourceLoader", (Object)resourceLoader);
                return resourceLoader;
            }

            @Override
            @NonNull
            public List<String> getEnvironments() {
                ArgumentUtils.requireNonNull((String)"environmentNames", (Object)environmentNames);
                return Arrays.asList(environmentNames);
            }
        });
    }

    public DefaultApplicationContext(@NonNull ApplicationContextConfiguration configuration) {
        super(configuration);
        ArgumentUtils.requireNonNull((String)"configuration", (Object)configuration);
        this.conversionService = this.createConversionService();
        this.resourceLoader = configuration.getResourceLoader();
        this.environment = this.createEnvironment(configuration);
    }

    @Override
    @NonNull
    public <T> ApplicationContext registerSingleton(@NonNull Class<T> type, @NonNull T singleton, @Nullable Qualifier<T> qualifier, boolean inject) {
        return (ApplicationContext)super.registerSingleton((Class)type, (Object)singleton, (Qualifier)qualifier, inject);
    }

    @Override
    @NonNull
    protected Iterable<BeanConfiguration> resolveBeanConfigurations() {
        if (this.resolvedConfigurations != null) {
            return this.resolvedConfigurations;
        }
        return super.resolveBeanConfigurations();
    }

    @Override
    protected List<BeanDefinitionReference> resolveBeanDefinitionReferences() {
        if (this.resolvedBeanReferences == null) {
            return super.resolveBeanDefinitionReferences();
        }
        return this.resolvedBeanReferences;
    }

    @Override
    @NonNull
    protected List<BeanDefinitionReference> resolveBeanDefinitionReferences(Predicate<BeanDefinitionReference> predicate) {
        if (this.resolvedBeanReferences == null) {
            return super.resolveBeanDefinitionReferences(predicate);
        }
        if (predicate == null) {
            return this.resolvedBeanReferences;
        }
        ArrayList<BeanDefinitionReference> beanDefinitionReferences = new ArrayList<BeanDefinitionReference>(this.resolvedBeanReferences.size());
        for (BeanDefinitionReference reference : this.resolvedBeanReferences) {
            if (!predicate.test(reference)) continue;
            beanDefinitionReferences.add(reference);
        }
        return beanDefinitionReferences;
    }

    @NonNull
    protected Environment createEnvironment(@NonNull ApplicationContextConfiguration configuration) {
        return new RuntimeConfiguredEnvironment(configuration);
    }

    @NonNull
    protected ConversionService createConversionService() {
        return ConversionService.SHARED;
    }

    @Override
    @NonNull
    public ConversionService<?> getConversionService() {
        return this.conversionService;
    }

    @Override
    @NonNull
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    @NonNull
    public synchronized ApplicationContext start() {
        this.startEnvironment();
        return (ApplicationContext)super.start();
    }

    @Override
    @NonNull
    public synchronized ApplicationContext stop() {
        return (ApplicationContext)super.stop();
    }

    public boolean containsProperty(String name) {
        return this.getEnvironment().containsProperty(name);
    }

    public boolean containsProperties(String name) {
        return this.getEnvironment().containsProperties(name);
    }

    public <T> Optional<T> getProperty(String name, ArgumentConversionContext<T> conversionContext) {
        return this.getEnvironment().getProperty(name, conversionContext);
    }

    @NonNull
    public Collection<String> getPropertyEntries(@NonNull String name) {
        return this.getEnvironment().getPropertyEntries(name);
    }

    @NonNull
    public Map<String, Object> getProperties(@Nullable String name, @Nullable StringConvention keyFormat) {
        return this.getEnvironment().getProperties(name, keyFormat);
    }

    @Override
    protected void registerConfiguration(BeanConfiguration configuration) {
        if (this.getEnvironment().isActive(configuration)) {
            super.registerConfiguration(configuration);
        }
    }

    protected void startEnvironment() {
        Environment defaultEnvironment = this.getEnvironment();
        defaultEnvironment.start();
        this.registerSingleton(Environment.class, defaultEnvironment);
    }

    @Override
    protected void initializeContext(List<BeanDefinitionReference> contextScopeBeans, List<BeanDefinitionReference> processedBeans, List<BeanDefinitionReference> parallelBeans) {
        this.initializeTypeConverters(this);
        super.initializeContext(contextScopeBeans, processedBeans, parallelBeans);
    }

    @Override
    protected <T> Collection<BeanDefinition<T>> findBeanCandidates(BeanResolutionContext resolutionContext, Argument<T> beanType, BeanDefinition<?> filter, boolean filterProxied) {
        Collection<BeanDefinition<T>> candidates = super.findBeanCandidates(resolutionContext, beanType, filter, filterProxied);
        return this.transformIterables(resolutionContext, candidates, filterProxied);
    }

    @Override
    protected <T> Collection<BeanDefinition<T>> findBeanCandidates(BeanResolutionContext resolutionContext, Argument<T> beanType, boolean filterProxied, Predicate<BeanDefinition<T>> predicate) {
        Collection<BeanDefinition<T>> candidates = super.findBeanCandidates(resolutionContext, beanType, filterProxied, predicate);
        return this.transformIterables(resolutionContext, candidates, filterProxied);
    }

    @Override
    protected <T> Collection<BeanDefinition<T>> transformIterables(BeanResolutionContext resolutionContext, Collection<BeanDefinition<T>> candidates, boolean filterProxied) {
        if (!candidates.isEmpty()) {
            ArrayList transformedCandidates = new ArrayList();
            for (BeanDefinition candidate : candidates) {
                if (candidate.hasDeclaredStereotype(EachProperty.class)) {
                    boolean isList = candidate.booleanValue(EachProperty.class, "list").orElse(false);
                    String property = candidate.stringValue(ConfigurationReader.class, "prefix").map(prefix -> prefix.substring(0, prefix.length() - (isList ? 3 : 2))).orElseGet(() -> candidate.stringValue(EachProperty.class).orElse(null));
                    String primaryPrefix = candidate.stringValue(EachProperty.class, "primary").orElse(null);
                    if (StringUtils.isNotEmpty((CharSequence)property)) {
                        if (isList) {
                            List entries = (List)this.getEnvironment().getProperty(property, List.class, Collections.emptyList());
                            if (entries.isEmpty()) continue;
                            for (int i = 0; i < entries.size(); ++i) {
                                if (entries.get(i) == null) continue;
                                BeanDefinitionDelegate<T> delegate = BeanDefinitionDelegate.create(candidate);
                                String index = String.valueOf(i);
                                if (primaryPrefix != null && primaryPrefix.equals(index)) {
                                    delegate.put(BeanDefinitionDelegate.PRIMARY_ATTRIBUTE, true);
                                }
                                delegate.put("Array", index);
                                delegate.put(Named.class.getName(), index);
                                if (!delegate.isEnabled(this, resolutionContext)) continue;
                                transformedCandidates.add(delegate);
                            }
                            continue;
                        }
                        Collection propertyEntries = this.getEnvironment().getPropertyEntries(property);
                        if (propertyEntries.isEmpty()) continue;
                        for (String key : propertyEntries) {
                            BeanDefinitionDelegate<T> delegate = BeanDefinitionDelegate.create(candidate);
                            if (primaryPrefix != null && primaryPrefix.equals(key)) {
                                delegate.put(BeanDefinitionDelegate.PRIMARY_ATTRIBUTE, true);
                            }
                            delegate.put(EachProperty.class.getName(), delegate.getBeanType());
                            delegate.put(Named.class.getName(), key);
                            if (!delegate.isEnabled(this, resolutionContext)) continue;
                            transformedCandidates.add(delegate);
                        }
                        continue;
                    }
                    throw new IllegalArgumentException("Blank value specified to @Each property for bean: " + candidate);
                }
                if (candidate.hasDeclaredStereotype(EachBean.class)) {
                    Class dependentType = candidate.classValue(EachBean.class).orElse(null);
                    if (dependentType == null) {
                        transformedCandidates.add(candidate);
                        continue;
                    }
                    Collection<BeanDefinition<T>> dependentCandidates = this.findBeanCandidates(resolutionContext, Argument.of((Class)dependentType), filterProxied, null);
                    if (dependentCandidates.isEmpty()) continue;
                    for (BeanDefinition dependentCandidate : dependentCandidates) {
                        Optional<Qualifier> optional;
                        BeanDefinitionDelegate delegate = BeanDefinitionDelegate.create(candidate);
                        if (dependentCandidate instanceof BeanDefinitionDelegate) {
                            BeanDefinitionDelegate parentDelegate = (BeanDefinitionDelegate)dependentCandidate;
                            optional = parentDelegate.get(Named.class.getName(), String.class).map(Qualifiers::byName);
                        } else {
                            Optional qualifierName = dependentCandidate.getAnnotationNameByStereotype("javax.inject.Qualifier");
                            optional = qualifierName.map(name -> Qualifiers.byAnnotation((AnnotationMetadata)dependentCandidate, name));
                        }
                        if (dependentCandidate.isPrimary()) {
                            delegate.put(BeanDefinitionDelegate.PRIMARY_ATTRIBUTE, true);
                        }
                        optional.ifPresent(qualifier -> {
                            Argument<?>[] arguments;
                            String qualifierKey = "javax.inject.Qualifier";
                            for (Argument<?> argument : arguments = candidate.getConstructor().getArguments()) {
                                Class argumentType = argument.getType();
                                if (!argumentType.equals(dependentType)) continue;
                                Map<Argument<?>, Qualifier> qualifedArg = Collections.singletonMap(argument, qualifier);
                                delegate.put(qualifierKey, qualifedArg);
                                break;
                            }
                            if (qualifier instanceof Named) {
                                delegate.put(Named.class.getName(), ((Named)qualifier).getName());
                            }
                            if (delegate.isEnabled(this, resolutionContext)) {
                                transformedCandidates.add(delegate);
                            }
                        });
                    }
                    continue;
                }
                if (candidate.hasStereotype(ConfigurationReader.class)) {
                    String prefix2 = candidate.stringValue(ConfigurationReader.class, "prefix").orElse(null);
                    if (prefix2 != null) {
                        boolean isMap;
                        int mapIndex = prefix2.indexOf("*");
                        int arrIndex = prefix2.indexOf("[*]");
                        boolean isList = arrIndex > -1;
                        boolean bl = isMap = mapIndex > -1;
                        if (isList || isMap) {
                            int startIndex = isList ? arrIndex : mapIndex;
                            String eachProperty = prefix2.substring(0, startIndex);
                            if (eachProperty.endsWith(".")) {
                                eachProperty = eachProperty.substring(0, eachProperty.length() - 1);
                            }
                            if (StringUtils.isNotEmpty((CharSequence)eachProperty)) {
                                Object entries;
                                if (isList) {
                                    entries = (List)this.getProperty(eachProperty, List.class, Collections.emptyList());
                                    if (entries.isEmpty()) continue;
                                    for (int i = 0; i < entries.size(); ++i) {
                                        if (entries.get(i) == null) continue;
                                        BeanDefinitionDelegate<T> delegate = BeanDefinitionDelegate.create(candidate);
                                        String index = String.valueOf(i);
                                        delegate.put("Array", index);
                                        delegate.put(Named.class.getName(), index);
                                        if (!delegate.isEnabled(this, resolutionContext) || !this.containsProperties(prefix2.replace("*", index))) continue;
                                        transformedCandidates.add(delegate);
                                    }
                                    continue;
                                }
                                entries = (Map)this.getProperty(eachProperty, Map.class, Collections.emptyMap());
                                if (entries.isEmpty()) continue;
                                for (Object key : entries.keySet()) {
                                    BeanDefinitionDelegate<T> delegate = BeanDefinitionDelegate.create(candidate);
                                    delegate.put(EachProperty.class.getName(), delegate.getBeanType());
                                    delegate.put(Named.class.getName(), key.toString());
                                    if (!delegate.isEnabled(this, resolutionContext) || !this.containsProperties(prefix2.replace("*", key.toString()))) continue;
                                    transformedCandidates.add(delegate);
                                }
                                continue;
                            }
                            throw new IllegalArgumentException("Blank value specified to @Each property for bean: " + candidate);
                        }
                        transformedCandidates.add(candidate);
                        continue;
                    }
                    transformedCandidates.add(candidate);
                    continue;
                }
                transformedCandidates.add(candidate);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finalized bean definitions candidates: {}", transformedCandidates);
            }
            return transformedCandidates;
        }
        return candidates;
    }

    @Override
    protected <T> BeanDefinition<T> findConcreteCandidate(Class<T> beanType, Qualifier<T> qualifier, Collection<BeanDefinition<T>> candidates) {
        if (candidates.stream().allMatch(BeanDefinition::isIterable) && qualifier instanceof Named) {
            Named named = (Named)qualifier;
            String name = named.getName();
            for (BeanDefinition<T> candidate : candidates) {
                Optional resolvedQualifier;
                BeanDefinitionDelegate delegate;
                Optional value;
                if (!(candidate instanceof BeanDefinitionDelegate) || !((value = (delegate = (BeanDefinitionDelegate)candidate).get(Named.class.getName(), String.class)).isPresent() ? name.equals(value.get()) : (resolvedQualifier = delegate.get("javax.inject.Qualifier", Qualifier.class)).isPresent() && ((Qualifier)resolvedQualifier.get()).equals(qualifier))) continue;
                return delegate;
            }
        }
        return super.findConcreteCandidate(beanType, qualifier, candidates);
    }

    @Override
    public Optional<String> resolvePlaceholders(String str) {
        return this.getEnvironment().getPlaceholderResolver().resolvePlaceholders(str);
    }

    @Override
    public String resolveRequiredPlaceholders(String str) throws ConfigurationException {
        return this.getEnvironment().getPlaceholderResolver().resolveRequiredPlaceholders(str);
    }

    protected void initializeTypeConverters(BeanContext beanContext) {
        Collection<BeanRegistration<TypeConverter>> typeConverters = beanContext.getBeanRegistrations(TypeConverter.class);
        for (BeanRegistration<TypeConverter> typeConverterRegistration : typeConverters) {
            TypeConverter typeConverter = typeConverterRegistration.getBean();
            List<Argument<TypeConverter>> typeArguments = typeConverterRegistration.getBeanDefinition().getTypeArguments(TypeConverter.class);
            if (typeArguments.size() != 2) continue;
            Class source = typeArguments.get(0).getType();
            Class target = typeArguments.get(1).getType();
            if (source == null || target == null || source == Object.class && target == Object.class) continue;
            this.getConversionService().addConverter(source, target, typeConverter);
        }
        Collection<TypeConverterRegistrar> registrars = beanContext.getBeansOfType(TypeConverterRegistrar.class);
        for (TypeConverterRegistrar registrar : registrars) {
            registrar.register(this.conversionService);
        }
    }

    private class RuntimeConfiguredEnvironment
    extends DefaultEnvironment {
        private final ApplicationContextConfiguration configuration;
        private final boolean isRuntimeConfigured;
        private BootstrapPropertySourceLocator bootstrapPropertySourceLocator;
        private BootstrapEnvironment bootstrapEnvironment;

        RuntimeConfiguredEnvironment(ApplicationContextConfiguration configuration) {
            super(configuration);
            this.configuration = configuration;
            this.isRuntimeConfigured = Boolean.getBoolean("micronaut.bootstrap.context") || DefaultApplicationContext.this.resourceLoader.getResource("bootstrap.yml").isPresent() || DefaultApplicationContext.this.resourceLoader.getResource("bootstrap.properties").isPresent();
        }

        boolean isRuntimeConfigured() {
            return this.isRuntimeConfigured;
        }

        @Override
        public Environment stop() {
            if (this.bootstrapEnvironment != null) {
                this.bootstrapEnvironment.stop();
            }
            return super.stop();
        }

        @Override
        public Environment start() {
            if (this.isRuntimeConfigured && this.bootstrapEnvironment == null) {
                this.bootstrapEnvironment = this.createBootstrapEnvironment(this.getActiveNames().toArray(new String[0]));
            }
            return super.start();
        }

        @Override
        protected synchronized List<PropertySource> readPropertySourceList(String name) {
            if (this.isRuntimeConfigured) {
                if (DefaultBeanContext.LOG.isInfoEnabled()) {
                    DefaultBeanContext.LOG.info("Reading Startup environment from bootstrap.yml");
                }
                this.refreshablePropertySources.addAll(this.bootstrapEnvironment.getRefreshablePropertySources());
                String[] environmentNamesArray = this.getActiveNames().toArray(new String[0]);
                BootstrapPropertySourceLocator bootstrapPropertySourceLocator = this.resolveBootstrapPropertySourceLocator(environmentNamesArray);
                for (PropertySource propertySource : bootstrapPropertySourceLocator.findPropertySources(this.bootstrapEnvironment)) {
                    this.addPropertySource(propertySource);
                    this.refreshablePropertySources.add(propertySource);
                }
                Collection<PropertySource> bootstrapPropertySources = this.bootstrapEnvironment.getPropertySources();
                for (PropertySource bootstrapPropertySource : bootstrapPropertySources) {
                    this.addPropertySource(bootstrapPropertySource);
                }
                return super.readPropertySourceList(name);
            }
            return super.readPropertySourceList(name);
        }

        private BootstrapPropertySourceLocator resolveBootstrapPropertySourceLocator(String ... environmentNames) {
            if (this.bootstrapPropertySourceLocator == null) {
                BootstrapApplicationContext bootstrapContext = new BootstrapApplicationContext(this.bootstrapEnvironment, environmentNames);
                bootstrapContext.start();
                if (bootstrapContext.containsBean(BootstrapPropertySourceLocator.class)) {
                    DefaultApplicationContext.this.initializeTypeConverters(bootstrapContext);
                    this.bootstrapPropertySourceLocator = bootstrapContext.getBean(BootstrapPropertySourceLocator.class);
                } else {
                    this.bootstrapPropertySourceLocator = BootstrapPropertySourceLocator.EMPTY_LOCATOR;
                }
            }
            return this.bootstrapPropertySourceLocator;
        }

        private BootstrapEnvironment createBootstrapEnvironment(String ... environmentNames) {
            BootstrapEnvironment bootstrapEnvironment = new BootstrapEnvironment(this.resourceLoader, this.conversionService, this.configuration, environmentNames);
            for (PropertySource source : this.propertySources.values()) {
                bootstrapEnvironment.addPropertySource(source);
            }
            bootstrapEnvironment.start();
            for (String pkg : bootstrapEnvironment.getPackages()) {
                this.addPackage(pkg);
            }
            return bootstrapEnvironment;
        }
    }

    private class BootstrapApplicationContext
    extends DefaultApplicationContext {
        private final BootstrapEnvironment bootstrapEnvironment;

        BootstrapApplicationContext(BootstrapEnvironment bootstrapEnvironment, String ... activeEnvironments) {
            super(DefaultApplicationContext.this.resourceLoader, activeEnvironments);
            this.bootstrapEnvironment = bootstrapEnvironment;
        }

        @Override
        @NonNull
        public Environment getEnvironment() {
            return this.bootstrapEnvironment;
        }

        @Override
        @NonNull
        protected BootstrapEnvironment createEnvironment(@NonNull ApplicationContextConfiguration configuration) {
            return this.bootstrapEnvironment;
        }

        @Override
        @NonNull
        protected List<BeanDefinitionReference> resolveBeanDefinitionReferences(Predicate<BeanDefinitionReference> predicate) {
            List<BeanDefinitionReference> refs = super.resolveBeanDefinitionReferences(null);
            DefaultApplicationContext.this.resolvedBeanReferences = refs;
            ArrayList<BeanDefinitionReference> beanDefinitionReferences = new ArrayList<BeanDefinitionReference>();
            for (BeanDefinitionReference reference : refs) {
                if (predicate != null && !predicate.test(reference) || !reference.isAnnotationPresent(BootstrapContextCompatible.class)) continue;
                beanDefinitionReferences.add(reference);
            }
            return beanDefinitionReferences;
        }

        @Override
        @NonNull
        protected Iterable<BeanConfiguration> resolveBeanConfigurations() {
            Iterable<BeanConfiguration> beanConfigurations = super.resolveBeanConfigurations();
            DefaultApplicationContext.this.resolvedConfigurations = beanConfigurations;
            return beanConfigurations;
        }

        @Override
        protected void startEnvironment() {
            this.registerSingleton(Environment.class, this.bootstrapEnvironment);
        }

        @Override
        protected void initializeEventListeners() {
        }

        @Override
        protected void initializeContext(List<BeanDefinitionReference> contextScopeBeans, List<BeanDefinitionReference> processedBeans, List<BeanDefinitionReference> parallelBeans) {
        }

        @Override
        protected void processParallelBeans(List<BeanDefinitionReference> parallelBeans) {
        }

        @Override
        public void publishEvent(@NonNull Object event) {
        }
    }

    private static class BootstrapEnvironment
    extends DefaultEnvironment {
        BootstrapEnvironment(final ClassPathResourceLoader resourceLoader, final ConversionService conversionService, final ApplicationContextConfiguration configuration, final String ... activeEnvironments) {
            super(new ApplicationContextConfiguration(){

                @Override
                public Optional<Boolean> getDeduceEnvironments() {
                    return Optional.of(false);
                }

                @Override
                @NonNull
                public ClassLoader getClassLoader() {
                    return resourceLoader.getClassLoader();
                }

                @Override
                @NonNull
                public List<String> getEnvironments() {
                    return Arrays.asList(activeEnvironments);
                }

                @Override
                public boolean isEnvironmentPropertySource() {
                    return configuration.isEnvironmentPropertySource();
                }

                @Override
                @Nullable
                public List<String> getEnvironmentVariableIncludes() {
                    return configuration.getEnvironmentVariableIncludes();
                }

                @Override
                @Nullable
                public List<String> getEnvironmentVariableExcludes() {
                    return configuration.getEnvironmentVariableExcludes();
                }

                @Override
                @NonNull
                public ConversionService<?> getConversionService() {
                    return conversionService;
                }

                @Override
                @NonNull
                public ClassPathResourceLoader getResourceLoader() {
                    return resourceLoader;
                }
            });
        }

        @Override
        protected String getPropertySourceRootName() {
            String bootstrapName = System.getProperty("micronaut.bootstrap.name");
            return StringUtils.isNotEmpty((CharSequence)bootstrapName) ? bootstrapName : "bootstrap";
        }

        @Override
        protected boolean shouldDeduceEnvironments() {
            return false;
        }

        public List<PropertySource> getRefreshablePropertySources() {
            return this.refreshablePropertySources;
        }

        @Override
        protected List<PropertySource> readPropertySourceList(String name) {
            return super.readPropertySourceList(name).stream().map(BootstrapPropertySource::new).collect(Collectors.toList());
        }
    }

    private static class BootstrapPropertySource
    implements PropertySource {
        private final PropertySource delegate;

        BootstrapPropertySource(PropertySource bootstrapPropertySource) {
            this.delegate = bootstrapPropertySource;
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public PropertySource.PropertyConvention getConvention() {
            return this.delegate.getConvention();
        }

        @Override
        public String getName() {
            return this.delegate.getName();
        }

        @Override
        public Object get(String key) {
            return this.delegate.get(key);
        }

        @Override
        public Iterator<String> iterator() {
            return this.delegate.iterator();
        }

        public int getOrder() {
            return this.delegate.getOrder() + 10;
        }
    }
}

