/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.validation.async;

import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.async.publisher.Publishers;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.Element;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.scheduling.annotation.Async;
import java.util.concurrent.CompletionStage;

@Internal
public final class AsyncTypeElementVisitor
implements TypeElementVisitor<Object, Async> {
    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void visitMethod(MethodElement element, VisitorContext context) {
        ClassElement returnType = element.getReturnType();
        if (returnType != null) {
            if (returnType.isAssignable(CompletionStage.class)) return;
            if (returnType.isAssignable(Void.TYPE)) return;
            if (Publishers.getKnownReactiveTypes().stream().anyMatch(arg_0 -> ((ClassElement)returnType).isAssignable(arg_0))) {
                return;
            }
        }
        boolean bl = false;
        boolean isValid = bl;
        if (isValid) return;
        context.fail("Method must return void or a subtype of CompletionStage", (Element)element);
    }
}

