/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.beans.visitor;

import io.micronaut.context.annotation.ConfigurationReader;
import io.micronaut.context.annotation.Executable;
import io.micronaut.core.annotation.AccessorsStyle;
import io.micronaut.core.annotation.AnnotationClassValue;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.Introspected;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.inject.annotation.AnnotationMetadataHierarchy;
import io.micronaut.inject.ast.ClassElement;
import io.micronaut.inject.ast.ConstructorElement;
import io.micronaut.inject.ast.ElementModifier;
import io.micronaut.inject.ast.ElementQuery;
import io.micronaut.inject.ast.FieldElement;
import io.micronaut.inject.ast.MemberElement;
import io.micronaut.inject.ast.MethodElement;
import io.micronaut.inject.ast.ParameterElement;
import io.micronaut.inject.ast.PropertyElement;
import io.micronaut.inject.beans.visitor.BeanIntrospectionWriter;
import io.micronaut.inject.visitor.TypeElementVisitor;
import io.micronaut.inject.visitor.VisitorContext;
import io.micronaut.inject.writer.ClassGenerationException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;

@Internal
public class IntrospectedTypeElementVisitor
implements TypeElementVisitor<Object, Object> {
    public static final int POSITION = -100;
    private static final String JAVAX_VALIDATION_CONSTRAINT = "javax.validation.Constraint";
    private static final AnnotationValue<Introspected.IndexedAnnotation> ANN_CONSTRAINT = AnnotationValue.builder(Introspected.IndexedAnnotation.class).member("annotation", new AnnotationClassValue[]{new AnnotationClassValue("javax.validation.Constraint")}).build();
    private static final String JAVAX_VALIDATION_VALID = "javax.validation.Valid";
    private static final AnnotationValue<Introspected.IndexedAnnotation> ANN_VALID = AnnotationValue.builder(Introspected.IndexedAnnotation.class).member("annotation", new AnnotationClassValue[]{new AnnotationClassValue("javax.validation.Valid")}).build();
    private static final Introspected.AccessKind[] DEFAULT_ACCESS_KIND = new Introspected.AccessKind[]{Introspected.AccessKind.METHOD};
    private static final Introspected.Visibility[] DEFAULT_VISIBILITY = new Introspected.Visibility[]{Introspected.Visibility.DEFAULT};
    private Map<String, BeanIntrospectionWriter> writers = new LinkedHashMap<String, BeanIntrospectionWriter>(10);
    private List<AbstractIntrospection> abstractIntrospections = new ArrayList<AbstractIntrospection>();
    private AbstractIntrospection currentAbstractIntrospection;
    private ClassElement currentClassElement;

    public int getOrder() {
        return -100;
    }

    @Override
    public void visitClass(ClassElement element, VisitorContext context) {
        AnnotationValue introspected;
        this.currentClassElement = null;
        this.currentAbstractIntrospection = null;
        if (!element.isPrivate() && element.hasStereotype(Introspected.class) && (introspected = element.getAnnotation(Introspected.class)) != null && !this.writers.containsKey(element.getName())) {
            this.currentClassElement = element;
            this.processIntrospected(element, context, (AnnotationValue<Introspected>)introspected);
        }
    }

    @Override
    public void visitConstructor(ConstructorElement element, VisitorContext context) {
        ClassElement declaringType = element.getDeclaringType();
        if (element.getDeclaringType().hasStereotype(ConfigurationReader.class)) {
            ParameterElement[] parameters = element.getParameters();
            this.introspectIfValidated(context, declaringType, parameters);
        }
    }

    private boolean isIntrospected(VisitorContext context, ClassElement c) {
        return this.writers.containsKey(c.getName()) || context.getClassElement(c.getPackageName() + ".$" + c.getSimpleName() + "$Introspection").isPresent();
    }

    @Override
    public void visitMethod(MethodElement element, VisitorContext context) {
        ClassElement declaringType = element.getDeclaringType();
        String methodName = element.getName();
        String[] readPrefixes = declaringType.getValue(AccessorsStyle.class, "readPrefixes", String[].class).orElse(new String[]{"get"});
        String[] writePrefixes = declaringType.getValue(AccessorsStyle.class, "writePrefixes", String[].class).orElse(new String[]{"set"});
        if (declaringType.hasStereotype(ConfigurationReader.class) && NameUtils.isReaderName((String)methodName, (String[])readPrefixes) && !this.writers.containsKey(declaringType.getName())) {
            boolean hasConstraints;
            boolean bl = hasConstraints = element.hasStereotype(JAVAX_VALIDATION_CONSTRAINT) || element.hasStereotype(JAVAX_VALIDATION_VALID);
            if (hasConstraints) {
                this.processIntrospected(declaringType, context, (AnnotationValue<Introspected>)AnnotationValue.builder(Introspected.class).build());
            }
        }
        if (this.currentAbstractIntrospection != null) {
            if (NameUtils.isReaderName((String)methodName, (String[])readPrefixes) && element.getParameters().length == 0) {
                String propertyName = NameUtils.getPropertyNameForGetter((String)methodName, (String[])readPrefixes);
                AbstractPropertyElement propertyElement = this.currentAbstractIntrospection.properties.computeIfAbsent(propertyName, s -> new AbstractPropertyElement(element.getDeclaringType(), element.getReturnType(), propertyName));
                propertyElement.readMethod = element;
            } else if (NameUtils.isWriterName((String)methodName, (String[])writePrefixes) && element.getParameters().length == 1) {
                String propertyName = NameUtils.getPropertyNameForSetter((String)methodName, (String[])writePrefixes);
                AbstractPropertyElement propertyElement = this.currentAbstractIntrospection.properties.computeIfAbsent(propertyName, s -> new AbstractPropertyElement(element.getDeclaringType(), element.getParameters()[0].getType(), propertyName));
                propertyElement.writeMethod = element;
            }
        }
    }

    @Override
    public void visitField(FieldElement element, VisitorContext context) {
        ClassElement declaringType = element.getDeclaringType();
        if (declaringType.hasStereotype(ConfigurationReader.class) && !this.writers.containsKey(declaringType.getName())) {
            boolean hasConstraints;
            boolean bl = hasConstraints = element.hasStereotype(JAVAX_VALIDATION_CONSTRAINT) || element.hasStereotype(JAVAX_VALIDATION_VALID);
            if (hasConstraints) {
                this.processIntrospected(declaringType, context, (AnnotationValue<Introspected>)AnnotationValue.builder(Introspected.class).build());
            }
        }
    }

    private void introspectIfValidated(VisitorContext context, ClassElement declaringType, ParameterElement[] parameters) {
        boolean hasConstraints;
        if (!this.writers.containsKey(declaringType.getName()) && (hasConstraints = Arrays.stream(parameters).anyMatch(e -> e.hasStereotype(JAVAX_VALIDATION_CONSTRAINT) || e.hasStereotype(JAVAX_VALIDATION_VALID)))) {
            this.processIntrospected(declaringType, context, (AnnotationValue<Introspected>)AnnotationValue.builder(Introspected.class).build());
        }
    }

    private void processIntrospected(ClassElement element, VisitorContext context, AnnotationValue<Introspected> introspected) {
        Set indexedAnnotations;
        Object[] packages = introspected.stringValues("packages");
        Object[] classes = (AnnotationClassValue[])introspected.get((CharSequence)"classes", AnnotationClassValue[].class, (Object)new AnnotationClassValue[0]);
        boolean metadata = introspected.booleanValue("annotationMetadata").orElse(true);
        Set includes = CollectionUtils.setOf((Object[])introspected.stringValues("includes"));
        Set excludes = CollectionUtils.setOf((Object[])introspected.stringValues("excludes"));
        Set excludedAnnotations = CollectionUtils.setOf((Object[])introspected.stringValues("excludedAnnotations"));
        Set includedAnnotations = CollectionUtils.setOf((Object[])introspected.stringValues("includedAnnotations"));
        Set toIndex = CollectionUtils.setOf((Object[])((Object[])introspected.get((CharSequence)"indexed", AnnotationValue[].class, (Object)new AnnotationValue[0])));
        Object[] accessKinds = (Introspected.AccessKind[])introspected.enumValues("accessKind", Introspected.AccessKind.class);
        Object[] visibilities = (Introspected.Visibility[])introspected.enumValues("visibility", Introspected.Visibility.class);
        if (ArrayUtils.isEmpty((Object[])accessKinds)) {
            accessKinds = DEFAULT_ACCESS_KIND;
        }
        if (ArrayUtils.isEmpty((Object[])visibilities)) {
            visibilities = DEFAULT_VISIBILITY;
        }
        Object[] finalAccessKinds = accessKinds;
        Object[] finalVisibilities = visibilities;
        if (CollectionUtils.isEmpty((Collection)toIndex)) {
            indexedAnnotations = CollectionUtils.setOf((Object[])new AnnotationValue[]{ANN_CONSTRAINT, ANN_VALID});
        } else {
            toIndex.addAll(CollectionUtils.setOf((Object[])new AnnotationValue[]{ANN_CONSTRAINT, ANN_VALID}));
            indexedAnnotations = toIndex;
        }
        if (ArrayUtils.isNotEmpty((Object[])classes)) {
            AtomicInteger index = new AtomicInteger(0);
            for (Object aClass : classes) {
                Optional<ClassElement> classElement = context.getClassElement(aClass.getName());
                classElement.ifPresent(arg_0 -> this.lambda$processIntrospected$3(context, element, index, metadata, includes, excludes, excludedAnnotations, indexedAnnotations, (Introspected.Visibility[])finalVisibilities, (Introspected.AccessKind[])finalAccessKinds, arg_0));
            }
        } else if (ArrayUtils.isNotEmpty((Object[])packages)) {
            if (includedAnnotations.isEmpty()) {
                context.fail("When specifying 'packages' you must also specify 'includedAnnotations' to limit scanning", element);
            } else {
                for (Object aPackage : packages) {
                    ClassElement[] elements = context.getClassElements((String)aPackage, includedAnnotations.toArray(new String[0]));
                    int j = 0;
                    for (ClassElement classElement : elements) {
                        if (classElement.isAbstract() || !classElement.isPublic() || this.isIntrospected(context, classElement)) continue;
                        BeanIntrospectionWriter writer = new BeanIntrospectionWriter(element.getName(), j++, element, classElement, metadata ? element.getAnnotationMetadata() : null);
                        this.processElement(metadata, includes, excludes, excludedAnnotations, indexedAnnotations, classElement, writer, (Introspected.Visibility[])finalVisibilities, (Introspected.AccessKind[])finalAccessKinds);
                    }
                }
            }
        } else {
            BeanIntrospectionWriter writer = new BeanIntrospectionWriter(element, metadata ? element.getAnnotationMetadata() : null);
            this.processElement(metadata, includes, excludes, excludedAnnotations, indexedAnnotations, element, writer, (Introspected.Visibility[])finalVisibilities, (Introspected.AccessKind[])finalAccessKinds);
        }
    }

    @Override
    @NonNull
    public TypeElementVisitor.VisitorKind getVisitorKind() {
        return TypeElementVisitor.VisitorKind.ISOLATING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void finish(VisitorContext visitorContext) {
        try {
            for (AbstractIntrospection abstractIntrospection : this.abstractIntrospections) {
                Collection<AbstractPropertyElement> properties = abstractIntrospection.properties.values();
                if (!CollectionUtils.isNotEmpty(properties)) continue;
                this.processBeanProperties(abstractIntrospection.writer, properties, abstractIntrospection.includes, abstractIntrospection.excludes, abstractIntrospection.ignored, abstractIntrospection.indexedAnnotations, abstractIntrospection.metadata);
                this.writers.put(abstractIntrospection.writer.getBeanType().getClassName(), abstractIntrospection.writer);
            }
            if (this.writers.isEmpty()) return;
            for (BeanIntrospectionWriter writer : this.writers.values()) {
                try {
                    writer.accept(visitorContext);
                }
                catch (IOException e) {
                    throw new ClassGenerationException("I/O error occurred during class generation: " + e.getMessage(), e);
                    return;
                }
            }
        }
        finally {
            this.abstractIntrospections.clear();
            this.writers.clear();
        }
    }

    private void processElement(boolean metadata, Set<String> includes, Set<String> excludes, Set<String> excludedAnnotations, Set<AnnotationValue> indexedAnnotations, ClassElement ce, BeanIntrospectionWriter writer, Introspected.Visibility[] visibilities, Introspected.AccessKind ... accessKinds) {
        Optional<MethodElement> constructorElement = ce.getPrimaryConstructor();
        if (ce.isAbstract() && !constructorElement.isPresent() && ce.hasStereotype(Introspected.class)) {
            this.currentAbstractIntrospection = new AbstractIntrospection(writer, includes, excludes, excludedAnnotations, indexedAnnotations, metadata);
            this.abstractIntrospections.add(this.currentAbstractIntrospection);
        } else {
            List<Object> beanFields;
            ElementQuery<MemberElement> query;
            List<PropertyElement> beanProperties;
            List<Introspected.AccessKind> accessKindSet = Arrays.asList(accessKinds);
            Set visibilitySet = CollectionUtils.setOf((Object[])visibilities);
            List<Object> list = beanProperties = accessKindSet.contains(Introspected.AccessKind.METHOD) ? ce.getBeanProperties() : Collections.emptyList();
            if (accessKindSet.contains(Introspected.AccessKind.FIELD)) {
                Predicate<String> nameFilter = null;
                if (accessKindSet.iterator().next() == Introspected.AccessKind.METHOD) {
                    List<Object> finalBeanProperties = beanProperties;
                    nameFilter = name -> {
                        for (PropertyElement beanProperty : finalBeanProperties) {
                            if (!name.equals(beanProperty.getName())) continue;
                            return false;
                        }
                        return true;
                    };
                }
                query = visibilitySet.contains(Introspected.Visibility.DEFAULT) ? ElementQuery.of(FieldElement.class).onlyAccessible().modifiers(modifiers -> !modifiers.contains((Object)ElementModifier.STATIC) && !modifiers.contains((Object)ElementModifier.PROTECTED)) : ElementQuery.of(FieldElement.class).modifiers(modifiers -> !modifiers.contains((Object)ElementModifier.STATIC) && visibilitySet.stream().anyMatch(v -> modifiers.contains((Object)ElementModifier.valueOf(v.name()))));
                if (nameFilter != null) {
                    query = query.named(nameFilter);
                }
                beanFields = ce.getEnclosedElements(query);
            } else {
                beanFields = Collections.emptyList();
            }
            if (!beanFields.isEmpty() && !beanProperties.isEmpty()) {
                beanProperties = beanProperties.stream().filter(pe -> beanFields.stream().noneMatch(fieldElement -> fieldElement.getName().equals(pe.getName()))).collect(Collectors.toList());
            }
            MethodElement constructor = constructorElement.orElse(null);
            this.process(constructor, ce.getDefaultConstructor().orElse(null), writer, beanProperties, includes, excludes, excludedAnnotations, indexedAnnotations, metadata, new Introspected.AccessKind[0]);
            for (FieldElement fieldElement : beanFields) {
                writer.visitBeanField(fieldElement);
            }
            query = ElementQuery.of(MethodElement.class).onlyAccessible().modifiers(modifiers -> !modifiers.contains((Object)ElementModifier.STATIC)).annotated(am -> am.hasStereotype(Executable.class));
            List<MethodElement> list2 = ce.getEnclosedElements(query);
            for (MethodElement executableMethod : list2) {
                writer.visitBeanMethod(executableMethod);
            }
        }
    }

    private void process(@Nullable MethodElement constructorElement, @Nullable MethodElement defaultConstructor, BeanIntrospectionWriter writer, List<PropertyElement> beanProperties, Set<String> includes, Set<String> excludes, Set<String> ignored, Set<AnnotationValue> indexedAnnotations, boolean metadata, Introspected.AccessKind ... accessKind) {
        Object[] parameters;
        if (constructorElement != null && ArrayUtils.isNotEmpty((Object[])(parameters = constructorElement.getParameters()))) {
            writer.visitConstructor(constructorElement);
        }
        if (defaultConstructor != null) {
            writer.visitDefaultConstructor(defaultConstructor);
        }
        this.processBeanProperties(writer, beanProperties, includes, excludes, ignored, indexedAnnotations, metadata);
        this.writers.put(writer.getBeanType().getClassName(), writer);
    }

    private void processBeanProperties(BeanIntrospectionWriter writer, Collection<? extends PropertyElement> beanProperties, Set<String> includes, Set<String> excludes, Set<String> ignored, Set<AnnotationValue> indexedAnnotations, boolean metadata) {
        for (PropertyElement propertyElement : beanProperties) {
            ClassElement type = propertyElement.getType();
            ClassElement genericType = propertyElement.getGenericType();
            String name = propertyElement.getName();
            if (!includes.isEmpty() && !includes.contains(name) || !excludes.isEmpty() && excludes.contains(name)) continue;
            if (!ignored.isEmpty()) {
                if (ignored.stream().anyMatch(arg_0 -> ((PropertyElement)propertyElement).hasAnnotation(arg_0))) continue;
            }
            writer.visitProperty(type, genericType, name, propertyElement.getReadMethod().orElse(null), propertyElement.getWriteMethod().orElse(null), propertyElement.isReadOnly(), metadata ? propertyElement.getAnnotationMetadata() : null, genericType.getTypeArguments());
            for (AnnotationValue indexedAnnotation : indexedAnnotations) {
                indexedAnnotation.get((CharSequence)"annotation", String.class).ifPresent(annotationName -> {
                    if (beanProperty.hasStereotype((String)annotationName)) {
                        writer.indexProperty((String)annotationName, name, indexedAnnotation.get((CharSequence)"member", String.class).flatMap(m -> beanProperty.getValue((String)annotationName, (String)m, String.class)).orElse(null));
                    }
                });
            }
        }
    }

    private /* synthetic */ void lambda$processIntrospected$3(VisitorContext context, ClassElement element, AtomicInteger index, boolean metadata, Set includes, Set excludes, Set excludedAnnotations, Set indexedAnnotations, Introspected.Visibility[] finalVisibilities, Introspected.AccessKind[] finalAccessKinds, ClassElement ce) {
        if (ce.isPublic() && !this.isIntrospected(context, ce)) {
            AnnotationMetadata typeMetadata = ce.getAnnotationMetadata();
            AnnotationMetadata resolvedMetadata = typeMetadata == AnnotationMetadata.EMPTY_METADATA ? element.getAnnotationMetadata() : new AnnotationMetadataHierarchy(element.getAnnotationMetadata(), typeMetadata);
            BeanIntrospectionWriter writer = new BeanIntrospectionWriter(element.getName(), index.getAndIncrement(), element, ce, (AnnotationMetadata)(metadata ? resolvedMetadata : null));
            this.processElement(metadata, includes, excludes, excludedAnnotations, indexedAnnotations, ce, writer, finalVisibilities, finalAccessKinds);
        }
    }

    private class AbstractPropertyElement
    implements PropertyElement {
        private final ClassElement declaringType;
        private final ClassElement type;
        private final String name;
        private MethodElement writeMethod;
        private MethodElement readMethod;

        AbstractPropertyElement(ClassElement declaringType, ClassElement type, String name) {
            this.declaringType = declaringType;
            this.type = type;
            this.name = name;
        }

        @Override
        public Optional<MethodElement> getWriteMethod() {
            return Optional.ofNullable(this.writeMethod);
        }

        @Override
        public Optional<MethodElement> getReadMethod() {
            return Optional.ofNullable(this.readMethod);
        }

        @Override
        @NonNull
        public ClassElement getType() {
            return this.type;
        }

        @Override
        public ClassElement getDeclaringType() {
            return this.declaringType;
        }

        @Override
        @NonNull
        public String getName() {
            return this.name;
        }

        @Override
        public boolean isProtected() {
            return false;
        }

        @Override
        public boolean isPublic() {
            return true;
        }

        @Override
        @NonNull
        public Object getNativeType() {
            throw null;
        }
    }

    private class AbstractIntrospection {
        final BeanIntrospectionWriter writer;
        final Set<String> includes;
        final Set<String> excludes;
        final Set<String> ignored;
        final Set<AnnotationValue> indexedAnnotations;
        final boolean metadata;
        final Map<String, AbstractPropertyElement> properties = new LinkedHashMap<String, AbstractPropertyElement>();

        public AbstractIntrospection(BeanIntrospectionWriter writer, Set<String> includes, Set<String> excludes, Set<String> ignored, Set<AnnotationValue> indexedAnnotations, boolean metadata) {
            this.writer = writer;
            this.includes = includes;
            this.excludes = excludes;
            this.ignored = ignored;
            this.indexedAnnotations = indexedAnnotations;
            this.metadata = metadata;
        }
    }
}

