/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.compiler.dependencies;

import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;

public final class Dependency {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final List<Exclusion> exclusions;

    public Dependency(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, Collections.emptyList());
    }

    public Dependency(String groupId, String artifactId, String version, List<Exclusion> exclusions) {
        Assert.notNull((Object)groupId, (String)"GroupId must not be null");
        Assert.notNull((Object)artifactId, (String)"ArtifactId must not be null");
        Assert.notNull((Object)version, (String)"Version must not be null");
        Assert.notNull(exclusions, (String)"Exclusions must not be null");
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.exclusions = Collections.unmodifiableList(exclusions);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public List<Exclusion> getExclusions() {
        return this.exclusions;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() == obj.getClass()) {
            Dependency other = (Dependency)obj;
            boolean result = true;
            result = result && this.groupId.equals(other.groupId);
            result = result && this.artifactId.equals(other.artifactId);
            result = result && this.version.equals(other.version);
            result = result && this.exclusions.equals(other.exclusions);
            return result;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.groupId.hashCode();
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.exclusions.hashCode();
        return result;
    }

    public String toString() {
        return this.groupId + ":" + this.artifactId + ":" + this.version;
    }

    public static final class Exclusion {
        private final String groupId;
        private final String artifactId;

        Exclusion(String groupId, String artifactId) {
            Assert.notNull((Object)groupId, (String)"GroupId must not be null");
            Assert.notNull((Object)artifactId, (String)"ArtifactId must not be null");
            this.groupId = groupId;
            this.artifactId = artifactId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                Exclusion other = (Exclusion)obj;
                boolean result = true;
                result = result && this.groupId.equals(other.groupId);
                result = result && this.artifactId.equals(other.artifactId);
                return result;
            }
            return false;
        }

        public int hashCode() {
            return this.groupId.hashCode() * 31 + this.artifactId.hashCode();
        }

        public String toString() {
            return this.groupId + ":" + this.artifactId;
        }
    }
}

