/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.connector.basic;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import org.eclipse.aether.connector.basic.ChecksumCalculator;
import org.eclipse.aether.spi.connector.checksum.ChecksumAlgorithmFactory;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import org.eclipse.aether.spi.connector.layout.RepositoryLayout;
import org.eclipse.aether.spi.io.FileProcessor;
import org.eclipse.aether.transfer.ChecksumFailureException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ChecksumValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChecksumValidator.class);
    private final File dataFile;
    private final Collection<ChecksumAlgorithmFactory> checksumAlgorithmFactories;
    private final Collection<File> tempFiles;
    private final FileProcessor fileProcessor;
    private final ChecksumFetcher checksumFetcher;
    private final ChecksumPolicy checksumPolicy;
    private final Map<String, String> providedChecksums;
    private final Collection<RepositoryLayout.ChecksumLocation> checksumLocations;
    private final Map<File, Object> checksumFiles;

    ChecksumValidator(File dataFile, Collection<ChecksumAlgorithmFactory> checksumAlgorithmFactories, FileProcessor fileProcessor, ChecksumFetcher checksumFetcher, ChecksumPolicy checksumPolicy, Map<String, String> providedChecksums, Collection<RepositoryLayout.ChecksumLocation> checksumLocations) {
        this.dataFile = dataFile;
        this.checksumAlgorithmFactories = checksumAlgorithmFactories;
        this.tempFiles = new HashSet<File>();
        this.fileProcessor = fileProcessor;
        this.checksumFetcher = checksumFetcher;
        this.checksumPolicy = checksumPolicy;
        this.providedChecksums = providedChecksums;
        this.checksumLocations = checksumLocations;
        this.checksumFiles = new HashMap<File, Object>();
    }

    public ChecksumCalculator newChecksumCalculator(File targetFile) {
        if (this.checksumPolicy != null) {
            return ChecksumCalculator.newInstance(targetFile, this.checksumAlgorithmFactories);
        }
        return null;
    }

    public void validate(Map<String, ?> actualChecksums, Map<String, ?> includedChecksums) throws ChecksumFailureException {
        if (this.checksumPolicy == null) {
            return;
        }
        if (this.providedChecksums != null && this.validateChecksums(actualChecksums, ChecksumPolicy.ChecksumKind.PROVIDED, this.providedChecksums)) {
            return;
        }
        if (includedChecksums != null && this.validateChecksums(actualChecksums, ChecksumPolicy.ChecksumKind.REMOTE_INCLUDED, includedChecksums)) {
            return;
        }
        if (!this.checksumLocations.isEmpty()) {
            if (this.validateExternalChecksums(actualChecksums)) {
                return;
            }
            this.checksumPolicy.onNoMoreChecksums();
        }
    }

    private boolean validateChecksums(Map<String, ?> actualChecksums, ChecksumPolicy.ChecksumKind kind, Map<String, ?> checksums) throws ChecksumFailureException {
        for (Map.Entry<String, ?> entry : checksums.entrySet()) {
            ChecksumAlgorithmFactory checksumAlgorithmFactory;
            String algo = entry.getKey();
            Object calculated = actualChecksums.get(algo);
            if (!(calculated instanceof String) || (checksumAlgorithmFactory = (ChecksumAlgorithmFactory)this.checksumAlgorithmFactories.stream().filter(a -> a.getName().equals(algo)).findFirst().orElse(null)) == null) continue;
            String actual = String.valueOf(calculated);
            String expected = entry.getValue().toString();
            this.checksumFiles.put(this.getChecksumFile(checksumAlgorithmFactory), expected);
            if (!ChecksumValidator.isEqualChecksum(expected, actual)) {
                this.checksumPolicy.onChecksumMismatch(checksumAlgorithmFactory.getName(), kind, new ChecksumFailureException(expected, kind.name(), actual));
                continue;
            }
            if (!this.checksumPolicy.onChecksumMatch(checksumAlgorithmFactory.getName(), kind)) continue;
            return true;
        }
        return false;
    }

    private boolean validateExternalChecksums(Map<String, ?> actualChecksums) throws ChecksumFailureException {
        for (RepositoryLayout.ChecksumLocation checksumLocation : this.checksumLocations) {
            ChecksumAlgorithmFactory factory = checksumLocation.getChecksumAlgorithmFactory();
            Object calculated = actualChecksums.get(factory.getName());
            if (calculated instanceof Exception) {
                this.checksumPolicy.onChecksumError(factory.getName(), ChecksumPolicy.ChecksumKind.REMOTE_EXTERNAL, new ChecksumFailureException((Throwable)((Exception)calculated)));
                continue;
            }
            try {
                File tmp;
                File checksumFile;
                block8: {
                    checksumFile = this.getChecksumFile(checksumLocation.getChecksumAlgorithmFactory());
                    tmp = this.createTempFile(checksumFile);
                    try {
                        if (!this.checksumFetcher.fetchChecksum(checksumLocation.getLocation(), tmp)) {
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        this.checksumPolicy.onChecksumError(factory.getName(), ChecksumPolicy.ChecksumKind.REMOTE_EXTERNAL, new ChecksumFailureException((Throwable)e));
                    }
                    continue;
                }
                String actual = String.valueOf(calculated);
                String expected = this.fileProcessor.readChecksum(tmp);
                this.checksumFiles.put(checksumFile, tmp);
                if (!ChecksumValidator.isEqualChecksum(expected, actual)) {
                    this.checksumPolicy.onChecksumMismatch(factory.getName(), ChecksumPolicy.ChecksumKind.REMOTE_EXTERNAL, new ChecksumFailureException(expected, ChecksumPolicy.ChecksumKind.REMOTE_EXTERNAL.name(), actual));
                    continue;
                }
                if (!this.checksumPolicy.onChecksumMatch(factory.getName(), ChecksumPolicy.ChecksumKind.REMOTE_EXTERNAL)) continue;
                return true;
            }
            catch (IOException e) {
                this.checksumPolicy.onChecksumError(factory.getName(), ChecksumPolicy.ChecksumKind.REMOTE_EXTERNAL, new ChecksumFailureException((Throwable)e));
            }
        }
        return false;
    }

    private static boolean isEqualChecksum(String expected, String actual) {
        return expected.equalsIgnoreCase(actual);
    }

    private File getChecksumFile(ChecksumAlgorithmFactory factory) {
        return new File(this.dataFile.getPath() + '.' + factory.getFileExtension());
    }

    private File createTempFile(File path) throws IOException {
        File file = File.createTempFile(path.getName() + "-" + UUID.randomUUID().toString().replace("-", "").substring(0, 8), ".tmp", path.getParentFile());
        this.tempFiles.add(file);
        return file;
    }

    private void clearTempFiles() {
        for (File file : this.tempFiles) {
            if (file.delete() || !file.exists()) continue;
            LOGGER.debug("Could not delete temporary file {}", (Object)file);
        }
        this.tempFiles.clear();
    }

    public void retry() {
        this.checksumPolicy.onTransferRetry();
        this.checksumFiles.clear();
        this.clearTempFiles();
    }

    public boolean handle(ChecksumFailureException exception) {
        return this.checksumPolicy.onTransferChecksumFailure(exception);
    }

    public void commit() {
        for (Map.Entry<File, Object> entry : this.checksumFiles.entrySet()) {
            File checksumFile = entry.getKey();
            Object tmp = entry.getValue();
            try {
                if (tmp instanceof File) {
                    this.fileProcessor.move((File)tmp, checksumFile);
                    this.tempFiles.remove(tmp);
                    continue;
                }
                this.fileProcessor.writeChecksum(checksumFile, String.valueOf(tmp));
            }
            catch (IOException e) {
                LOGGER.debug("Failed to write checksum file {}", (Object)checksumFile, (Object)e);
            }
        }
        this.checksumFiles.clear();
    }

    public void close() {
        this.clearTempFiles();
    }

    static interface ChecksumFetcher {
        public boolean fetchChecksum(URI var1, File var2) throws Exception;
    }
}

