/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.contracts.generation;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.SourceUnit;

public final class AssertStatementCreationUtility {
    public static BlockStatement getAssertionStatements(List<BooleanExpression> booleanExpressions) {
        ArrayList<AssertStatement> assertStatements = new ArrayList<AssertStatement>();
        for (BooleanExpression booleanExpression : booleanExpressions) {
            assertStatements.add(AssertStatementCreationUtility.getAssertionStatement(booleanExpression));
        }
        BlockStatement blockStatement = GeneralUtils.block((Statement[])new Statement[0]);
        blockStatement.getStatements().addAll(assertStatements);
        return blockStatement;
    }

    public static AssertStatement getAssertionStatement(BooleanExpression booleanExpression) {
        AssertStatement assertStatement = new AssertStatement(booleanExpression);
        assertStatement.setStatementLabel((String)booleanExpression.getNodeMetaData((Object)"statementLabel"));
        assertStatement.setSourcePosition((ASTNode)booleanExpression);
        return assertStatement;
    }

    public static List<ReturnStatement> getReturnStatements(MethodNode method) {
        Statement lastStatement;
        int statementCount;
        ReturnStatementVisitor returnStatementVisitor = new ReturnStatementVisitor();
        returnStatementVisitor.visitMethod(method);
        List<ReturnStatement> returnStatements = returnStatementVisitor.getReturnStatements();
        BlockStatement blockStatement = (BlockStatement)method.getCode();
        if (returnStatements.isEmpty() && (statementCount = blockStatement.getStatements().size()) > 0 && (lastStatement = (Statement)blockStatement.getStatements().get(statementCount - 1)) instanceof ExpressionStatement) {
            ReturnStatement returnStatement = new ReturnStatement((ExpressionStatement)lastStatement);
            returnStatement.setSourcePosition((ASTNode)lastStatement);
            blockStatement.getStatements().remove(lastStatement);
            blockStatement.addStatement((Statement)returnStatement);
            returnStatements.add(returnStatement);
        }
        return returnStatements;
    }

    public static void injectResultVariableReturnStatementAndAssertionCallStatement(BlockStatement statement, ClassNode returnType, ReturnStatement returnStatement, BlockStatement assertionCallStatement) {
        AddResultReturnStatementVisitor addResultReturnStatementVisitor = new AddResultReturnStatementVisitor(returnStatement, returnType, assertionCallStatement);
        addResultReturnStatementVisitor.visitBlockStatement(statement);
    }

    public static void addAssertionCallStatementToReturnStatement(BlockStatement statement, ReturnStatement returnStatement, Statement assertionCallStatement) {
        AddAssertionCallStatementToReturnStatementVisitor addAssertionCallStatementToReturnStatementVisitor = new AddAssertionCallStatementToReturnStatementVisitor(returnStatement, assertionCallStatement);
        addAssertionCallStatementToReturnStatementVisitor.visitBlockStatement(statement);
    }

    public static class ReturnStatementVisitor
    extends ClassCodeVisitorSupport {
        private final List<ReturnStatement> returnStatements = new ArrayList<ReturnStatement>();

        protected SourceUnit getSourceUnit() {
            return null;
        }

        public void visitReturnStatement(ReturnStatement statement) {
            this.returnStatements.add(statement);
        }

        public void visitClosureExpression(ClosureExpression expression) {
        }

        public List<ReturnStatement> getReturnStatements() {
            return this.returnStatements;
        }
    }

    public static class AddResultReturnStatementVisitor
    extends ClassCodeVisitorSupport {
        private final ReturnStatement returnStatement;
        private final ClassNode returnType;
        private final BlockStatement assertionCallBlock;

        protected SourceUnit getSourceUnit() {
            return null;
        }

        public AddResultReturnStatementVisitor(ReturnStatement returnStatement, ClassNode returnType, BlockStatement assertionCallBlock) {
            this.returnStatement = returnStatement;
            this.returnType = returnType;
            this.assertionCallBlock = assertionCallBlock;
        }

        public void visitBlockStatement(BlockStatement block) {
            ArrayList blockStatementsCopy = new ArrayList(block.getStatements());
            for (Statement statement : blockStatementsCopy) {
                if (statement != this.returnStatement) continue;
                block.getStatements().remove(statement);
                block.addStatements(this.assertionCallBlock.getStatements());
                VariableExpression variableExpression = GeneralUtils.localVarX((String)"result", (ClassNode)this.returnType);
                block.addStatement(GeneralUtils.returnS((Expression)variableExpression));
                return;
            }
            super.visitBlockStatement(block);
        }
    }

    public static class AddAssertionCallStatementToReturnStatementVisitor
    extends ClassCodeVisitorSupport {
        private final ReturnStatement returnStatement;
        private final Statement assertionCallStatement;

        protected SourceUnit getSourceUnit() {
            return null;
        }

        public AddAssertionCallStatementToReturnStatementVisitor(ReturnStatement returnStatement, Statement assertionCallStatement) {
            this.returnStatement = returnStatement;
            this.assertionCallStatement = assertionCallStatement;
        }

        public void visitBlockStatement(BlockStatement block) {
            ArrayList blockStatementsCopy = new ArrayList(block.getStatements());
            for (Statement statement : blockStatementsCopy) {
                if (statement != this.returnStatement) continue;
                block.getStatements().remove(statement);
                VariableExpression gcResult = GeneralUtils.localVarX((String)"$_gc_result", (ClassNode)ClassHelper.OBJECT_TYPE);
                block.addStatement(GeneralUtils.declS((Expression)gcResult, (Expression)this.returnStatement.getExpression()));
                block.addStatement(this.assertionCallStatement);
                Statement gcResultReturn = GeneralUtils.returnS((Expression)gcResult);
                gcResultReturn.setSourcePosition((ASTNode)this.returnStatement);
                block.addStatement(gcResultReturn);
                return;
            }
            super.visitBlockStatement(block);
        }
    }
}

