/* soapC.cpp
   Generated by gSOAP 2.8.48 for calculator.h

gSOAP XML Web services tools
Copyright (C) 2000-2017, Robert van Engelen, Genivia Inc. All Rights Reserved.
The soapcpp2 tool and its generated software are released under the GPL.
This program is released under the GPL with the additional exemption that
compiling, linking, and/or using OpenSSL is allowed.
--------------------------------------------------------------------------------
A commercial use license is available from Genivia Inc., contact@genivia.com
--------------------------------------------------------------------------------
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "soapH.h"

SOAP_SOURCE_STAMP("@(#) soapC.cpp ver 2.8.48 2017-07-01 18:36:59 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", soap->header, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->version && soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, ""))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->version && soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (soap->header == NULL)
	{	if ((soap->header = soap_new_SOAP_ENV__Header(soap)))
			soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (soap->fault == NULL)
	{	soap->fault = soap_new_SOAP_ENV__Fault(soap);
		if (soap->fault == NULL)
			return;
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = soap_new_SOAP_ENV__Code(soap);
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = soap_new_SOAP_ENV__Reason(soap);
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	soap_fault(soap);
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", "");
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Code)
		return (const char**)(void*)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)(void*)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode == NULL)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = soap_new_SOAP_ENV__Code(soap);
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)(void*)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)(void*)&soap->fault->faultcode;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (soap->fault->SOAP_ENV__Code && soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
			return soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
		return NULL;
	}
	return soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)(void*)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)(void*)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (soap->fault->SOAP_ENV__Detail == NULL)
		{	soap->fault->SOAP_ENV__Detail = soap_new_SOAP_ENV__Detail(soap);
			soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
		}
		return (const char**)(void*)&soap->fault->SOAP_ENV__Detail->__any;
	}
	if (soap->fault->detail == NULL)
	{	soap->fault->detail = soap_new_SOAP_ENV__Detail(soap);
		soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
	}
	return (const char**)(void*)&soap->fault->detail->__any;
}

SOAP_FMAC3 const char * SOAP_FMAC4 soap_check_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2 && soap->fault->SOAP_ENV__Detail)
		return soap->fault->SOAP_ENV__Detail->__any;
	if (soap->fault->detail)
		return soap->fault->detail->__any;
	return NULL;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	if (soap->version == 1)
	{	for (;;)
		{	if (!soap_getelement(soap, &t))
				if ((soap->error && soap->error != SOAP_TAG_MISMATCH) || soap_ignore_element(soap))
					break;
		}
	}
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{	(void)type;
	if (soap_peek_element(soap))
		return NULL;
#ifndef WITH_NOIDREF
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_double:
		return soap_in_double(soap, NULL, NULL, "xsd:double");
	case SOAP_TYPE_PointerTo_mssamt__DivideResponse:
		return soap_in_PointerTo_mssamt__DivideResponse(soap, NULL, NULL, "mssamt:DivideResponse");
	case SOAP_TYPE_PointerTo_mssamt__Divide:
		return soap_in_PointerTo_mssamt__Divide(soap, NULL, NULL, "mssamt:Divide");
	case SOAP_TYPE_PointerTo_mssamt__MultiplyResponse:
		return soap_in_PointerTo_mssamt__MultiplyResponse(soap, NULL, NULL, "mssamt:MultiplyResponse");
	case SOAP_TYPE_PointerTo_mssamt__Multiply:
		return soap_in_PointerTo_mssamt__Multiply(soap, NULL, NULL, "mssamt:Multiply");
	case SOAP_TYPE_PointerTo_mssamt__SubtractResponse:
		return soap_in_PointerTo_mssamt__SubtractResponse(soap, NULL, NULL, "mssamt:SubtractResponse");
	case SOAP_TYPE_PointerTo_mssamt__Subtract:
		return soap_in_PointerTo_mssamt__Subtract(soap, NULL, NULL, "mssamt:Subtract");
	case SOAP_TYPE_PointerTo_mssamt__AddResponse:
		return soap_in_PointerTo_mssamt__AddResponse(soap, NULL, NULL, "mssamt:AddResponse");
	case SOAP_TYPE_PointerTo_mssamt__Add:
		return soap_in_PointerTo_mssamt__Add(soap, NULL, NULL, "mssamt:Add");
	case SOAP_TYPE_PointerTodouble:
		return soap_in_PointerTodouble(soap, NULL, NULL, "xsd:double");
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
#else
	*type = 0;
#endif
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:double"))
		{	*type = SOAP_TYPE_double;
			return soap_in_double(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "mssamt:DivideResponse"))
		{	*type = SOAP_TYPE__mssamt__DivideResponse;
			return soap_in__mssamt__DivideResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamt:Divide"))
		{	*type = SOAP_TYPE__mssamt__Divide;
			return soap_in__mssamt__Divide(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamt:MultiplyResponse"))
		{	*type = SOAP_TYPE__mssamt__MultiplyResponse;
			return soap_in__mssamt__MultiplyResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamt:Multiply"))
		{	*type = SOAP_TYPE__mssamt__Multiply;
			return soap_in__mssamt__Multiply(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamt:SubtractResponse"))
		{	*type = SOAP_TYPE__mssamt__SubtractResponse;
			return soap_in__mssamt__SubtractResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamt:Subtract"))
		{	*type = SOAP_TYPE__mssamt__Subtract;
			return soap_in__mssamt__Subtract(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamt:AddResponse"))
		{	*type = SOAP_TYPE__mssamt__AddResponse;
			return soap_in__mssamt__AddResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "mssamt:Add"))
		{	*type = SOAP_TYPE__mssamt__Add;
			return soap_in__mssamt__Add(soap, NULL, NULL, NULL);
		}
#ifndef WITH_NOIDREF
	}
#endif
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

#ifdef __cplusplus
}
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level = %u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other && !soap->fignore)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				if (soap_ignore(soap) || soap_element_end_in(soap, NULL))
					return soap->error;
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, SOAP_MULTIREFTAG, pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{	(void)tag;
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_double:
		return soap_out_double(soap, tag, id, (const double *)ptr, "xsd:double");
	case SOAP_TYPE__mssamt__DivideResponse:
		return ((_mssamt__DivideResponse *)ptr)->soap_out(soap, "mssamt:DivideResponse", id, "");
	case SOAP_TYPE__mssamt__Divide:
		return ((_mssamt__Divide *)ptr)->soap_out(soap, "mssamt:Divide", id, "");
	case SOAP_TYPE__mssamt__MultiplyResponse:
		return ((_mssamt__MultiplyResponse *)ptr)->soap_out(soap, "mssamt:MultiplyResponse", id, "");
	case SOAP_TYPE__mssamt__Multiply:
		return ((_mssamt__Multiply *)ptr)->soap_out(soap, "mssamt:Multiply", id, "");
	case SOAP_TYPE__mssamt__SubtractResponse:
		return ((_mssamt__SubtractResponse *)ptr)->soap_out(soap, "mssamt:SubtractResponse", id, "");
	case SOAP_TYPE__mssamt__Subtract:
		return ((_mssamt__Subtract *)ptr)->soap_out(soap, "mssamt:Subtract", id, "");
	case SOAP_TYPE__mssamt__AddResponse:
		return ((_mssamt__AddResponse *)ptr)->soap_out(soap, "mssamt:AddResponse", id, "");
	case SOAP_TYPE__mssamt__Add:
		return ((_mssamt__Add *)ptr)->soap_out(soap, "mssamt:Add", id, "");
	case SOAP_TYPE_PointerTo_mssamt__DivideResponse:
		return soap_out_PointerTo_mssamt__DivideResponse(soap, tag, id, (_mssamt__DivideResponse *const*)ptr, "mssamt:DivideResponse");
	case SOAP_TYPE_PointerTo_mssamt__Divide:
		return soap_out_PointerTo_mssamt__Divide(soap, tag, id, (_mssamt__Divide *const*)ptr, "mssamt:Divide");
	case SOAP_TYPE_PointerTo_mssamt__MultiplyResponse:
		return soap_out_PointerTo_mssamt__MultiplyResponse(soap, tag, id, (_mssamt__MultiplyResponse *const*)ptr, "mssamt:MultiplyResponse");
	case SOAP_TYPE_PointerTo_mssamt__Multiply:
		return soap_out_PointerTo_mssamt__Multiply(soap, tag, id, (_mssamt__Multiply *const*)ptr, "mssamt:Multiply");
	case SOAP_TYPE_PointerTo_mssamt__SubtractResponse:
		return soap_out_PointerTo_mssamt__SubtractResponse(soap, tag, id, (_mssamt__SubtractResponse *const*)ptr, "mssamt:SubtractResponse");
	case SOAP_TYPE_PointerTo_mssamt__Subtract:
		return soap_out_PointerTo_mssamt__Subtract(soap, tag, id, (_mssamt__Subtract *const*)ptr, "mssamt:Subtract");
	case SOAP_TYPE_PointerTo_mssamt__AddResponse:
		return soap_out_PointerTo_mssamt__AddResponse(soap, tag, id, (_mssamt__AddResponse *const*)ptr, "mssamt:AddResponse");
	case SOAP_TYPE_PointerTo_mssamt__Add:
		return soap_out_PointerTo_mssamt__Add(soap, tag, id, (_mssamt__Add *const*)ptr, "mssamt:Add");
	case SOAP_TYPE_PointerTodouble:
		return soap_out_PointerTodouble(soap, tag, id, (double *const*)ptr, "xsd:double");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, tag, id, (char*const*)(void*)&ptr, "xsd:QName");
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)(void*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}
#ifdef __cplusplus
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE__mssamt__DivideResponse:
		((_mssamt__DivideResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamt__Divide:
		((_mssamt__Divide *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamt__MultiplyResponse:
		((_mssamt__MultiplyResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamt__Multiply:
		((_mssamt__Multiply *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamt__SubtractResponse:
		((_mssamt__SubtractResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamt__Subtract:
		((_mssamt__Subtract *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamt__AddResponse:
		((_mssamt__AddResponse *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__mssamt__Add:
		((_mssamt__Add *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE___tempuri__Divide:
		soap_serialize___tempuri__Divide(soap, (const struct __tempuri__Divide *)ptr);
		break;
	case SOAP_TYPE___tempuri__Multiply:
		soap_serialize___tempuri__Multiply(soap, (const struct __tempuri__Multiply *)ptr);
		break;
	case SOAP_TYPE___tempuri__Subtract:
		soap_serialize___tempuri__Subtract(soap, (const struct __tempuri__Subtract *)ptr);
		break;
	case SOAP_TYPE___tempuri__Add:
		soap_serialize___tempuri__Add(soap, (const struct __tempuri__Add *)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamt__DivideResponse:
		soap_serialize_PointerTo_mssamt__DivideResponse(soap, (_mssamt__DivideResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamt__Divide:
		soap_serialize_PointerTo_mssamt__Divide(soap, (_mssamt__Divide *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamt__MultiplyResponse:
		soap_serialize_PointerTo_mssamt__MultiplyResponse(soap, (_mssamt__MultiplyResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamt__Multiply:
		soap_serialize_PointerTo_mssamt__Multiply(soap, (_mssamt__Multiply *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamt__SubtractResponse:
		soap_serialize_PointerTo_mssamt__SubtractResponse(soap, (_mssamt__SubtractResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamt__Subtract:
		soap_serialize_PointerTo_mssamt__Subtract(soap, (_mssamt__Subtract *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamt__AddResponse:
		soap_serialize_PointerTo_mssamt__AddResponse(soap, (_mssamt__AddResponse *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_mssamt__Add:
		soap_serialize_PointerTo_mssamt__Add(soap, (_mssamt__Add *const*)ptr);
		break;
	case SOAP_TYPE_PointerTodouble:
		soap_serialize_PointerTodouble(soap, (double *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)(void*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)(void*)&ptr);
		break;
	}
}
#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{	(void)type;
	switch (t)
	{
	case SOAP_TYPE__mssamt__Add:
		return (void*)soap_instantiate__mssamt__Add(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamt__AddResponse:
		return (void*)soap_instantiate__mssamt__AddResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamt__Subtract:
		return (void*)soap_instantiate__mssamt__Subtract(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamt__SubtractResponse:
		return (void*)soap_instantiate__mssamt__SubtractResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamt__Multiply:
		return (void*)soap_instantiate__mssamt__Multiply(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamt__MultiplyResponse:
		return (void*)soap_instantiate__mssamt__MultiplyResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamt__Divide:
		return (void*)soap_instantiate__mssamt__Divide(soap, -1, type, arrayType, n);
	case SOAP_TYPE__mssamt__DivideResponse:
		return (void*)soap_instantiate__mssamt__DivideResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__Add:
		return (void*)soap_instantiate___tempuri__Add(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__Subtract:
		return (void*)soap_instantiate___tempuri__Subtract(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__Multiply:
		return (void*)soap_instantiate___tempuri__Multiply(soap, -1, type, arrayType, n);
	case SOAP_TYPE___tempuri__Divide:
		return (void*)soap_instantiate___tempuri__Divide(soap, -1, type, arrayType, n);
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		return (void*)soap_instantiate_SOAP_ENV__Header(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		return (void*)soap_instantiate_SOAP_ENV__Code(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		return (void*)soap_instantiate_SOAP_ENV__Detail(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		return (void*)soap_instantiate_SOAP_ENV__Reason(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		return (void*)soap_instantiate_SOAP_ENV__Fault(soap, -1, type, arrayType, n);
#endif
	}
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE__mssamt__Add:
		if (p->size < 0)
			SOAP_DELETE(static_cast<_mssamt__Add*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<_mssamt__Add*>(p->ptr));
		break;
	case SOAP_TYPE__mssamt__AddResponse:
		if (p->size < 0)
			SOAP_DELETE(static_cast<_mssamt__AddResponse*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<_mssamt__AddResponse*>(p->ptr));
		break;
	case SOAP_TYPE__mssamt__Subtract:
		if (p->size < 0)
			SOAP_DELETE(static_cast<_mssamt__Subtract*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<_mssamt__Subtract*>(p->ptr));
		break;
	case SOAP_TYPE__mssamt__SubtractResponse:
		if (p->size < 0)
			SOAP_DELETE(static_cast<_mssamt__SubtractResponse*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<_mssamt__SubtractResponse*>(p->ptr));
		break;
	case SOAP_TYPE__mssamt__Multiply:
		if (p->size < 0)
			SOAP_DELETE(static_cast<_mssamt__Multiply*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<_mssamt__Multiply*>(p->ptr));
		break;
	case SOAP_TYPE__mssamt__MultiplyResponse:
		if (p->size < 0)
			SOAP_DELETE(static_cast<_mssamt__MultiplyResponse*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<_mssamt__MultiplyResponse*>(p->ptr));
		break;
	case SOAP_TYPE__mssamt__Divide:
		if (p->size < 0)
			SOAP_DELETE(static_cast<_mssamt__Divide*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<_mssamt__Divide*>(p->ptr));
		break;
	case SOAP_TYPE__mssamt__DivideResponse:
		if (p->size < 0)
			SOAP_DELETE(static_cast<_mssamt__DivideResponse*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<_mssamt__DivideResponse*>(p->ptr));
		break;
	case SOAP_TYPE___tempuri__Add:
		if (p->size < 0)
			SOAP_DELETE(static_cast<struct __tempuri__Add*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<struct __tempuri__Add*>(p->ptr));
		break;
	case SOAP_TYPE___tempuri__Subtract:
		if (p->size < 0)
			SOAP_DELETE(static_cast<struct __tempuri__Subtract*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<struct __tempuri__Subtract*>(p->ptr));
		break;
	case SOAP_TYPE___tempuri__Multiply:
		if (p->size < 0)
			SOAP_DELETE(static_cast<struct __tempuri__Multiply*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<struct __tempuri__Multiply*>(p->ptr));
		break;
	case SOAP_TYPE___tempuri__Divide:
		if (p->size < 0)
			SOAP_DELETE(static_cast<struct __tempuri__Divide*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<struct __tempuri__Divide*>(p->ptr));
		break;
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			SOAP_DELETE(static_cast<struct SOAP_ENV__Header*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<struct SOAP_ENV__Header*>(p->ptr));
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			SOAP_DELETE(static_cast<struct SOAP_ENV__Code*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<struct SOAP_ENV__Code*>(p->ptr));
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			SOAP_DELETE(static_cast<struct SOAP_ENV__Detail*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<struct SOAP_ENV__Detail*>(p->ptr));
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			SOAP_DELETE(static_cast<struct SOAP_ENV__Reason*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<struct SOAP_ENV__Reason*>(p->ptr));
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			SOAP_DELETE(static_cast<struct SOAP_ENV__Fault*>(p->ptr));
		else
			SOAP_DELETE_ARRAY(static_cast<struct SOAP_ENV__Fault*>(p->ptr));
		break;
#endif
	default:
		return SOAP_ERR;
	}
	return SOAP_OK;
}

#ifdef WIN32
#pragma warning(push)
// do not warn on switch w/o cases
#pragma warning(disable:4065)
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_fbase(int t, int b)
{
	do
	{	switch (t)
		{
		default: return 0;
		}
	}
	while (t != b);
	return 1;
}
#ifdef WIN32
#pragma warning(pop)
#endif

#ifndef WITH_NOIDREF
#ifdef WIN32
#pragma warning(push)
// do not warn on switch w/o cases
#pragma warning(disable:4065)
#endif
SOAP_FMAC3 void SOAP_FMAC4 soap_finsert(struct soap *soap, int t, int tt, void *p, size_t index, const void *q, void **x)
{
	(void)soap; (void)t; (void)p; (void)index; (void)q; (void)x; /* appease -Wall -Werror */
	switch (tt)
	{
	case SOAP_TYPE__mssamt__Add:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy _mssamt__Add type=%d location=%p object=%p\n", t, p, q));
		*(_mssamt__Add*)p = *(_mssamt__Add*)q;
		break;
	case SOAP_TYPE__mssamt__AddResponse:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy _mssamt__AddResponse type=%d location=%p object=%p\n", t, p, q));
		*(_mssamt__AddResponse*)p = *(_mssamt__AddResponse*)q;
		break;
	case SOAP_TYPE__mssamt__Subtract:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy _mssamt__Subtract type=%d location=%p object=%p\n", t, p, q));
		*(_mssamt__Subtract*)p = *(_mssamt__Subtract*)q;
		break;
	case SOAP_TYPE__mssamt__SubtractResponse:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy _mssamt__SubtractResponse type=%d location=%p object=%p\n", t, p, q));
		*(_mssamt__SubtractResponse*)p = *(_mssamt__SubtractResponse*)q;
		break;
	case SOAP_TYPE__mssamt__Multiply:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy _mssamt__Multiply type=%d location=%p object=%p\n", t, p, q));
		*(_mssamt__Multiply*)p = *(_mssamt__Multiply*)q;
		break;
	case SOAP_TYPE__mssamt__MultiplyResponse:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy _mssamt__MultiplyResponse type=%d location=%p object=%p\n", t, p, q));
		*(_mssamt__MultiplyResponse*)p = *(_mssamt__MultiplyResponse*)q;
		break;
	case SOAP_TYPE__mssamt__Divide:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy _mssamt__Divide type=%d location=%p object=%p\n", t, p, q));
		*(_mssamt__Divide*)p = *(_mssamt__Divide*)q;
		break;
	case SOAP_TYPE__mssamt__DivideResponse:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy _mssamt__DivideResponse type=%d location=%p object=%p\n", t, p, q));
		*(_mssamt__DivideResponse*)p = *(_mssamt__DivideResponse*)q;
		break;
	case SOAP_TYPE___tempuri__Add:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct __tempuri__Add type=%d location=%p object=%p\n", t, p, q));
		*(struct __tempuri__Add*)p = *(struct __tempuri__Add*)q;
		break;
	case SOAP_TYPE___tempuri__Subtract:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct __tempuri__Subtract type=%d location=%p object=%p\n", t, p, q));
		*(struct __tempuri__Subtract*)p = *(struct __tempuri__Subtract*)q;
		break;
	case SOAP_TYPE___tempuri__Multiply:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct __tempuri__Multiply type=%d location=%p object=%p\n", t, p, q));
		*(struct __tempuri__Multiply*)p = *(struct __tempuri__Multiply*)q;
		break;
	case SOAP_TYPE___tempuri__Divide:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct __tempuri__Divide type=%d location=%p object=%p\n", t, p, q));
		*(struct __tempuri__Divide*)p = *(struct __tempuri__Divide*)q;
		break;
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct SOAP_ENV__Header type=%d location=%p object=%p\n", t, p, q));
		*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct SOAP_ENV__Code type=%d location=%p object=%p\n", t, p, q));
		*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct SOAP_ENV__Detail type=%d location=%p object=%p\n", t, p, q));
		*(struct SOAP_ENV__Detail*)p = *(struct SOAP_ENV__Detail*)q;
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct SOAP_ENV__Reason type=%d location=%p object=%p\n", t, p, q));
		*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
		break;
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copy struct SOAP_ENV__Fault type=%d location=%p object=%p\n", t, p, q));
		*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
		break;
#endif
	default:
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Could not insert type = %d in %d\n", t, tt));
	}
}
#ifdef WIN32
#pragma warning(pop)
#endif
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{
	a = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return a;
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_new_byte(struct soap *soap, int n)
{
	char *a = static_cast<char *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(char)));
	for (char *p = a; p && n--; ++p)
		soap_default_byte(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	if (soap_out_byte(soap, tag ? tag : "byte", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{
	a = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return a;
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_new_int(struct soap *soap, int n)
{
	int *a = static_cast<int *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(int)));
	for (int *p = a; p && n--; ++p)
		soap_default_int(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	if (soap_out_int(soap, tag ? tag : "int", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_double(struct soap *soap, const char *tag, int id, const double *a, const char *type)
{
	return soap_outdouble(soap, tag, id, a, type, SOAP_TYPE_double);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_in_double(struct soap *soap, const char *tag, double *a, const char *type)
{
	a = soap_indouble(soap, tag, a, type, SOAP_TYPE_double);
	return a;
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_new_double(struct soap *soap, int n)
{
	double *a = static_cast<double *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(double)));
	for (double *p = a; p && n--; ++p)
		soap_default_double(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_double(struct soap *soap, const double *a, const char *tag, const char *type)
{
	if (soap_out_double(soap, tag ? tag : "double", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 double * SOAP_FMAC4 soap_get_double(struct soap *soap, double *p, const char *tag, const char *type)
{
	if ((p = soap_in_double(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _mssamt__DivideResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamt__DivideResponse::DivideResult = NULL;
	/* transient soap skipped */
}

void _mssamt__DivideResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTodouble(soap, &this->_mssamt__DivideResponse::DivideResult);
#endif
}

int _mssamt__DivideResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamt__DivideResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamt__DivideResponse(struct soap *soap, const char *tag, int id, const _mssamt__DivideResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamt__DivideResponse), type))
		return soap->error;
	if (a->DivideResult)
		soap_element_result(soap, "mssamt:DivideResult");
	if (soap_out_PointerTodouble(soap, "mssamt:DivideResult", -1, &a->_mssamt__DivideResponse::DivideResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_mssamt__DivideResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamt__DivideResponse(soap, tag, this, type);
}

SOAP_FMAC3 _mssamt__DivideResponse * SOAP_FMAC4 soap_in__mssamt__DivideResponse(struct soap *soap, const char *tag, _mssamt__DivideResponse *a, const char *type)
{
	(void)tag; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamt__DivideResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__mssamt__DivideResponse, sizeof(_mssamt__DivideResponse), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__mssamt__DivideResponse)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_mssamt__DivideResponse *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag_DivideResult1 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_DivideResult1 && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "mssamt:DivideResult", &a->_mssamt__DivideResponse::DivideResult, "xsd:double"))
				{	soap_flag_DivideResult1--;
					continue;
				}
			}
			soap_check_result(soap, "mssamt:DivideResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamt__DivideResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamt__DivideResponse, SOAP_TYPE__mssamt__DivideResponse, sizeof(_mssamt__DivideResponse), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 _mssamt__DivideResponse * SOAP_FMAC2 soap_instantiate__mssamt__DivideResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamt__DivideResponse(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	_mssamt__DivideResponse *p;
	size_t k = sizeof(_mssamt__DivideResponse);
	if (n < 0)
	{	p = SOAP_NEW(_mssamt__DivideResponse);
		if (p)
			((_mssamt__DivideResponse*)p)->soap = soap;
	}
	else
	{	p = SOAP_NEW_ARRAY(_mssamt__DivideResponse, n);
		k *= n;
		if (p)
			for (int i = 0; i < n; i++)
				((_mssamt__DivideResponse*)p)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated _mssamt__DivideResponse location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE__mssamt__DivideResponse, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

int _mssamt__DivideResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	if (soap_out__mssamt__DivideResponse(soap, tag ? tag : "mssamt:DivideResponse", -2, this, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamt__DivideResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamt__DivideResponse(soap, this, tag, type);
}

SOAP_FMAC3 _mssamt__DivideResponse * SOAP_FMAC4 soap_get__mssamt__DivideResponse(struct soap *soap, _mssamt__DivideResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamt__DivideResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _mssamt__Divide::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamt__Divide::n1 = NULL;
	this->_mssamt__Divide::n2 = NULL;
	/* transient soap skipped */
}

void _mssamt__Divide::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTodouble(soap, &this->_mssamt__Divide::n1);
	soap_serialize_PointerTodouble(soap, &this->_mssamt__Divide::n2);
#endif
}

int _mssamt__Divide::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamt__Divide(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamt__Divide(struct soap *soap, const char *tag, int id, const _mssamt__Divide *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamt__Divide), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamt:n1", -1, &a->_mssamt__Divide::n1, ""))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamt:n2", -1, &a->_mssamt__Divide::n2, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_mssamt__Divide::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamt__Divide(soap, tag, this, type);
}

SOAP_FMAC3 _mssamt__Divide * SOAP_FMAC4 soap_in__mssamt__Divide(struct soap *soap, const char *tag, _mssamt__Divide *a, const char *type)
{
	(void)tag; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamt__Divide *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__mssamt__Divide, sizeof(_mssamt__Divide), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__mssamt__Divide)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_mssamt__Divide *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag_n11 = 1;
	size_t soap_flag_n21 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_n11 && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "mssamt:n1", &a->_mssamt__Divide::n1, "xsd:double"))
				{	soap_flag_n11--;
					continue;
				}
			}
			if (soap_flag_n21 && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "mssamt:n2", &a->_mssamt__Divide::n2, "xsd:double"))
				{	soap_flag_n21--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamt__Divide *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamt__Divide, SOAP_TYPE__mssamt__Divide, sizeof(_mssamt__Divide), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 _mssamt__Divide * SOAP_FMAC2 soap_instantiate__mssamt__Divide(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamt__Divide(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	_mssamt__Divide *p;
	size_t k = sizeof(_mssamt__Divide);
	if (n < 0)
	{	p = SOAP_NEW(_mssamt__Divide);
		if (p)
			((_mssamt__Divide*)p)->soap = soap;
	}
	else
	{	p = SOAP_NEW_ARRAY(_mssamt__Divide, n);
		k *= n;
		if (p)
			for (int i = 0; i < n; i++)
				((_mssamt__Divide*)p)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated _mssamt__Divide location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE__mssamt__Divide, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

int _mssamt__Divide::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	if (soap_out__mssamt__Divide(soap, tag ? tag : "mssamt:Divide", -2, this, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamt__Divide::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamt__Divide(soap, this, tag, type);
}

SOAP_FMAC3 _mssamt__Divide * SOAP_FMAC4 soap_get__mssamt__Divide(struct soap *soap, _mssamt__Divide *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamt__Divide(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _mssamt__MultiplyResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamt__MultiplyResponse::MultiplyResult = NULL;
	/* transient soap skipped */
}

void _mssamt__MultiplyResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTodouble(soap, &this->_mssamt__MultiplyResponse::MultiplyResult);
#endif
}

int _mssamt__MultiplyResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamt__MultiplyResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamt__MultiplyResponse(struct soap *soap, const char *tag, int id, const _mssamt__MultiplyResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamt__MultiplyResponse), type))
		return soap->error;
	if (a->MultiplyResult)
		soap_element_result(soap, "mssamt:MultiplyResult");
	if (soap_out_PointerTodouble(soap, "mssamt:MultiplyResult", -1, &a->_mssamt__MultiplyResponse::MultiplyResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_mssamt__MultiplyResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamt__MultiplyResponse(soap, tag, this, type);
}

SOAP_FMAC3 _mssamt__MultiplyResponse * SOAP_FMAC4 soap_in__mssamt__MultiplyResponse(struct soap *soap, const char *tag, _mssamt__MultiplyResponse *a, const char *type)
{
	(void)tag; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamt__MultiplyResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__mssamt__MultiplyResponse, sizeof(_mssamt__MultiplyResponse), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__mssamt__MultiplyResponse)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_mssamt__MultiplyResponse *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag_MultiplyResult1 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_MultiplyResult1 && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "mssamt:MultiplyResult", &a->_mssamt__MultiplyResponse::MultiplyResult, "xsd:double"))
				{	soap_flag_MultiplyResult1--;
					continue;
				}
			}
			soap_check_result(soap, "mssamt:MultiplyResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamt__MultiplyResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamt__MultiplyResponse, SOAP_TYPE__mssamt__MultiplyResponse, sizeof(_mssamt__MultiplyResponse), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 _mssamt__MultiplyResponse * SOAP_FMAC2 soap_instantiate__mssamt__MultiplyResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamt__MultiplyResponse(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	_mssamt__MultiplyResponse *p;
	size_t k = sizeof(_mssamt__MultiplyResponse);
	if (n < 0)
	{	p = SOAP_NEW(_mssamt__MultiplyResponse);
		if (p)
			((_mssamt__MultiplyResponse*)p)->soap = soap;
	}
	else
	{	p = SOAP_NEW_ARRAY(_mssamt__MultiplyResponse, n);
		k *= n;
		if (p)
			for (int i = 0; i < n; i++)
				((_mssamt__MultiplyResponse*)p)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated _mssamt__MultiplyResponse location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE__mssamt__MultiplyResponse, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

int _mssamt__MultiplyResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	if (soap_out__mssamt__MultiplyResponse(soap, tag ? tag : "mssamt:MultiplyResponse", -2, this, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamt__MultiplyResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamt__MultiplyResponse(soap, this, tag, type);
}

SOAP_FMAC3 _mssamt__MultiplyResponse * SOAP_FMAC4 soap_get__mssamt__MultiplyResponse(struct soap *soap, _mssamt__MultiplyResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamt__MultiplyResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _mssamt__Multiply::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamt__Multiply::n1 = NULL;
	this->_mssamt__Multiply::n2 = NULL;
	/* transient soap skipped */
}

void _mssamt__Multiply::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTodouble(soap, &this->_mssamt__Multiply::n1);
	soap_serialize_PointerTodouble(soap, &this->_mssamt__Multiply::n2);
#endif
}

int _mssamt__Multiply::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamt__Multiply(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamt__Multiply(struct soap *soap, const char *tag, int id, const _mssamt__Multiply *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamt__Multiply), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamt:n1", -1, &a->_mssamt__Multiply::n1, ""))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamt:n2", -1, &a->_mssamt__Multiply::n2, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_mssamt__Multiply::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamt__Multiply(soap, tag, this, type);
}

SOAP_FMAC3 _mssamt__Multiply * SOAP_FMAC4 soap_in__mssamt__Multiply(struct soap *soap, const char *tag, _mssamt__Multiply *a, const char *type)
{
	(void)tag; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamt__Multiply *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__mssamt__Multiply, sizeof(_mssamt__Multiply), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__mssamt__Multiply)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_mssamt__Multiply *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag_n11 = 1;
	size_t soap_flag_n21 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_n11 && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "mssamt:n1", &a->_mssamt__Multiply::n1, "xsd:double"))
				{	soap_flag_n11--;
					continue;
				}
			}
			if (soap_flag_n21 && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "mssamt:n2", &a->_mssamt__Multiply::n2, "xsd:double"))
				{	soap_flag_n21--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamt__Multiply *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamt__Multiply, SOAP_TYPE__mssamt__Multiply, sizeof(_mssamt__Multiply), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 _mssamt__Multiply * SOAP_FMAC2 soap_instantiate__mssamt__Multiply(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamt__Multiply(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	_mssamt__Multiply *p;
	size_t k = sizeof(_mssamt__Multiply);
	if (n < 0)
	{	p = SOAP_NEW(_mssamt__Multiply);
		if (p)
			((_mssamt__Multiply*)p)->soap = soap;
	}
	else
	{	p = SOAP_NEW_ARRAY(_mssamt__Multiply, n);
		k *= n;
		if (p)
			for (int i = 0; i < n; i++)
				((_mssamt__Multiply*)p)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated _mssamt__Multiply location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE__mssamt__Multiply, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

int _mssamt__Multiply::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	if (soap_out__mssamt__Multiply(soap, tag ? tag : "mssamt:Multiply", -2, this, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamt__Multiply::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamt__Multiply(soap, this, tag, type);
}

SOAP_FMAC3 _mssamt__Multiply * SOAP_FMAC4 soap_get__mssamt__Multiply(struct soap *soap, _mssamt__Multiply *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamt__Multiply(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _mssamt__SubtractResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamt__SubtractResponse::SubtractResult = NULL;
	/* transient soap skipped */
}

void _mssamt__SubtractResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTodouble(soap, &this->_mssamt__SubtractResponse::SubtractResult);
#endif
}

int _mssamt__SubtractResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamt__SubtractResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamt__SubtractResponse(struct soap *soap, const char *tag, int id, const _mssamt__SubtractResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamt__SubtractResponse), type))
		return soap->error;
	if (a->SubtractResult)
		soap_element_result(soap, "mssamt:SubtractResult");
	if (soap_out_PointerTodouble(soap, "mssamt:SubtractResult", -1, &a->_mssamt__SubtractResponse::SubtractResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_mssamt__SubtractResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamt__SubtractResponse(soap, tag, this, type);
}

SOAP_FMAC3 _mssamt__SubtractResponse * SOAP_FMAC4 soap_in__mssamt__SubtractResponse(struct soap *soap, const char *tag, _mssamt__SubtractResponse *a, const char *type)
{
	(void)tag; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamt__SubtractResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__mssamt__SubtractResponse, sizeof(_mssamt__SubtractResponse), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__mssamt__SubtractResponse)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_mssamt__SubtractResponse *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag_SubtractResult1 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SubtractResult1 && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "mssamt:SubtractResult", &a->_mssamt__SubtractResponse::SubtractResult, "xsd:double"))
				{	soap_flag_SubtractResult1--;
					continue;
				}
			}
			soap_check_result(soap, "mssamt:SubtractResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamt__SubtractResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamt__SubtractResponse, SOAP_TYPE__mssamt__SubtractResponse, sizeof(_mssamt__SubtractResponse), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 _mssamt__SubtractResponse * SOAP_FMAC2 soap_instantiate__mssamt__SubtractResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamt__SubtractResponse(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	_mssamt__SubtractResponse *p;
	size_t k = sizeof(_mssamt__SubtractResponse);
	if (n < 0)
	{	p = SOAP_NEW(_mssamt__SubtractResponse);
		if (p)
			((_mssamt__SubtractResponse*)p)->soap = soap;
	}
	else
	{	p = SOAP_NEW_ARRAY(_mssamt__SubtractResponse, n);
		k *= n;
		if (p)
			for (int i = 0; i < n; i++)
				((_mssamt__SubtractResponse*)p)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated _mssamt__SubtractResponse location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE__mssamt__SubtractResponse, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

int _mssamt__SubtractResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	if (soap_out__mssamt__SubtractResponse(soap, tag ? tag : "mssamt:SubtractResponse", -2, this, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamt__SubtractResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamt__SubtractResponse(soap, this, tag, type);
}

SOAP_FMAC3 _mssamt__SubtractResponse * SOAP_FMAC4 soap_get__mssamt__SubtractResponse(struct soap *soap, _mssamt__SubtractResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamt__SubtractResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _mssamt__Subtract::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamt__Subtract::n1 = NULL;
	this->_mssamt__Subtract::n2 = NULL;
	/* transient soap skipped */
}

void _mssamt__Subtract::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTodouble(soap, &this->_mssamt__Subtract::n1);
	soap_serialize_PointerTodouble(soap, &this->_mssamt__Subtract::n2);
#endif
}

int _mssamt__Subtract::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamt__Subtract(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamt__Subtract(struct soap *soap, const char *tag, int id, const _mssamt__Subtract *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamt__Subtract), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamt:n1", -1, &a->_mssamt__Subtract::n1, ""))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamt:n2", -1, &a->_mssamt__Subtract::n2, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_mssamt__Subtract::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamt__Subtract(soap, tag, this, type);
}

SOAP_FMAC3 _mssamt__Subtract * SOAP_FMAC4 soap_in__mssamt__Subtract(struct soap *soap, const char *tag, _mssamt__Subtract *a, const char *type)
{
	(void)tag; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamt__Subtract *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__mssamt__Subtract, sizeof(_mssamt__Subtract), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__mssamt__Subtract)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_mssamt__Subtract *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag_n11 = 1;
	size_t soap_flag_n21 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_n11 && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "mssamt:n1", &a->_mssamt__Subtract::n1, "xsd:double"))
				{	soap_flag_n11--;
					continue;
				}
			}
			if (soap_flag_n21 && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "mssamt:n2", &a->_mssamt__Subtract::n2, "xsd:double"))
				{	soap_flag_n21--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamt__Subtract *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamt__Subtract, SOAP_TYPE__mssamt__Subtract, sizeof(_mssamt__Subtract), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 _mssamt__Subtract * SOAP_FMAC2 soap_instantiate__mssamt__Subtract(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamt__Subtract(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	_mssamt__Subtract *p;
	size_t k = sizeof(_mssamt__Subtract);
	if (n < 0)
	{	p = SOAP_NEW(_mssamt__Subtract);
		if (p)
			((_mssamt__Subtract*)p)->soap = soap;
	}
	else
	{	p = SOAP_NEW_ARRAY(_mssamt__Subtract, n);
		k *= n;
		if (p)
			for (int i = 0; i < n; i++)
				((_mssamt__Subtract*)p)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated _mssamt__Subtract location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE__mssamt__Subtract, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

int _mssamt__Subtract::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	if (soap_out__mssamt__Subtract(soap, tag ? tag : "mssamt:Subtract", -2, this, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamt__Subtract::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamt__Subtract(soap, this, tag, type);
}

SOAP_FMAC3 _mssamt__Subtract * SOAP_FMAC4 soap_get__mssamt__Subtract(struct soap *soap, _mssamt__Subtract *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamt__Subtract(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _mssamt__AddResponse::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamt__AddResponse::AddResult = NULL;
	/* transient soap skipped */
}

void _mssamt__AddResponse::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTodouble(soap, &this->_mssamt__AddResponse::AddResult);
#endif
}

int _mssamt__AddResponse::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamt__AddResponse(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamt__AddResponse(struct soap *soap, const char *tag, int id, const _mssamt__AddResponse *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamt__AddResponse), type))
		return soap->error;
	if (a->AddResult)
		soap_element_result(soap, "mssamt:AddResult");
	if (soap_out_PointerTodouble(soap, "mssamt:AddResult", -1, &a->_mssamt__AddResponse::AddResult, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_mssamt__AddResponse::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamt__AddResponse(soap, tag, this, type);
}

SOAP_FMAC3 _mssamt__AddResponse * SOAP_FMAC4 soap_in__mssamt__AddResponse(struct soap *soap, const char *tag, _mssamt__AddResponse *a, const char *type)
{
	(void)tag; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamt__AddResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__mssamt__AddResponse, sizeof(_mssamt__AddResponse), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__mssamt__AddResponse)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_mssamt__AddResponse *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag_AddResult1 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_AddResult1 && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "mssamt:AddResult", &a->_mssamt__AddResponse::AddResult, "xsd:double"))
				{	soap_flag_AddResult1--;
					continue;
				}
			}
			soap_check_result(soap, "mssamt:AddResult");
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamt__AddResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamt__AddResponse, SOAP_TYPE__mssamt__AddResponse, sizeof(_mssamt__AddResponse), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 _mssamt__AddResponse * SOAP_FMAC2 soap_instantiate__mssamt__AddResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamt__AddResponse(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	_mssamt__AddResponse *p;
	size_t k = sizeof(_mssamt__AddResponse);
	if (n < 0)
	{	p = SOAP_NEW(_mssamt__AddResponse);
		if (p)
			((_mssamt__AddResponse*)p)->soap = soap;
	}
	else
	{	p = SOAP_NEW_ARRAY(_mssamt__AddResponse, n);
		k *= n;
		if (p)
			for (int i = 0; i < n; i++)
				((_mssamt__AddResponse*)p)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated _mssamt__AddResponse location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE__mssamt__AddResponse, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

int _mssamt__AddResponse::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	if (soap_out__mssamt__AddResponse(soap, tag ? tag : "mssamt:AddResponse", -2, this, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamt__AddResponse::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamt__AddResponse(soap, this, tag, type);
}

SOAP_FMAC3 _mssamt__AddResponse * SOAP_FMAC4 soap_get__mssamt__AddResponse(struct soap *soap, _mssamt__AddResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamt__AddResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _mssamt__Add::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_mssamt__Add::n1 = NULL;
	this->_mssamt__Add::n2 = NULL;
	/* transient soap skipped */
}

void _mssamt__Add::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTodouble(soap, &this->_mssamt__Add::n1);
	soap_serialize_PointerTodouble(soap, &this->_mssamt__Add::n2);
#endif
}

int _mssamt__Add::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__mssamt__Add(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__mssamt__Add(struct soap *soap, const char *tag, int id, const _mssamt__Add *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__mssamt__Add), type))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamt:n1", -1, &a->_mssamt__Add::n1, ""))
		return soap->error;
	if (soap_out_PointerTodouble(soap, "mssamt:n2", -1, &a->_mssamt__Add::n2, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *_mssamt__Add::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__mssamt__Add(soap, tag, this, type);
}

SOAP_FMAC3 _mssamt__Add * SOAP_FMAC4 soap_in__mssamt__Add(struct soap *soap, const char *tag, _mssamt__Add *a, const char *type)
{
	(void)tag; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_mssamt__Add *)soap_id_enter(soap, soap->id, a, SOAP_TYPE__mssamt__Add, sizeof(_mssamt__Add), soap->type, soap->arrayType, soap_instantiate, soap_fbase);
	if (!a)
		return NULL;
	if (soap->alloced && soap->alloced != SOAP_TYPE__mssamt__Add)
	{	soap_revert(soap);
		*soap->id = '\0';
		return (_mssamt__Add *)a->soap_in(soap, tag, type);
	}
	if (soap->alloced)
		a->soap_default(soap);
	size_t soap_flag_n11 = 1;
	size_t soap_flag_n21 = 1;
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_n11 && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "mssamt:n1", &a->_mssamt__Add::n1, "xsd:double"))
				{	soap_flag_n11--;
					continue;
				}
			}
			if (soap_flag_n21 && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTodouble(soap, "mssamt:n2", &a->_mssamt__Add::n2, "xsd:double"))
				{	soap_flag_n21--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_mssamt__Add *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__mssamt__Add, SOAP_TYPE__mssamt__Add, sizeof(_mssamt__Add), 0, soap_finsert, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 _mssamt__Add * SOAP_FMAC2 soap_instantiate__mssamt__Add(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__mssamt__Add(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	_mssamt__Add *p;
	size_t k = sizeof(_mssamt__Add);
	if (n < 0)
	{	p = SOAP_NEW(_mssamt__Add);
		if (p)
			((_mssamt__Add*)p)->soap = soap;
	}
	else
	{	p = SOAP_NEW_ARRAY(_mssamt__Add, n);
		k *= n;
		if (p)
			for (int i = 0; i < n; i++)
				((_mssamt__Add*)p)[i].soap = soap;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated _mssamt__Add location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE__mssamt__Add, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

int _mssamt__Add::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	if (soap_out__mssamt__Add(soap, tag ? tag : "mssamt:Add", -2, this, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_mssamt__Add::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__mssamt__Add(soap, this, tag, type);
}

SOAP_FMAC3 _mssamt__Add * SOAP_FMAC4 soap_get__mssamt__Add(struct soap *soap, _mssamt__Add *p, const char *tag, const char *type)
{
	if ((p = soap_in__mssamt__Add(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize__QName(soap, (char*const*)&a->faultcode);
	soap_serialize_string(soap, (char*const*)&a->faultstring);
	soap_serialize_string(soap, (char*const*)&a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, (char*const*)&a->SOAP_ENV__Node);
	soap_serialize_string(soap, (char*const*)&a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)(void*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, (char*const*)&a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, (char*const*)&a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, (char*const*)&a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, (char*const*)&a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in__QName(soap, "faultcode", (char**)&a->faultcode, "xsd:QName"))
				{	soap_flag_faultcode--;
					continue;
				}
			}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_string(soap, "faultstring", (char**)&a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_string(soap, "faultactor", (char**)&a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_string(soap, "SOAP-ENV:Node", (char**)&a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_string(soap, "SOAP-ENV:Role", (char**)&a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct SOAP_ENV__Fault * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct SOAP_ENV__Fault *p;
	size_t k = sizeof(struct SOAP_ENV__Fault);
	if (n < 0)
	{	p = SOAP_NEW(struct SOAP_ENV__Fault);
	}
	else
	{	p = SOAP_NEW_ARRAY(struct SOAP_ENV__Fault, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct SOAP_ENV__Fault location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	if (soap_out_SOAP_ENV__Fault(soap, tag ? tag : "SOAP-ENV:Fault", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_string(soap, (char*const*)&a->SOAP_ENV__Text);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang, 1);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, (char*const*)&a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in_string(soap, "SOAP-ENV:Text", (char**)&a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct SOAP_ENV__Reason * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct SOAP_ENV__Reason *p;
	size_t k = sizeof(struct SOAP_ENV__Reason);
	if (n < 0)
	{	p = SOAP_NEW(struct SOAP_ENV__Reason);
	}
	else
	{	p = SOAP_NEW_ARRAY(struct SOAP_ENV__Reason, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct SOAP_ENV__Reason location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	if (soap_out_SOAP_ENV__Reason(soap, tag ? tag : "SOAP-ENV:Reason", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->__any = NULL;
	a->__type = 0;
	a->fault = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_markelement(soap, a->fault, a->__type);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Detail(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Detail *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Detail), type))
		return soap->error;
	soap_outliteral(soap, "-any", (char*const*)&a->__any, NULL);
	if (soap_putelement(soap, a->fault, "fault", -1, a->__type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_in_SOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail *a, const char *type)
{
	size_t soap_flag___any = 1;
	size_t soap_flag_fault = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Detail *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Detail(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault && soap->error == SOAP_TAG_MISMATCH)
			{	if ((a->fault = soap_getelement(soap, &a->__type)))
				{	soap_flag_fault = 0;
					continue;
				}
			}
			if (soap_flag___any && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_inliteral(soap, "-any", (char**)&a->__any))
				{	soap_flag___any--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Detail, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct SOAP_ENV__Detail * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Detail(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Detail(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct SOAP_ENV__Detail *p;
	size_t k = sizeof(struct SOAP_ENV__Detail);
	if (n < 0)
	{	p = SOAP_NEW(struct SOAP_ENV__Detail);
	}
	else
	{	p = SOAP_NEW_ARRAY(struct SOAP_ENV__Detail, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct SOAP_ENV__Detail location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE_SOAP_ENV__Detail, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Detail(struct soap *soap, const struct SOAP_ENV__Detail *a, const char *tag, const char *type)
{
	if (soap_out_SOAP_ENV__Detail(soap, tag ? tag : "SOAP-ENV:Detail", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail * SOAP_FMAC4 soap_get_SOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize__QName(soap, (char*const*)&a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)(void*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
			{	if (soap_in__QName(soap, "SOAP-ENV:Value", (char**)&a->SOAP_ENV__Value, "xsd:QName"))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct SOAP_ENV__Code * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct SOAP_ENV__Code *p;
	size_t k = sizeof(struct SOAP_ENV__Code);
	if (n < 0)
	{	p = SOAP_NEW(struct SOAP_ENV__Code);
	}
	else
	{	p = SOAP_NEW_ARRAY(struct SOAP_ENV__Code, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct SOAP_ENV__Code location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	if (soap_out_SOAP_ENV__Code(soap, tag ? tag : "SOAP-ENV:Code", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && *soap->href != '#')
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, soap_finsert, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC1 struct SOAP_ENV__Header * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct SOAP_ENV__Header *p;
	size_t k = sizeof(struct SOAP_ENV__Header);
	if (n < 0)
	{	p = SOAP_NEW(struct SOAP_ENV__Header);
	}
	else
	{	p = SOAP_NEW_ARRAY(struct SOAP_ENV__Header, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct SOAP_ENV__Header location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	if (soap_out_SOAP_ENV__Header(soap, tag ? tag : "SOAP-ENV:Header", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__Divide(struct soap *soap, struct __tempuri__Divide *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssamt__Divide = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__Divide(struct soap *soap, const struct __tempuri__Divide *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTo_mssamt__Divide(soap, &a->mssamt__Divide);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__Divide(struct soap *soap, const char *tag, int id, const struct __tempuri__Divide *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_out_PointerTo_mssamt__Divide(soap, "mssamt:Divide", -1, &a->mssamt__Divide, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Divide * SOAP_FMAC4 soap_in___tempuri__Divide(struct soap *soap, const char *tag, struct __tempuri__Divide *a, const char *type)
{
	size_t soap_flag_mssamt__Divide = 1;
	short soap_flag;
	(void)tag; (void)type; /* appease -Wall -Werror */
	a = (struct __tempuri__Divide *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__Divide, sizeof(struct __tempuri__Divide), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__Divide(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssamt__Divide && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTo_mssamt__Divide(soap, "mssamt:Divide", &a->mssamt__Divide, ""))
				{	soap_flag_mssamt__Divide--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH && soap_flag)
			{	soap->error = SOAP_OK;
				break;
			}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC1 struct __tempuri__Divide * SOAP_FMAC2 soap_instantiate___tempuri__Divide(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__Divide(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct __tempuri__Divide *p;
	size_t k = sizeof(struct __tempuri__Divide);
	if (n < 0)
	{	p = SOAP_NEW(struct __tempuri__Divide);
	}
	else
	{	p = SOAP_NEW_ARRAY(struct __tempuri__Divide, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct __tempuri__Divide location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE___tempuri__Divide, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__Divide(struct soap *soap, const struct __tempuri__Divide *a, const char *tag, const char *type)
{
	if (soap_out___tempuri__Divide(soap, tag ? tag : "-tempuri:Divide", -2, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Divide * SOAP_FMAC4 soap_get___tempuri__Divide(struct soap *soap, struct __tempuri__Divide *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__Divide(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__Multiply(struct soap *soap, struct __tempuri__Multiply *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssamt__Multiply = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__Multiply(struct soap *soap, const struct __tempuri__Multiply *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTo_mssamt__Multiply(soap, &a->mssamt__Multiply);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__Multiply(struct soap *soap, const char *tag, int id, const struct __tempuri__Multiply *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_out_PointerTo_mssamt__Multiply(soap, "mssamt:Multiply", -1, &a->mssamt__Multiply, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Multiply * SOAP_FMAC4 soap_in___tempuri__Multiply(struct soap *soap, const char *tag, struct __tempuri__Multiply *a, const char *type)
{
	size_t soap_flag_mssamt__Multiply = 1;
	short soap_flag;
	(void)tag; (void)type; /* appease -Wall -Werror */
	a = (struct __tempuri__Multiply *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__Multiply, sizeof(struct __tempuri__Multiply), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__Multiply(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssamt__Multiply && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTo_mssamt__Multiply(soap, "mssamt:Multiply", &a->mssamt__Multiply, ""))
				{	soap_flag_mssamt__Multiply--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH && soap_flag)
			{	soap->error = SOAP_OK;
				break;
			}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC1 struct __tempuri__Multiply * SOAP_FMAC2 soap_instantiate___tempuri__Multiply(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__Multiply(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct __tempuri__Multiply *p;
	size_t k = sizeof(struct __tempuri__Multiply);
	if (n < 0)
	{	p = SOAP_NEW(struct __tempuri__Multiply);
	}
	else
	{	p = SOAP_NEW_ARRAY(struct __tempuri__Multiply, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct __tempuri__Multiply location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE___tempuri__Multiply, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__Multiply(struct soap *soap, const struct __tempuri__Multiply *a, const char *tag, const char *type)
{
	if (soap_out___tempuri__Multiply(soap, tag ? tag : "-tempuri:Multiply", -2, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Multiply * SOAP_FMAC4 soap_get___tempuri__Multiply(struct soap *soap, struct __tempuri__Multiply *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__Multiply(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__Subtract(struct soap *soap, struct __tempuri__Subtract *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssamt__Subtract = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__Subtract(struct soap *soap, const struct __tempuri__Subtract *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTo_mssamt__Subtract(soap, &a->mssamt__Subtract);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__Subtract(struct soap *soap, const char *tag, int id, const struct __tempuri__Subtract *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_out_PointerTo_mssamt__Subtract(soap, "mssamt:Subtract", -1, &a->mssamt__Subtract, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Subtract * SOAP_FMAC4 soap_in___tempuri__Subtract(struct soap *soap, const char *tag, struct __tempuri__Subtract *a, const char *type)
{
	size_t soap_flag_mssamt__Subtract = 1;
	short soap_flag;
	(void)tag; (void)type; /* appease -Wall -Werror */
	a = (struct __tempuri__Subtract *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__Subtract, sizeof(struct __tempuri__Subtract), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__Subtract(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssamt__Subtract && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTo_mssamt__Subtract(soap, "mssamt:Subtract", &a->mssamt__Subtract, ""))
				{	soap_flag_mssamt__Subtract--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH && soap_flag)
			{	soap->error = SOAP_OK;
				break;
			}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC1 struct __tempuri__Subtract * SOAP_FMAC2 soap_instantiate___tempuri__Subtract(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__Subtract(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct __tempuri__Subtract *p;
	size_t k = sizeof(struct __tempuri__Subtract);
	if (n < 0)
	{	p = SOAP_NEW(struct __tempuri__Subtract);
	}
	else
	{	p = SOAP_NEW_ARRAY(struct __tempuri__Subtract, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct __tempuri__Subtract location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE___tempuri__Subtract, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__Subtract(struct soap *soap, const struct __tempuri__Subtract *a, const char *tag, const char *type)
{
	if (soap_out___tempuri__Subtract(soap, tag ? tag : "-tempuri:Subtract", -2, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Subtract * SOAP_FMAC4 soap_get___tempuri__Subtract(struct soap *soap, struct __tempuri__Subtract *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__Subtract(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default___tempuri__Add(struct soap *soap, struct __tempuri__Add *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->mssamt__Add = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize___tempuri__Add(struct soap *soap, const struct __tempuri__Add *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	soap_serialize_PointerTo_mssamt__Add(soap, &a->mssamt__Add);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out___tempuri__Add(struct soap *soap, const char *tag, int id, const struct __tempuri__Add *a, const char *type)
{
	(void)soap; (void)tag; (void)id; (void)a; (void)type; /* appease -Wall -Werror */
	if (soap_out_PointerTo_mssamt__Add(soap, "mssamt:Add", -1, &a->mssamt__Add, ""))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Add * SOAP_FMAC4 soap_in___tempuri__Add(struct soap *soap, const char *tag, struct __tempuri__Add *a, const char *type)
{
	size_t soap_flag_mssamt__Add = 1;
	short soap_flag;
	(void)tag; (void)type; /* appease -Wall -Werror */
	a = (struct __tempuri__Add *)soap_id_enter(soap, "", a, SOAP_TYPE___tempuri__Add, sizeof(struct __tempuri__Add), NULL, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default___tempuri__Add(soap, a);
		for (soap_flag = 0;; soap_flag = 1)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_mssamt__Add && soap->error == SOAP_TAG_MISMATCH)
			{	if (soap_in_PointerTo_mssamt__Add(soap, "mssamt:Add", &a->mssamt__Add, ""))
				{	soap_flag_mssamt__Add--;
					continue;
				}
			}
			if (soap->error == SOAP_TAG_MISMATCH && soap_flag)
			{	soap->error = SOAP_OK;
				break;
			}
			if (soap_flag && soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
	return a;
}

SOAP_FMAC1 struct __tempuri__Add * SOAP_FMAC2 soap_instantiate___tempuri__Add(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate___tempuri__Add(%p, %d, %s, %s)\n", (void*)soap, n, type?type:"", arrayType?arrayType:""));
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	struct __tempuri__Add *p;
	size_t k = sizeof(struct __tempuri__Add);
	if (n < 0)
	{	p = SOAP_NEW(struct __tempuri__Add);
	}
	else
	{	p = SOAP_NEW_ARRAY(struct __tempuri__Add, n);
		k *= n;
	}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated struct __tempuri__Add location=%p n=%d\n", (void*)p, n));
	soap_link(soap, p, SOAP_TYPE___tempuri__Add, n, soap_fdelete);
	if (size)
		*size = k;
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put___tempuri__Add(struct soap *soap, const struct __tempuri__Add *a, const char *tag, const char *type)
{
	if (soap_out___tempuri__Add(soap, tag ? tag : "-tempuri:Add", -2, a, type))
		return soap->error;
	return SOAP_OK;
}

SOAP_FMAC3 struct __tempuri__Add * SOAP_FMAC4 soap_get___tempuri__Add(struct soap *soap, struct __tempuri__Add *p, const char *tag, const char *type)
{
	if ((p = soap_in___tempuri__Add(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Reason))
		soap_serialize_SOAP_ENV__Reason(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Reason *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Reason, NULL);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Reason(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason **a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Reason **)soap_malloc(soap, sizeof(struct SOAP_ENV__Reason *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Reason(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *const*a, const char *tag, const char *type)
{
	if (soap_out_PointerToSOAP_ENV__Reason(soap, tag ? tag : "SOAP-ENV:Reason", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Detail))
		soap_serialize_SOAP_ENV__Detail(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Detail *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Detail, NULL);
	if (id < 0)
		return soap->error;
	return soap_out_SOAP_ENV__Detail(soap, tag, id, *a, type);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Detail(struct soap *soap, const char *tag, struct SOAP_ENV__Detail **a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Detail **)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Detail(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Detail **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Detail, sizeof(struct SOAP_ENV__Detail), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail *const*a, const char *tag, const char *type)
{
	if (soap_out_PointerToSOAP_ENV__Detail(soap, tag ? tag : "SOAP-ENV:Detail", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Detail ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Detail(struct soap *soap, struct SOAP_ENV__Detail **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Detail(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE_SOAP_ENV__Code))
		soap_serialize_SOAP_ENV__Code(soap, *a);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, int id, struct SOAP_ENV__Code *const*a, const char *type)
{
	char *mark;
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_SOAP_ENV__Code, &mark);
	if (id < 0)
		return soap->error;
	soap_out_SOAP_ENV__Code(soap, tag, id, *a, type);
	soap_unmark(soap, mark);
	return soap->error;
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_in_PointerToSOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code **a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (struct SOAP_ENV__Code **)soap_malloc(soap, sizeof(struct SOAP_ENV__Code *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_SOAP_ENV__Code(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *const*a, const char *tag, const char *type)
{
	if (soap_out_PointerToSOAP_ENV__Code(soap, tag ? tag : "SOAP-ENV:Code", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code ** SOAP_FMAC4 soap_get_PointerToSOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerToSOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamt__DivideResponse(struct soap *soap, _mssamt__DivideResponse *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamt__DivideResponse))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamt__DivideResponse(struct soap *soap, const char *tag, int id, _mssamt__DivideResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamt__DivideResponse, NULL);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, (*a)->soap_type() == SOAP_TYPE__mssamt__DivideResponse ? type : NULL);
}

SOAP_FMAC3 _mssamt__DivideResponse ** SOAP_FMAC4 soap_in_PointerTo_mssamt__DivideResponse(struct soap *soap, const char *tag, _mssamt__DivideResponse **a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamt__DivideResponse **)soap_malloc(soap, sizeof(_mssamt__DivideResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamt__DivideResponse *)soap_instantiate__mssamt__DivideResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
		{	*a = NULL;
			return NULL;
		}
	}
	else
	{	a = (_mssamt__DivideResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamt__DivideResponse, sizeof(_mssamt__DivideResponse), 0, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamt__DivideResponse(struct soap *soap, _mssamt__DivideResponse *const*a, const char *tag, const char *type)
{
	if (soap_out_PointerTo_mssamt__DivideResponse(soap, tag ? tag : "mssamt:DivideResponse", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamt__DivideResponse ** SOAP_FMAC4 soap_get_PointerTo_mssamt__DivideResponse(struct soap *soap, _mssamt__DivideResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamt__DivideResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamt__Divide(struct soap *soap, _mssamt__Divide *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamt__Divide))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamt__Divide(struct soap *soap, const char *tag, int id, _mssamt__Divide *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamt__Divide, NULL);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, (*a)->soap_type() == SOAP_TYPE__mssamt__Divide ? type : NULL);
}

SOAP_FMAC3 _mssamt__Divide ** SOAP_FMAC4 soap_in_PointerTo_mssamt__Divide(struct soap *soap, const char *tag, _mssamt__Divide **a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamt__Divide **)soap_malloc(soap, sizeof(_mssamt__Divide *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamt__Divide *)soap_instantiate__mssamt__Divide(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
		{	*a = NULL;
			return NULL;
		}
	}
	else
	{	a = (_mssamt__Divide **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamt__Divide, sizeof(_mssamt__Divide), 0, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamt__Divide(struct soap *soap, _mssamt__Divide *const*a, const char *tag, const char *type)
{
	if (soap_out_PointerTo_mssamt__Divide(soap, tag ? tag : "mssamt:Divide", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamt__Divide ** SOAP_FMAC4 soap_get_PointerTo_mssamt__Divide(struct soap *soap, _mssamt__Divide **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamt__Divide(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamt__MultiplyResponse(struct soap *soap, _mssamt__MultiplyResponse *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamt__MultiplyResponse))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamt__MultiplyResponse(struct soap *soap, const char *tag, int id, _mssamt__MultiplyResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamt__MultiplyResponse, NULL);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, (*a)->soap_type() == SOAP_TYPE__mssamt__MultiplyResponse ? type : NULL);
}

SOAP_FMAC3 _mssamt__MultiplyResponse ** SOAP_FMAC4 soap_in_PointerTo_mssamt__MultiplyResponse(struct soap *soap, const char *tag, _mssamt__MultiplyResponse **a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamt__MultiplyResponse **)soap_malloc(soap, sizeof(_mssamt__MultiplyResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamt__MultiplyResponse *)soap_instantiate__mssamt__MultiplyResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
		{	*a = NULL;
			return NULL;
		}
	}
	else
	{	a = (_mssamt__MultiplyResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamt__MultiplyResponse, sizeof(_mssamt__MultiplyResponse), 0, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamt__MultiplyResponse(struct soap *soap, _mssamt__MultiplyResponse *const*a, const char *tag, const char *type)
{
	if (soap_out_PointerTo_mssamt__MultiplyResponse(soap, tag ? tag : "mssamt:MultiplyResponse", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamt__MultiplyResponse ** SOAP_FMAC4 soap_get_PointerTo_mssamt__MultiplyResponse(struct soap *soap, _mssamt__MultiplyResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamt__MultiplyResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamt__Multiply(struct soap *soap, _mssamt__Multiply *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamt__Multiply))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamt__Multiply(struct soap *soap, const char *tag, int id, _mssamt__Multiply *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamt__Multiply, NULL);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, (*a)->soap_type() == SOAP_TYPE__mssamt__Multiply ? type : NULL);
}

SOAP_FMAC3 _mssamt__Multiply ** SOAP_FMAC4 soap_in_PointerTo_mssamt__Multiply(struct soap *soap, const char *tag, _mssamt__Multiply **a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamt__Multiply **)soap_malloc(soap, sizeof(_mssamt__Multiply *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamt__Multiply *)soap_instantiate__mssamt__Multiply(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
		{	*a = NULL;
			return NULL;
		}
	}
	else
	{	a = (_mssamt__Multiply **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamt__Multiply, sizeof(_mssamt__Multiply), 0, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamt__Multiply(struct soap *soap, _mssamt__Multiply *const*a, const char *tag, const char *type)
{
	if (soap_out_PointerTo_mssamt__Multiply(soap, tag ? tag : "mssamt:Multiply", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamt__Multiply ** SOAP_FMAC4 soap_get_PointerTo_mssamt__Multiply(struct soap *soap, _mssamt__Multiply **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamt__Multiply(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamt__SubtractResponse(struct soap *soap, _mssamt__SubtractResponse *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamt__SubtractResponse))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamt__SubtractResponse(struct soap *soap, const char *tag, int id, _mssamt__SubtractResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamt__SubtractResponse, NULL);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, (*a)->soap_type() == SOAP_TYPE__mssamt__SubtractResponse ? type : NULL);
}

SOAP_FMAC3 _mssamt__SubtractResponse ** SOAP_FMAC4 soap_in_PointerTo_mssamt__SubtractResponse(struct soap *soap, const char *tag, _mssamt__SubtractResponse **a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamt__SubtractResponse **)soap_malloc(soap, sizeof(_mssamt__SubtractResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamt__SubtractResponse *)soap_instantiate__mssamt__SubtractResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
		{	*a = NULL;
			return NULL;
		}
	}
	else
	{	a = (_mssamt__SubtractResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamt__SubtractResponse, sizeof(_mssamt__SubtractResponse), 0, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamt__SubtractResponse(struct soap *soap, _mssamt__SubtractResponse *const*a, const char *tag, const char *type)
{
	if (soap_out_PointerTo_mssamt__SubtractResponse(soap, tag ? tag : "mssamt:SubtractResponse", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamt__SubtractResponse ** SOAP_FMAC4 soap_get_PointerTo_mssamt__SubtractResponse(struct soap *soap, _mssamt__SubtractResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamt__SubtractResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamt__Subtract(struct soap *soap, _mssamt__Subtract *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamt__Subtract))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamt__Subtract(struct soap *soap, const char *tag, int id, _mssamt__Subtract *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamt__Subtract, NULL);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, (*a)->soap_type() == SOAP_TYPE__mssamt__Subtract ? type : NULL);
}

SOAP_FMAC3 _mssamt__Subtract ** SOAP_FMAC4 soap_in_PointerTo_mssamt__Subtract(struct soap *soap, const char *tag, _mssamt__Subtract **a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamt__Subtract **)soap_malloc(soap, sizeof(_mssamt__Subtract *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamt__Subtract *)soap_instantiate__mssamt__Subtract(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
		{	*a = NULL;
			return NULL;
		}
	}
	else
	{	a = (_mssamt__Subtract **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamt__Subtract, sizeof(_mssamt__Subtract), 0, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamt__Subtract(struct soap *soap, _mssamt__Subtract *const*a, const char *tag, const char *type)
{
	if (soap_out_PointerTo_mssamt__Subtract(soap, tag ? tag : "mssamt:Subtract", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamt__Subtract ** SOAP_FMAC4 soap_get_PointerTo_mssamt__Subtract(struct soap *soap, _mssamt__Subtract **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamt__Subtract(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamt__AddResponse(struct soap *soap, _mssamt__AddResponse *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamt__AddResponse))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamt__AddResponse(struct soap *soap, const char *tag, int id, _mssamt__AddResponse *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamt__AddResponse, NULL);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, (*a)->soap_type() == SOAP_TYPE__mssamt__AddResponse ? type : NULL);
}

SOAP_FMAC3 _mssamt__AddResponse ** SOAP_FMAC4 soap_in_PointerTo_mssamt__AddResponse(struct soap *soap, const char *tag, _mssamt__AddResponse **a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamt__AddResponse **)soap_malloc(soap, sizeof(_mssamt__AddResponse *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamt__AddResponse *)soap_instantiate__mssamt__AddResponse(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
		{	*a = NULL;
			return NULL;
		}
	}
	else
	{	a = (_mssamt__AddResponse **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamt__AddResponse, sizeof(_mssamt__AddResponse), 0, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamt__AddResponse(struct soap *soap, _mssamt__AddResponse *const*a, const char *tag, const char *type)
{
	if (soap_out_PointerTo_mssamt__AddResponse(soap, tag ? tag : "mssamt:AddResponse", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamt__AddResponse ** SOAP_FMAC4 soap_get_PointerTo_mssamt__AddResponse(struct soap *soap, _mssamt__AddResponse **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamt__AddResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTo_mssamt__Add(struct soap *soap, _mssamt__Add *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	if (!soap_reference(soap, *a, SOAP_TYPE__mssamt__Add))
		(*a)->soap_serialize(soap);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTo_mssamt__Add(struct soap *soap, const char *tag, int id, _mssamt__Add *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE__mssamt__Add, NULL);
	if (id < 0)
		return soap->error;
	return (*a)->soap_out(soap, tag, id, (*a)->soap_type() == SOAP_TYPE__mssamt__Add ? type : NULL);
}

SOAP_FMAC3 _mssamt__Add ** SOAP_FMAC4 soap_in_PointerTo_mssamt__Add(struct soap *soap, const char *tag, _mssamt__Add **a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (_mssamt__Add **)soap_malloc(soap, sizeof(_mssamt__Add *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = (_mssamt__Add *)soap_instantiate__mssamt__Add(soap, -1, soap->type, soap->arrayType, NULL)))
			return NULL;
		(*a)->soap_default(soap);
		if (!(*a)->soap_in(soap, tag, NULL))
		{	*a = NULL;
			return NULL;
		}
	}
	else
	{	a = (_mssamt__Add **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE__mssamt__Add, sizeof(_mssamt__Add), 0, soap_fbase);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTo_mssamt__Add(struct soap *soap, _mssamt__Add *const*a, const char *tag, const char *type)
{
	if (soap_out_PointerTo_mssamt__Add(soap, tag ? tag : "mssamt:Add", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 _mssamt__Add ** SOAP_FMAC4 soap_get_PointerTo_mssamt__Add(struct soap *soap, _mssamt__Add **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTo_mssamt__Add(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_PointerTodouble(struct soap *soap, double *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	(void)soap_reference(soap, *a, SOAP_TYPE_double);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_PointerTodouble(struct soap *soap, const char *tag, int id, double *const*a, const char *type)
{
	id = soap_element_id(soap, tag, id, *a, NULL, 0, type, SOAP_TYPE_double, NULL);
	if (id < 0)
		return soap->error;
	return soap_out_double(soap, tag, id, *a, type);
}

SOAP_FMAC3 double ** SOAP_FMAC4 soap_in_PointerTodouble(struct soap *soap, const char *tag, double **a, const char *type)
{
	(void)type; /* appease -Wall -Werror */
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (!a)
		if (!(a = (double **)soap_malloc(soap, sizeof(double *))))
			return NULL;
	*a = NULL;
	if (!soap->null && *soap->href != '#')
	{	soap_revert(soap);
		if (!(*a = soap_in_double(soap, tag, *a, type)))
			return NULL;
	}
	else
	{	a = (double **)soap_id_lookup(soap, soap->href, (void**)a, SOAP_TYPE_double, sizeof(double), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_PointerTodouble(struct soap *soap, double *const*a, const char *tag, const char *type)
{
	if (soap_out_PointerTodouble(soap, tag ? tag : "double", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 double ** SOAP_FMAC4 soap_get_PointerTodouble(struct soap *soap, double **p, const char *tag, const char *type)
{
	if ((p = soap_in_PointerTodouble(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize__QName(struct soap *soap, char *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	(void)soap_reference(soap, *a, SOAP_TYPE__QName);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__QName(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE__QName);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in__QName(struct soap *soap, const char *tag, char **a, const char *type)
{
	a = soap_instring(soap, tag, a, type, SOAP_TYPE__QName, 2, 0, -1, NULL);
	return a;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_new__QName(struct soap *soap, int n)
{
	char * *a = static_cast<char * *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(char *)));
	for (char * *p = a; p && n--; ++p)
		soap_default__QName(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put__QName(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	if (soap_out__QName(soap, tag ? tag : "QName", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get__QName(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in__QName(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_string(struct soap *soap, char *const*a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
#ifndef WITH_NOIDREF
	(void)soap_reference(soap, *a, SOAP_TYPE_string);
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_string(struct soap *soap, const char *tag, int id, char *const*a, const char *type)
{
	return soap_outstring(soap, tag, id, a, type, SOAP_TYPE_string);
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_in_string(struct soap *soap, const char *tag, char **a, const char *type)
{
	a = soap_instring(soap, tag, a, type, SOAP_TYPE_string, 1, 0, -1, NULL);
	return a;
}

SOAP_FMAC3 char * * SOAP_FMAC4 soap_new_string(struct soap *soap, int n)
{
	char * *a = static_cast<char * *>(soap_malloc(soap, (n = (n < 0 ? 1 : n)) * sizeof(char *)));
	for (char * *p = a; p && n--; ++p)
		soap_default_string(soap, p);
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_string(struct soap *soap, char *const*a, const char *tag, const char *type)
{
	if (soap_out_string(soap, tag ? tag : "string", -2, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char ** SOAP_FMAC4 soap_get_string(struct soap *soap, char **p, const char *tag, const char *type)
{
	if ((p = soap_in_string(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

#if defined(__BORLANDC__)
#pragma option pop
#pragma option pop
#endif

/* End of soapC.cpp */
