/*
 * Decompiled with CFR 0.152.
 */
package ccl.servlet;

import ccl.servlet.HTML;
import ccl.servlet.XMLImportHandler;
import ccl.util.FileUtil;
import ccl.util.Util;
import http.utils.multipartrequest.ServletMultipartRequest;
import java.io.IOException;
import java.sql.Connection;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class XMLImporter
extends HttpServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HTML html = new HTML(response);
        html.printTitle(this.getTitle());
        html.println("<form method=\"post\" enctype=\"multipart/form-data\" action=\"" + ((Object)((Object)this)).getClass().getName() + "\">");
        html.println("Specify name of xml file to import:");
        html.println("<input type=\"file\" name=\"xmlfile\"><p>");
        html.println("<input type=\"submit\" name=\"Submit\">");
        html.println("</form>");
        html.close();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HTML html = new HTML(response);
        String sXMLFile = this.getXMLFile(request);
        this.processXML(html, sXMLFile);
        html.close();
    }

    public void processXML(HTML html, String sXMLFile) {
        try {
            html.printTitle(this.getTitle());
            Connection connection = this.getConnection();
            XMLImportHandler.parse(connection, sXMLFile);
            connection.close();
        }
        catch (Exception exception) {
            Util.printlnErr(exception);
            html.println("<pre>" + exception.getMessage() + "\n" + Util.getStackTrace(exception) + "</pre>");
        }
        html.println("XML file was received successfully.");
    }

    private String getXMLFile(HttpServletRequest request) throws IOException {
        String sTempDir = FileUtil.getTempDir();
        ServletMultipartRequest multirequest = new ServletMultipartRequest(request, sTempDir, 0x10000000);
        String sXMLFile = multirequest.getFile("xmlfile").getPath();
        Util.debug((Object)this, (Object)("getXMLFile(..).file: " + sXMLFile));
        return sXMLFile;
    }

    public abstract Connection getConnection();

    public abstract String getTitle();
}

