/*
 * Decompiled with CFR 0.152.
 */
package ccl.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalScrollButton;

public class CCLScrollButton
extends MetalScrollButton {
    private static Color shadowColor;
    private static Color highlightColor;
    private boolean isFreeStanding = false;
    private int buttonWidth;

    public CCLScrollButton(int direction, int width, boolean freeStanding) {
        super(direction, width, freeStanding);
        shadowColor = UIManager.getColor("ScrollBar.darkShadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        this.buttonWidth = width;
        this.isFreeStanding = freeStanding;
    }

    public void setFreeStanding(boolean freeStanding) {
        this.isFreeStanding = freeStanding;
    }

    public void paint(Graphics g) {
        ColorUIResource arrowColor;
        boolean isEnabled = this.getParent().isEnabled();
        boolean isPressed = this.getModel().isPressed();
        ColorUIResource colorUIResource = arrowColor = isEnabled ? MetalLookAndFeel.getControlShadow() : MetalLookAndFeel.getControlDisabled();
        if (isPressed) {
            arrowColor = isEnabled ? MetalLookAndFeel.getControlHighlight() : MetalLookAndFeel.getControlDarkShadow();
        }
        int width = this.getWidth();
        int height = this.getHeight();
        int w = width;
        int h = height;
        int arrowHeight = (height + 1) / 4;
        int arrowWidth = (height + 1) / 2;
        if (isPressed) {
            g.setColor(MetalLookAndFeel.getControlShadow());
        } else {
            g.setColor(this.getBackground());
        }
        g.fillRect(0, 0, width, height);
        if (this.getDirection() == 1) {
            if (!this.isFreeStanding) {
                width += 2;
            }
            g.setColor(arrowColor);
            int startY = (h + 1 - arrowHeight) / 2;
            int startX = w / 2;
            int line = 0;
            while (line < arrowHeight) {
                g.drawLine(startX - line, startY + line, startX + line + 1, startY + line);
                ++line;
            }
            if (isEnabled) {
                g.setColor(highlightColor);
                if (!isPressed) {
                    g.drawLine(1, 1, width - 3, 1);
                    g.drawLine(1, 1, 1, height - 1);
                }
                g.drawLine(width - 1, 1, width - 1, height - 1);
                g.setColor(shadowColor);
                g.drawLine(0, 0, width - 2, 0);
                g.drawLine(0, 0, 0, height - 1);
                g.drawLine(width - 2, 2, width - 2, height - 1);
            } else {
                CCLScrollButton.drawDisabledBorder(g, 0, 0, width, height + 1);
            }
            if (!this.isFreeStanding) {
                width -= 2;
            }
        } else if (this.getDirection() == 5) {
            if (!this.isFreeStanding) {
                width += 2;
                ++height;
            }
            g.setColor(arrowColor);
            int startY = (h + 1 - arrowHeight) / 2 + arrowHeight - 1;
            int startX = w / 2;
            int line = 0;
            while (line < arrowHeight) {
                g.drawLine(startX - line, startY - line, startX + line + 1, startY - line);
                ++line;
            }
            if (isEnabled) {
                g.setColor(highlightColor);
                if (!isPressed) {
                    g.drawLine(1, 0, width - 3, 0);
                    g.drawLine(1, 0, 1, height - 3);
                }
                g.drawLine(1, height - 1, width - 1, height - 1);
                g.drawLine(width - 1, 0, width - 1, height - 1);
                g.setColor(shadowColor);
                g.drawLine(0, 0, 0, height - 2);
                g.drawLine(width - 2, 0, width - 2, height - 2);
                g.drawLine(2, height - 2, width - 2, height - 2);
            } else {
                CCLScrollButton.drawDisabledBorder(g, 0, -1, width, height + 1);
            }
            if (!this.isFreeStanding) {
                width -= 2;
                --height;
            }
        } else if (this.getDirection() == 3) {
            if (!this.isFreeStanding) {
                height += 2;
                ++width;
            }
            g.setColor(arrowColor);
            int startX = (w + 1 - arrowHeight) / 2 + arrowHeight - 1;
            int startY = h / 2;
            int line = 0;
            while (line < arrowHeight) {
                g.drawLine(startX - line, startY - line, startX - line, startY + line + 1);
                ++line;
            }
            if (isEnabled) {
                g.setColor(highlightColor);
                if (!isPressed) {
                    g.drawLine(0, 1, width - 3, 1);
                    g.drawLine(0, 1, 0, height - 3);
                }
                g.drawLine(width - 1, 1, width - 1, height - 1);
                g.drawLine(0, height - 1, width - 1, height - 1);
                g.setColor(shadowColor);
                g.drawLine(0, 0, width - 2, 0);
                g.drawLine(width - 2, 2, width - 2, height - 2);
                g.drawLine(0, height - 2, width - 2, height - 2);
            } else {
                CCLScrollButton.drawDisabledBorder(g, -1, 0, width + 1, height);
            }
            if (!this.isFreeStanding) {
                height -= 2;
                --width;
            }
        } else if (this.getDirection() == 7) {
            if (!this.isFreeStanding) {
                height += 2;
                ++width;
                g.translate(-1, 0);
            }
            g.setColor(arrowColor);
            int startX = (w + 1 - arrowHeight) / 2;
            int startY = h / 2;
            int line = 0;
            while (line < arrowHeight) {
                g.drawLine(startX + line, startY - line, startX + line, startY + line + 1);
                ++line;
            }
            if (isEnabled) {
                g.setColor(highlightColor);
                if (!isPressed) {
                    g.drawLine(1, 1, width - 1, 1);
                    g.drawLine(1, 1, 1, height - 3);
                }
                g.drawLine(1, height - 1, width - 1, height - 1);
                g.setColor(shadowColor);
                g.drawLine(0, 0, width - 1, 0);
                g.drawLine(0, 0, 0, height - 2);
                g.drawLine(2, height - 2, width - 1, height - 2);
            } else {
                CCLScrollButton.drawDisabledBorder(g, 0, 0, width + 1, height);
            }
            if (!this.isFreeStanding) {
                height -= 2;
                --width;
                g.translate(1, 0);
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.getDirection() == 1) {
            return new Dimension(this.buttonWidth, this.buttonWidth - 2);
        }
        if (this.getDirection() == 5) {
            return new Dimension(this.buttonWidth, this.buttonWidth - (this.isFreeStanding ? 1 : 2));
        }
        if (this.getDirection() == 3) {
            return new Dimension(this.buttonWidth - (this.isFreeStanding ? 1 : 2), this.buttonWidth);
        }
        if (this.getDirection() == 7) {
            return new Dimension(this.buttonWidth - 2, this.buttonWidth);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public int getButtonWidth() {
        return this.buttonWidth;
    }

    static void drawDisabledBorder(Graphics g, int x, int y, int w, int h) {
        g.translate(x, y);
        g.setColor(MetalLookAndFeel.getControlShadow());
        g.drawRect(0, 0, w - 1, h - 1);
    }
}

