/*
 * Decompiled with CFR 0.152.
 */
package javancss;

import ccl.swing.AboutDialog;
import ccl.swing.AnimationPanel;
import ccl.swing.AutoGridBagLayout;
import ccl.swing.MainJFrame;
import ccl.swing.SwingUtil;
import ccl.util.FileUtil;
import ccl.util.Init;
import ccl.util.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;
import javancss.Javancss;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.border.SoftBevelBorder;

public class JavancssFrame
extends MainJFrame {
    public static final String S_PACKAGES = "Packages";
    public static final String S_CLASSES = "Classes";
    public static final String S_METHODS = "Methods";
    private static final String S_MN_F_SAVE = "Save";
    private int _oldThreadPriority = -1;
    private AnimationPanel _pAnimationPanel = null;
    private JTextArea _txtPackage;
    private JTextArea _txtObject;
    private JTextArea _txtFunction;
    private JTextArea _txtError;
    private JTabbedPane _pTabbedPane = null;
    private Font pFont = new Font("Monospaced", 0, 12);
    private boolean _bNoError = true;
    private String _sProjectName = null;
    private String _sProjectPath = null;
    private Init _pInit = null;
    private boolean _bStop = false;
    private boolean _bSave = false;
    private boolean _bAboutSelected = false;

    public void save() {
        String sFullProjectName = FileUtil.concatPath((String)this._sProjectPath, (String)this._sProjectName.toLowerCase());
        String sPackagesFullFileName = sFullProjectName + ".packages.txt";
        String sClassesFullFileName = sFullProjectName + ".classes.txt";
        String sMethodsFullFileName = sFullProjectName + ".methods.txt";
        String sSuccessMessage = "Data appended successfully to the following files:";
        try {
            FileUtil.appendFile((String)sPackagesFullFileName, (String)this._txtPackage.getText());
            sSuccessMessage = sSuccessMessage + "\n" + sPackagesFullFileName;
        }
        catch (Exception ePackages) {
            SwingUtil.showMessage((Frame)((Object)this), (String)("Error: could not append to file '" + sPackagesFullFileName + "'.\n" + ePackages));
        }
        try {
            FileUtil.appendFile((String)sClassesFullFileName, (String)this._txtObject.getText());
            sSuccessMessage = sSuccessMessage + "\n" + sClassesFullFileName;
        }
        catch (Exception eClasses) {
            SwingUtil.showMessage((Frame)((Object)this), (String)("Error: could not append to file '" + sClassesFullFileName + "'.\n" + eClasses));
        }
        try {
            FileUtil.appendFile((String)sMethodsFullFileName, (String)this._txtFunction.getText());
            sSuccessMessage = sSuccessMessage + "\n" + sMethodsFullFileName;
        }
        catch (Exception eMethods) {
            SwingUtil.showMessage((Frame)((Object)this), (String)("Error: could not append to file '" + sMethodsFullFileName + "'.\n" + eMethods));
        }
        SwingUtil.showMessage((Frame)((Object)this), (String)sSuccessMessage);
    }

    private void _setMenuBar() {
        Vector vMenus = new Vector();
        Vector<String> vFileMenu = new Vector<String>();
        Vector<String> vHelpMenu = new Vector<String>();
        vFileMenu.addElement("File");
        vFileMenu.addElement(S_MN_F_SAVE);
        vFileMenu.addElement("Exit");
        vHelpMenu.addElement("Help");
        vHelpMenu.addElement("&Contents...");
        vHelpMenu.addElement("---");
        vHelpMenu.addElement("About...");
        vMenus.addElement(vFileMenu);
        vMenus.addElement(vHelpMenu);
        this.setMenuBar(vMenus);
    }

    public Init getInit() {
        return this._pInit;
    }

    public JavancssFrame(Init pInit_) {
        super("JavaNCSS: " + pInit_.getFileName());
        this._pInit = pInit_;
        this.getInit().setAuthor("Chr. Clemens Lee");
        super.setBackground(this._pInit.getBackground());
        this._sProjectName = pInit_.getFileName();
        this._sProjectPath = pInit_.getFilePath();
        if (Util.isEmpty((String)this._sProjectName)) {
            this._sProjectName = pInit_.getApplicationName();
            this._sProjectPath = pInit_.getApplicationPath();
        }
        this._setMenuBar();
        this._bAboutSelected = false;
        AutoGridBagLayout pAutoGridBagLayout = new AutoGridBagLayout();
        this.getContentPane().setLayout((LayoutManager)pAutoGridBagLayout);
        Image pImage = Toolkit.getDefaultToolkit().getImage(SwingUtil.createCCLBorder().getClass().getResource("anim_recycle_brown.gif"));
        this._pAnimationPanel = new AnimationPanel(pImage, 350L);
        JPanel pPanel = new JPanel();
        pPanel.setBorder(new SoftBevelBorder(1));
        pPanel.add((Component)this._pAnimationPanel, "Center");
        this.getContentPane().add(pPanel);
        this.pack();
        this.setSize(640, 480);
        SwingUtil.centerComponent((Component)((Object)this));
    }

    public void showJavancss(Javancss pJavancss_) {
        this._bStop = false;
        this._bSave = false;
        if (this._oldThreadPriority != -1) {
            Thread.currentThread().setPriority(this._oldThreadPriority);
            this._pAnimationPanel.stop();
        }
        this.getContentPane().removeAll();
        this.getContentPane().setLayout(new BorderLayout());
        this._bNoError = true;
        if (pJavancss_.getLastErrorMessage() != null && pJavancss_.getNcss() <= 0) {
            this._bNoError = false;
            JTextArea txtError = new JTextArea();
            String sError = "Error in Javancss: " + pJavancss_.getLastErrorMessage();
            txtError.setText(sError);
            JScrollPane jspError = new JScrollPane(txtError);
            this.getContentPane().add((Component)jspError, "Center");
        } else {
            Util.debug((Object)"JavancssFrame.showJavancss(..).NOERROR");
            JPanel pPanel = new JPanel(true);
            pPanel.setLayout(new BorderLayout());
            this._pTabbedPane = new JTabbedPane();
            this._pTabbedPane.setDoubleBuffered(true);
            this._txtPackage = new JTextArea();
            this._txtPackage.setFont(this.pFont);
            JScrollPane jspPackage = new JScrollPane(this._txtPackage);
            int inset = 5;
            jspPackage.setBorder(BorderFactory.createEmptyBorder(inset, inset, inset, inset));
            this._pTabbedPane.addTab(S_PACKAGES, null, jspPackage);
            this._txtObject = new JTextArea();
            this._txtObject.setFont(this.pFont);
            JScrollPane jspObject = new JScrollPane(this._txtObject);
            jspObject.setBorder(BorderFactory.createEmptyBorder(inset, inset, inset, inset));
            this._pTabbedPane.addTab(S_CLASSES, null, jspObject);
            this._txtFunction = new JTextArea();
            this._txtFunction.setFont(this.pFont);
            JScrollPane jspFunction = new JScrollPane(this._txtFunction);
            jspFunction.setBorder(BorderFactory.createEmptyBorder(inset, inset, inset, inset));
            this._pTabbedPane.addTab(S_METHODS, null, jspFunction);
            String sTimeZoneID = System.getProperty("user.timezone");
            if (sTimeZoneID.equals("CET")) {
                sTimeZoneID = "ECT";
            }
            TimeZone pTimeZone = TimeZone.getTimeZone(sTimeZoneID);
            Util.debug((Object)("JavancssFrame.showJavancss(..).pTimeZone.getID(): " + pTimeZone.getID()));
            SimpleDateFormat pSimpleDateFormat = new SimpleDateFormat("EEE, MMM dd, yyyy  HH:mm:ss");
            pSimpleDateFormat.setTimeZone(pTimeZone);
            String sDate = pSimpleDateFormat.format(new Date()) + " " + pTimeZone.getID();
            this._txtPackage.setText(sDate + "\n\n" + pJavancss_.printPackageNcss());
            this._txtObject.setText(sDate + "\n\n" + pJavancss_.printObjectNcss());
            this._txtFunction.setText(sDate + "\n\n" + pJavancss_.printFunctionNcss());
            if (pJavancss_.getLastErrorMessage() != null) {
                this._txtError = new JTextArea();
                String sError = "Errors in Javancss:\n\n" + pJavancss_.getLastErrorMessage();
                this._txtError.setText(sError);
                JScrollPane jspError = new JScrollPane(this._txtError);
                jspError.setBorder(BorderFactory.createEmptyBorder(inset, inset, inset, inset));
                this.getContentPane().add((Component)jspError, "Center");
                this._pTabbedPane.addTab("Errors", null, jspError);
            }
            pPanel.add((Component)this._pTabbedPane, "Center");
            this.getContentPane().add((Component)pPanel, "Center");
        }
        this.validate();
        this.repaint();
    }

    public void run() {
        this._bSave = false;
        while (!this._bStop) {
            if (this._bSave) {
                this.save();
                this._bSave = false;
            }
            if (this.isExitSet()) {
                this.exit();
                this._bStop = true;
                break;
            }
            if (this._bAboutSelected) {
                this._bAboutSelected = false;
                AboutDialog dlgAbout = new AboutDialog((Frame)((Object)this), this.getInit().getAuthor(), "$Header: /home/clemens/src/java/javancss/src/javancss/RCS/Main.java,v 28.49 2006/10/06 11:46:24 clemens Exp clemens $");
                dlgAbout.dispose();
                this.requestFocus();
            }
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public void setVisible(boolean bVisible_) {
        if (bVisible_) {
            this._oldThreadPriority = Thread.currentThread().getPriority();
            this._pAnimationPanel.start();
            Thread.currentThread().setPriority(1);
        } else {
            this._pAnimationPanel.stop();
        }
        super.setVisible(bVisible_);
    }

    public void setSelectedTab(String sTab_) {
        Util.panicIf((boolean)Util.isEmpty((String)sTab_));
        if (!this._bNoError) {
            return;
        }
        if (sTab_.equals(S_METHODS)) {
            this._pTabbedPane.setSelectedIndex(2);
        } else if (sTab_.equals(S_CLASSES)) {
            this._pTabbedPane.setSelectedIndex(1);
        } else {
            this._pTabbedPane.setSelectedIndex(0);
        }
    }

    public void actionPerformed(ActionEvent pActionEvent_) {
        block4: {
            String sMenuItem;
            block7: {
                block6: {
                    block5: {
                        Util.debug((Object)"JavancssFrame.actionPerformed(..).1");
                        Object oSource = pActionEvent_.getSource();
                        if (!(oSource instanceof JMenuItem)) break block4;
                        sMenuItem = ((JMenuItem)oSource).getText();
                        if (!sMenuItem.equals("Beenden") && !sMenuItem.equals("Exit")) break block5;
                        this.processWindowEvent(new WindowEvent((Window)((Object)this), 201));
                        break block4;
                    }
                    if (!sMenuItem.equals(S_MN_F_SAVE)) break block6;
                    this._bSave = true;
                    break block4;
                }
                if (!sMenuItem.equals("Info...") && !sMenuItem.equals("About...") && !sMenuItem.equals("Info") && !sMenuItem.equals("About")) break block7;
                this._bAboutSelected = true;
                break block4;
            }
            if (!sMenuItem.equals("Inhalt...") && !sMenuItem.equals("Contents...") && !sMenuItem.equals("Inhalt") && !sMenuItem.equals("Contents")) break block4;
            String sStartURL = FileUtil.concatPath((String)FileUtil.getPackagePath((String)"javancss"), (String)"doc") + File.separator + "index.html";
            if (Util.isEmpty((String)sStartURL)) {
                return;
            }
            if ((sStartURL = sStartURL.replace('\\', '/')).charAt(0) != '/') {
                sStartURL = "/" + sStartURL;
            }
            sStartURL = "file:" + sStartURL;
            Util.debug((Object)("JavancssFrame.actionPerformed(): sStartURL: " + sStartURL));
            try {
                URL urlHelpDocument = new URL(sStartURL);
            }
            catch (Exception pException) {
                Util.debug((Object)("JavancssFrame.actionPerformed(..).pException: " + pException));
            }
        }
    }
}

