/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi.compiler;

import java.io.InputStream;
import java.io.StringWriter;
import org.objectweb.carol.cmi.compiler.XMLElement;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLTree
extends DefaultHandler {
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private XMLElement root;
    private XMLElement cur;
    private boolean chars;
    private StringWriter str;

    public XMLTree() {
        this.cur = this.root = new XMLElement(null, null, null);
        this.chars = false;
        this.str = new StringWriter();
    }

    private void flushChars() {
        if (!this.chars) {
            return;
        }
        this.cur.add(this.str.toString());
        this.str.getBuffer().setLength(0);
        this.chars = false;
    }

    public void startDocument() {
        this.flushChars();
    }

    public void endDocument() throws SAXException {
        this.flushChars();
        if (this.cur != this.root) {
            throw new SAXException("Unexpected end of document");
        }
    }

    public void startElement(String uri, String name, String qName, Attributes attrs) throws SAXException {
        this.flushChars();
        XMLElement e = new XMLElement(this.cur, name, attrs);
        this.cur.add(e);
        this.cur = e;
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        this.flushChars();
        if (!name.equals(this.cur.name)) {
            throw new SAXException("endElement \"" + name + "\" not corresponding with the startElement \"" + this.cur.name + "\"");
        }
        this.cur = this.cur.parent;
        if (this.cur == null) {
            throw new SAXException("endElement \"" + name + "\" with no corresponding startElement");
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        this.str.write(ch, start, length);
        this.chars = true;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
        this.flushChars();
    }

    public void warning(SAXParseException ex) {
        System.err.println("[Warning] " + XMLTree.getLocationString(ex) + ": " + ex.getMessage());
    }

    public void error(SAXParseException ex) {
        System.err.println("[Error] " + XMLTree.getLocationString(ex) + ": " + ex.getMessage());
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        System.err.println("[Fatal Error] " + XMLTree.getLocationString(ex) + ": " + ex.getMessage());
        throw ex;
    }

    public static String getLocationString(SAXParseException ex) {
        StringBuffer str = new StringBuffer();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        return str.toString();
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        try {
            int limit = systemId.lastIndexOf(47);
            if (limit < 0) {
                return null;
            }
            String base = systemId.substring(limit + 1);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            InputStream in = cl.getResourceAsStream("org/objectweb/carol/cmi/compiler/dtd/" + base);
            return new InputSource(in);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static XMLElement read(String uri) throws Exception {
        XMLTree t = new XMLTree();
        XMLReader parser = (XMLReader)Class.forName(DEFAULT_PARSER_NAME).newInstance();
        parser.setContentHandler(t);
        parser.setErrorHandler(t);
        parser.setEntityResolver(t);
        parser.setFeature("http://xml.org/sax/features/validation", true);
        parser.parse(uri);
        return t.root;
    }
}

