/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint;

import com.github.sbaudoin.yamllint.Linter;
import java.util.Objects;
import javax.annotation.Nullable;

public class LintProblem {
    private int line;
    private int column;
    private String desc = "<no description>";
    private String extraDesc;
    private String ruleId;
    private String level;

    public LintProblem(int line, int column, @Nullable String desc) {
        this(line, column, desc, null, null);
    }

    public LintProblem(int line, int column, @Nullable String desc, @Nullable String ruleId) {
        this(line, column, desc, ruleId, null);
    }

    public LintProblem(int line, int column, @Nullable String desc, @Nullable String ruleId, @Nullable String extraDesc) {
        this.line = line;
        this.column = column;
        if (desc != null) {
            this.desc = desc;
        }
        this.ruleId = ruleId;
        this.extraDesc = extraDesc;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getExtraDesc() {
        return this.extraDesc;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getMessage() {
        if (this.ruleId != null) {
            return String.format("%1$2s (%2$2s)", this.desc, this.ruleId);
        }
        return this.desc;
    }

    public String getLongMessage() {
        if (this.ruleId != null) {
            return String.format("%1$2s (%2$2s)%3$s%4$s", this.desc, this.ruleId, this.extraDesc == null ? "" : System.lineSeparator(), this.extraDesc == null ? "" : this.extraDesc);
        }
        return this.desc + (this.extraDesc == null ? "" : System.lineSeparator() + this.extraDesc);
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        Object intLevel = Linter.getProblemLevel(level);
        if (intLevel != null) {
            this.level = (String)Linter.getProblemLevel(intLevel);
        }
    }

    public void setRuleId(@Nullable String ruleId) {
        this.ruleId = ruleId;
    }

    public void setExtraDesc(@Nullable String extraDesc) {
        this.extraDesc = extraDesc;
    }

    public boolean equals(@Nullable Object o) {
        if (o instanceof LintProblem) {
            return ((LintProblem)o).line == this.line && ((LintProblem)o).column == this.column && Objects.equals(this.ruleId, ((LintProblem)o).ruleId);
        }
        return false;
    }

    public int hashCode() {
        return (this.line + ":" + this.column + ":" + this.ruleId).hashCode();
    }

    public String toString() {
        return String.format("%1$d:%2$d:%3$2s", this.line, this.column, this.getMessage());
    }
}

