/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbaudoin.yamllint.rules;

import com.github.sbaudoin.yamllint.rules.Rule;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class RuleFactory {
    private static final Logger LOGGER = Logger.getLogger(RuleFactory.class.getName());
    public static final RuleFactory instance = new RuleFactory();
    private final Map<String, Rule> rules = new HashMap<String, Rule>();

    public Rule getRule(String id) {
        if (this.rules.containsKey(id)) {
            return this.rules.get(id);
        }
        Reflections reflections = new Reflections(this.getClass().getPackage().getName(), new Scanner[0]);
        Set subTypes = reflections.getSubTypesOf(Rule.class);
        for (Class c : subTypes) {
            if (Modifier.isAbstract(c.getModifiers()) || c.isAnonymousClass()) continue;
            try {
                Rule rule = (Rule)c.newInstance();
                if (!rule.getId().equals(id)) continue;
                this.rules.put(rule.getId(), rule);
                return rule;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, String.format("Cannot instantiate rule class %s, will ignore it", c.getName()), e);
            }
        }
        return null;
    }

    private RuleFactory() {
    }
}

