/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.util;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jreleaser.bundle.RB;
import org.jreleaser.util.JavaRuntimeVersion;
import org.jreleaser.util.ObjectUtils;
import org.jreleaser.util.StringUtils;

public class Version
implements Comparable<Version> {
    private static final Pattern FULL_SEMVER_PATTERN = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:([\\.\\-])((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    private static final Pattern MAJOR_MINOR_PATTERN = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:([\\.\\-])((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    private static final Pattern MAJOR_PATTERN = Pattern.compile("^(0|[1-9]\\d*)(?:([\\.\\-])((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    private final int major;
    private final int minor;
    private final int patch;
    private final String tagsep;
    private final String tag;
    private final String build;

    private Version(int major, int minor, int patch, String tagsep, String tag, String build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.tagsep = StringUtils.isNotBlank(tagsep) ? tagsep.trim() : null;
        this.tag = StringUtils.isNotBlank(tag) ? tag.trim() : null;
        String string = this.build = StringUtils.isNotBlank(build) ? build.trim() : null;
        if (StringUtils.isNotBlank(tagsep)) {
            ObjectUtils.requireState(tagsep.equals(".") || tagsep.equals("-"), "Argument 'tagsep' must not be '.' or '-'");
        }
    }

    public boolean hasMinor() {
        return this.minor != -1;
    }

    public boolean hasPatch() {
        return this.patch != -1;
    }

    public boolean hasTag() {
        return StringUtils.isNotBlank(this.tag);
    }

    public boolean hasBuild() {
        return StringUtils.isNotBlank(this.build);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String getTag() {
        return this.tag;
    }

    public String getBuild() {
        return this.build;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.major);
        if (this.hasMinor()) {
            b.append(".").append(this.minor);
        }
        if (this.hasPatch()) {
            b.append(".").append(this.patch);
        }
        if (this.hasTag()) {
            b.append(this.tagsep).append(this.tag);
        }
        if (this.hasBuild()) {
            b.append("+").append(this.build);
        }
        return b.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.major == version.major && this.minor == version.minor && this.patch == version.patch && Objects.equals(this.tag, version.tag) && Objects.equals(this.build, version.build);
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.tag, this.build);
    }

    @Override
    public int compareTo(Version other) {
        int result = this.major - other.major;
        if (result == 0 && (result = this.minor - other.minor) == 0) {
            result = this.patch - other.patch;
        }
        if (result == 0 && StringUtils.isNotBlank(this.tag)) {
            result = this.tag.compareTo(other.tag);
        }
        if (result == 0 && StringUtils.isNotBlank(this.build)) {
            result = this.build.compareTo(other.build);
        }
        return result;
    }

    public static int javaMajorVersion() {
        String jv = System.getProperty("java.version");
        if (jv.startsWith("1.")) {
            return 8;
        }
        return JavaRuntimeVersion.of(jv).feature();
    }

    public static Version of(String version) {
        StringUtils.requireNonBlank(version, "Argument 'version' must not be blank");
        Matcher m = FULL_SEMVER_PATTERN.matcher(version.trim());
        if (m.matches()) {
            String major = m.group(1);
            String minor = m.group(2);
            String patch = m.group(3);
            String tagsep = m.group(4);
            String tag = m.group(5);
            String build = m.group(6);
            return Version.of(Integer.parseInt(major), Integer.parseInt(minor), Integer.parseInt(patch), StringUtils.isNotBlank(tagsep) ? tagsep : null, StringUtils.isNotBlank(tag) ? tag : null, StringUtils.isNotBlank(build) ? build : null);
        }
        m = MAJOR_MINOR_PATTERN.matcher(version);
        if (m.matches()) {
            String major = m.group(1);
            String minor = m.group(2);
            String tagsep = m.group(3);
            String tag = m.group(4);
            String build = m.group(5);
            return Version.of(Integer.parseInt(major), Integer.parseInt(minor), StringUtils.isNotBlank(tagsep) ? tagsep : null, StringUtils.isNotBlank(tag) ? tag : null, StringUtils.isNotBlank(build) ? build : null);
        }
        m = MAJOR_PATTERN.matcher(version);
        if (m.matches()) {
            String major = m.group(1);
            String tagsep = m.group(2);
            String tag = m.group(3);
            String build = m.group(4);
            return Version.of(Integer.parseInt(major), StringUtils.isNotBlank(tagsep) ? tagsep : null, StringUtils.isNotBlank(tag) ? tag : null, StringUtils.isNotBlank(build) ? build : null);
        }
        throw new IllegalArgumentException(RB.$("ERROR_version_parse", version));
    }

    public static Version of(int major, int minor, int patch, String tag, String build) {
        return Version.of(major, minor, patch, ".", tag, build);
    }

    public static Version of(int major, int minor, int patch, String tagsep, String tag, String build) {
        ObjectUtils.requireState(major > -1, "Argument 'major' must not be negative");
        ObjectUtils.requireState(minor > -1, "Argument 'minor' must not be negative");
        ObjectUtils.requireState(patch > -1, "Argument 'patch' must not be negative");
        return new Version(major, minor, patch, tagsep, tag, build);
    }

    public static Version of(int major, int minor, String tag, String build) {
        return Version.of(major, minor, ".", tag, build);
    }

    public static Version of(int major, int minor, String tagsep, String tag, String build) {
        ObjectUtils.requireState(major > -1, "Argument 'major' must not be negative");
        ObjectUtils.requireState(minor > -1, "Argument 'minor' must not be negative");
        return new Version(major, minor, -1, tagsep, tag, build);
    }

    public static Version of(int major, String tag, String build) {
        return Version.of(major, ".", tag, build);
    }

    public static Version of(int major, String tagsep, String tag, String build) {
        ObjectUtils.requireState(major > -1, "Argument 'major' must not be negative");
        return new Version(major, -1, -1, tagsep, tag, build);
    }
}

