/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.releaser.spi;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.GitService;
import org.jreleaser.model.JReleaserContext;
import org.jreleaser.model.releaser.spi.ReleaseException;
import org.jreleaser.model.releaser.spi.Releaser;

public abstract class AbstractReleaser
implements Releaser {
    protected final JReleaserContext context;
    protected final List<Path> assets = new ArrayList<Path>();

    protected AbstractReleaser(JReleaserContext context, List<Path> assets) {
        this.context = context;
        this.assets.addAll(assets);
    }

    @Override
    public final void release() throws ReleaseException {
        GitService service = this.context.getModel().getRelease().getGitService();
        if (service.isSkipRelease()) {
            if (service.isSkipTag()) {
                this.context.getLogger().info(RB.$((String)"releaser.tag.and.release.skipped", (Object[])new Object[0]));
            } else {
                this.createTag();
            }
        } else {
            this.createRelease();
        }
    }

    protected abstract void createTag() throws ReleaseException;

    protected abstract void createRelease() throws ReleaseException;
}

